/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.application.options.editor.EditorOptionsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jediterm.terminal.CursorShape;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002,-B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\nJ\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001dH\u0002J\b\u0010$\u001a\u00020\u001dH\u0003J\b\u0010%\u001a\u00020\u0019H\u0002J\b\u0010&\u001a\u0004\u0018\u00010'J\u001a\u0010(\u001a\u0004\u0018\u00010'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel;", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$CursorListener;", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$TerminalListener;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/Disposable;)V", "terminalModel", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "getTerminalModel", "()Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "listeners", "", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel$CaretListener;", "updateScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "updateAlarm", "Lcom/intellij/util/Alarm;", "state", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel$CaretState;", "getState", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel$CaretState;", "addListener", "", "listener", "disposable", "onCommandRunningChanged", "isRunning", "", "scheduleUpdate", "doUpdate", "calculateState", "getCaretPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "calculateCaretPosition", "cursorX", "", "cursorY", "CaretState", "CaretListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCaretModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCaretModel.kt\norg/jetbrains/plugins/terminal/block/output/TerminalCaretModel\n+ 2 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n*L\n1#1,129:1\n158#2,7:130\n158#2,7:137\n*S KotlinDebug\n*F\n+ 1 TerminalCaretModel.kt\norg/jetbrains/plugins/terminal/block/output/TerminalCaretModel\n*L\n87#1:130,7\n98#1:137,7\n*E\n"})
public final class TerminalCaretModel
implements TerminalModel.CursorListener,
TerminalModel.TerminalListener {
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final List<CaretListener> listeners;
    @NotNull
    private final AtomicBoolean updateScheduled;
    @NotNull
    private final Alarm updateAlarm;

    public TerminalCaretModel(@NotNull BlockTerminalSession session2, @NotNull TerminalOutputModel outputModel, @NotNull EditorEx editor, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.session = session2;
        this.outputModel = outputModel;
        this.editor = editor;
        this.listeners = new CopyOnWriteArrayList();
        this.updateScheduled = new AtomicBoolean(false);
        this.updateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
        this.getTerminalModel().addTerminalListener(this, parentDisposable);
        this.getTerminalModel().addCursorListener(new TerminalModel.CursorListener(){

            @Override
            public void onPositionChanged(int cursorX, int cursorY) {
                this.scheduleUpdate();
            }

            @Override
            public void onVisibilityChanged(boolean visible) {
                this.scheduleUpdate();
            }

            @Override
            public void onShapeChanged(CursorShape shape) {
                this.scheduleUpdate();
            }
        }, parentDisposable);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        Topic topic = EditorOptionsListener.APPEARANCE_CONFIGURABLE_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"APPEARANCE_CONFIGURABLE_TOPIC");
        connection.subscribe(topic, () -> TerminalCaretModel._init_$lambda$0(this));
    }

    private final TerminalModel getTerminalModel() {
        return this.session.getModel();
    }

    @NotNull
    public final CaretState getState() {
        return this.calculateState();
    }

    public final void addListener(@NotNull CaretListener listener2, @Nullable Disposable disposable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.listeners.add(listener2);
            Disposable disposable2 = disposable;
            if (disposable2 == null) break block0;
            Disposable it = disposable2;
            boolean bl = false;
            Disposer.register((Disposable)it, () -> TerminalCaretModel.addListener$lambda$2$lambda$1(this, listener2));
        }
    }

    public static /* synthetic */ void addListener$default(TerminalCaretModel terminalCaretModel, CaretListener caretListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalCaretModel.addListener(caretListener, disposable);
    }

    @Override
    public void onCommandRunningChanged(boolean isRunning) {
        this.scheduleUpdate();
    }

    private final void scheduleUpdate() {
        if (this.updateScheduled.compareAndSet(false, true)) {
            this.updateAlarm.addRequest(this::doUpdate, 50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void doUpdate() {
        try {
            CaretState state = this.calculateState();
            for (CaretListener listener2 : this.listeners) {
                listener2.caretStateChanged(state);
            }
        }
        finally {
            this.updateScheduled.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CaretState calculateState() {
        CaretState caretState;
        TerminalModel this_$iv = this.session.getModel();
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            LogicalPosition position = this.getTerminalModel().isCursorVisible() ? this.calculateCaretPosition(this.getTerminalModel().getCursorX(), this.getTerminalModel().getCursorY()) : null;
            CursorShape cursorShape = this.getTerminalModel().getCursorShape();
            if (cursorShape == null) {
                CursorShape cursorShape2 = this.session.getSettings().getCursorShape();
                cursorShape = cursorShape2;
                Intrinsics.checkNotNullExpressionValue((Object)cursorShape2, (String)"getCursorShape(...)");
            }
            CursorShape cursorShape3 = cursorShape;
            caretState = new CaretState(position, cursorShape3.isBlinking());
        }
        finally {
            this_$iv.unlockContent();
        }
        return caretState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final LogicalPosition getCaretPosition() {
        LogicalPosition logicalPosition;
        TerminalModel this_$iv = this.session.getModel();
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            logicalPosition = this.calculateCaretPosition(this.getTerminalModel().getCursorX(), this.getTerminalModel().getCursorY());
        }
        finally {
            this_$iv.unlockContent();
        }
        return logicalPosition;
    }

    private final LogicalPosition calculateCaretPosition(int cursorX, int cursorY) {
        CommandBlock commandBlock = TerminalOutputModelKt.getActiveBlock(this.outputModel);
        if (commandBlock == null) {
            return null;
        }
        CommandBlock activeBlock = commandBlock;
        int outputStartOffset = activeBlock.getOutputStartOffset();
        if (outputStartOffset > this.editor.getDocument().getTextLength()) {
            return null;
        }
        int blockStartLine = this.editor.getDocument().getLineNumber(outputStartOffset);
        int historyLines = this.getTerminalModel().getUseAlternateBuffer() ? 0 : this.getTerminalModel().getHistoryLinesCount();
        int blockLine = historyLines + cursorY - 1;
        return new LogicalPosition(blockStartLine + blockLine, cursorX);
    }

    private static final void _init_$lambda$0(TerminalCaretModel this$0) {
        this$0.scheduleUpdate();
    }

    private static final void addListener$lambda$2$lambda$1(TerminalCaretModel this$0, CaretListener $listener) {
        this$0.listeners.remove($listener);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel$CaretListener;", "", "caretStateChanged", "", "state", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel$CaretState;", "intellij.terminal"})
    public static interface CaretListener {
        @RequiresEdt
        default public void caretStateChanged(@NotNull CaretState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel$CaretState;", "", "position", "Lcom/intellij/openapi/editor/LogicalPosition;", "isBlinking", "", "<init>", "(Lcom/intellij/openapi/editor/LogicalPosition;Z)V", "getPosition", "()Lcom/intellij/openapi/editor/LogicalPosition;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.terminal"})
    public static final class CaretState {
        @Nullable
        private final LogicalPosition position;
        private final boolean isBlinking;

        public CaretState(@Nullable LogicalPosition position, boolean isBlinking) {
            this.position = position;
            this.isBlinking = isBlinking;
        }

        public /* synthetic */ CaretState(LogicalPosition logicalPosition, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(logicalPosition, bl);
        }

        @Nullable
        public final LogicalPosition getPosition() {
            return this.position;
        }

        public final boolean isBlinking() {
            return this.isBlinking;
        }

        @Nullable
        public final LogicalPosition component1() {
            return this.position;
        }

        public final boolean component2() {
            return this.isBlinking;
        }

        @NotNull
        public final CaretState copy(@Nullable LogicalPosition position, boolean isBlinking) {
            return new CaretState(position, isBlinking);
        }

        public static /* synthetic */ CaretState copy$default(CaretState caretState, LogicalPosition logicalPosition, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                logicalPosition = caretState.position;
            }
            if ((n & 2) != 0) {
                bl = caretState.isBlinking;
            }
            return caretState.copy(logicalPosition, bl);
        }

        @NotNull
        public String toString() {
            return "CaretState(position=" + this.position + ", isBlinking=" + this.isBlinking + ")";
        }

        public int hashCode() {
            int result2 = this.position == null ? 0 : this.position.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isBlinking);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CaretState)) {
                return false;
            }
            CaretState caretState = (CaretState)other;
            if (!Intrinsics.areEqual((Object)this.position, (Object)caretState.position)) {
                return false;
            }
            return this.isBlinking == caretState.isBlinking;
        }
    }
}

