/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalShellIntegrationEventsListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/terminal/frontend/TerminalTypeAhead;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalShellIntegrationEventsListener;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)V", "isEnabled", "", "promptEndOffset", "", "promptFinished", "", "commandStarted", "command", "", "stringTyped", "string", "backspace", "isDisabled", "intellij.terminal.frontend"})
public final class TerminalTypeAhead
implements TerminalShellIntegrationEventsListener {
    @NotNull
    private final TerminalOutputModel outputModel;
    private volatile boolean isEnabled;
    private volatile int promptEndOffset;

    public TerminalTypeAhead(@NotNull TerminalOutputModel outputModel) {
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        this.outputModel = outputModel;
    }

    @Override
    public void promptFinished() {
        this.isEnabled = true;
        this.promptEndOffset = ((Number)this.outputModel.getCursorOffsetState().getValue()).intValue();
    }

    @Override
    public void commandStarted(@NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        this.isEnabled = false;
    }

    public final void stringTyped(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (this.isDisabled()) {
            return;
        }
        this.outputModel.insertAtCursor(string);
    }

    public final void backspace() {
        if (this.isDisabled()) {
            return;
        }
        if (((Number)this.outputModel.getCursorOffsetState().getValue()).intValue() > this.promptEndOffset) {
            this.outputModel.backspace();
        }
    }

    private final boolean isDisabled() {
        return !Registry.Companion.is("terminal.type.ahead", false) || !this.isEnabled;
    }
}

