/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import java.util.ArrayList;
import java.util.Iterator;

public class TokenIterator
implements Iterator<ClangToken> {
    private ClangTokenGroup[] nodeStack;
    private ClangToken currentToken;
    private int[] indexStack;
    private int depth;
    private int direction;

    private void expand() {
        int size = this.nodeStack.length < 256 ? this.nodeStack.length * 2 : this.nodeStack.length + 512;
        ClangTokenGroup[] newNodeStack = new ClangTokenGroup[size];
        int[] newIndexStack = new int[size];
        System.arraycopy(this.nodeStack, 0, newNodeStack, 0, this.nodeStack.length);
        System.arraycopy(this.indexStack, 0, newIndexStack, 0, this.indexStack.length);
        this.nodeStack = newNodeStack;
        this.indexStack = newIndexStack;
    }

    private void pushGroup(ClangTokenGroup group) {
        ++this.depth;
        if (this.depth >= this.nodeStack.length) {
            this.expand();
        }
        this.nodeStack[this.depth] = group;
        this.indexStack[this.depth] = this.direction < 0 ? group.numChildren() - 1 : 0;
    }

    private void normalize() {
        int index = this.indexStack[this.depth];
        if (index < 0) {
            --this.depth;
            if (this.depth < 0) {
                this.currentToken = null;
                return;
            }
            int n = this.depth;
            this.indexStack[n] = this.indexStack[n] - 1;
            this.normalize();
            return;
        }
        ClangTokenGroup group = this.nodeStack[this.depth];
        if (index >= group.numChildren()) {
            --this.depth;
            if (this.depth < 0) {
                this.currentToken = null;
                return;
            }
            int n = this.depth;
            this.indexStack[n] = this.indexStack[n] + 1;
            this.normalize();
            return;
        }
        ClangNode node = group.Child(index);
        if (node instanceof ClangToken) {
            this.currentToken = (ClangToken)node;
            return;
        }
        this.pushGroup((ClangTokenGroup)node);
        this.normalize();
    }

    private void advanceToken() {
        if (this.currentToken == null) {
            return;
        }
        int n = this.depth;
        this.indexStack[n] = this.indexStack[n] + this.direction;
        this.normalize();
    }

    private static int findIndex(ClangNode group, ClangNode node) {
        for (int i = 0; i < group.numChildren(); ++i) {
            if (group.Child(i) != node) continue;
            return i;
        }
        return -1;
    }

    public TokenIterator(ClangToken token, boolean forward) {
        ClangNode node;
        ArrayList<ClangTokenGroup> groupList = new ArrayList<ClangTokenGroup>();
        for (node = token.Parent(); node != null; node = node.Parent()) {
            groupList.add((ClangTokenGroup)node);
        }
        this.nodeStack = new ClangTokenGroup[groupList.size()];
        this.indexStack = new int[groupList.size()];
        node = token;
        for (int i = 0; i < this.nodeStack.length; ++i) {
            ClangTokenGroup group;
            this.nodeStack[this.nodeStack.length - 1 - i] = group = (ClangTokenGroup)groupList.get(i);
            this.indexStack[this.nodeStack.length - 1 - i] = TokenIterator.findIndex(group, node);
            node = group;
        }
        this.currentToken = token;
        this.direction = forward ? 1 : -1;
        this.depth = this.nodeStack.length - 1;
    }

    public TokenIterator(ClangTokenGroup group, boolean forward) {
        ArrayList<ClangTokenGroup> groupList = new ArrayList<ClangTokenGroup>();
        ClangNode node = group;
        while (node instanceof ClangTokenGroup) {
            ClangTokenGroup curGroup = node;
            groupList.add(curGroup);
            if (forward) {
                node = curGroup.Child(0);
                continue;
            }
            node = curGroup.Child(curGroup.numChildren() - 1);
        }
        this.nodeStack = new ClangTokenGroup[groupList.size()];
        this.indexStack = new int[groupList.size()];
        groupList.toArray(this.nodeStack);
        for (int i = 0; i < this.indexStack.length; ++i) {
            this.indexStack[i] = forward ? 0 : this.nodeStack[i].numChildren() - 1;
        }
        this.currentToken = (ClangToken)node;
        this.direction = forward ? 1 : -1;
        this.depth = this.nodeStack.length - 1;
    }

    @Override
    public boolean hasNext() {
        return this.currentToken != null;
    }

    @Override
    public ClangToken next() {
        ClangToken res = this.currentToken;
        this.advanceToken();
        return res;
    }
}

