/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import com.google.protobuf.GeneratedMessageV3;
import ghidra.app.plugin.core.debug.client.tracermi.ProtobufSocket;
import ghidra.app.plugin.core.debug.client.tracermi.RmiClient;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTrace;
import ghidra.rmi.trace.TraceRmi;
import ghidra.util.Msg;

public class RmiReplyHandlerThread
extends Thread {
    private RmiClient client;
    private ProtobufSocket<TraceRmi.RootMessage> socket;
    private boolean terminated = false;

    public RmiReplyHandlerThread(RmiClient client, ProtobufSocket<TraceRmi.RootMessage> socket) {
        this.client = client;
        this.socket = socket;
    }

    @Override
    public void run() {
        block11: while (!this.terminated) {
            try {
                TraceRmi.RootMessage msg = this.socket.recv();
                if (msg.hasXrequestInvokeMethod()) {
                    try {
                        TraceRmi.XRequestInvokeMethod req = msg.getXrequestInvokeMethod();
                        int id = req.getOid().getId();
                        RmiTrace trace = this.client.traces.get(id);
                        TraceRmi.XReplyInvokeMethod reply = trace.handleInvokeMethod(req);
                        this.socket.send(TraceRmi.RootMessage.newBuilder().setXreplyInvokeMethod(reply).build());
                    }
                    catch (Exception e) {
                        Msg.error((Object)this, (Object)"Error handling method invocation", (Throwable)e);
                        this.socket.send(TraceRmi.RootMessage.newBuilder().setXreplyInvokeMethod(TraceRmi.XReplyInvokeMethod.newBuilder().setError(e.toString())).build());
                    }
                    continue;
                }
                RmiClient.RequestResult result = this.client.pollRequest();
                if (result == null) {
                    System.err.println("REPLY without request: " + String.valueOf(msg));
                    continue;
                }
                TraceRmi.RootMessage request = result.request;
                switch (msg.getMsgCase()) {
                    case ERROR: {
                        Msg.error((Object)this, (Object)msg.getError().getMessage());
                        result.completeExceptionally(new RmiClient.RmiException(msg.getError().getMessage()));
                        continue block11;
                    }
                    case REPLY_CREATE_OBJECT: {
                        GeneratedMessageV3 reply = msg.getReplyCreateObject();
                        RmiTrace trace = this.client.traces.get(request.getRequestCreateObject().getOid().getId());
                        result.complete(trace.handleCreateObject((TraceRmi.ReplyCreateObject)reply));
                        continue block11;
                    }
                    case REPLY_CREATE_TRACE: {
                        GeneratedMessageV3 reply = msg.getReplyCreateTrace();
                        RmiTrace trace = this.client.traces.get(request.getRequestCreateTrace().getOid().getId());
                        result.complete(trace.handleCreateTrace((TraceRmi.ReplyCreateTrace)reply));
                        continue block11;
                    }
                    case REPLY_GET_VALUES: {
                        GeneratedMessageV3 reply = msg.getReplyGetValues();
                        RmiTrace trace = this.client.traces.get(request.getRequestGetValues().getOid().getId());
                        result.complete(trace.handleGetValues((TraceRmi.ReplyGetValues)reply));
                        continue block11;
                    }
                    case REPLY_DISASSEMBLE: {
                        GeneratedMessageV3 reply = msg.getReplyDisassemble();
                        RmiTrace trace = this.client.traces.get(request.getRequestDisassemble().getOid().getId());
                        result.complete(trace.handleDisassemble((TraceRmi.ReplyDisassemble)reply));
                        continue block11;
                    }
                }
                result.complete(null);
            }
            catch (Exception e) {
                if (e.getMessage() == null) {
                    Msg.error((Object)this, (Object)"Error processing reply", (Throwable)e);
                    continue;
                }
                Msg.error((Object)this, (Object)e.getMessage());
            }
        }
        Msg.info((Object)this, (Object)"Handler exiting");
    }

    public void close() {
        this.terminated = true;
    }
}

