/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.Preconditions;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.swing.TableModelEventAdapter;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class JXTableSupport<E> {
    private JXTable table;
    private JXTableMemento tableMemento;
    private AdvancedTableModel<E> tableModel;
    private AdvancedListSelectionModel<E> selectionModel;
    private TableFormat<? super E> tableFormat;
    private TableComparatorChooser<E> tableComparatorChooser;

    public static <E> JXTableSupport<E> install(JXTable table, EventList<E> eventList, TableFormat<? super E> tableFormat, SortedList<E> sortedList, Object sortingStrategy) {
        Preconditions.checkNotNull(table, "JXTable must be defined.");
        Preconditions.checkNotNull(eventList, "EventList must be defined.");
        Preconditions.checkNotNull(tableFormat, "TableFormat must be defined.");
        Preconditions.checkNotNull(sortedList, "SortedList must be defined.");
        Preconditions.checkNotNull(sortingStrategy, "SortingStrategy must be defined.");
        JXTableSupport.checkAccessThread();
        return new JXTableSupport<E>(table, eventList, tableFormat, sortedList, sortingStrategy);
    }

    public JXTable getTable() {
        return this.table;
    }

    public AdvancedListSelectionModel<E> getTableSelectionModel() {
        return this.selectionModel;
    }

    public AdvancedTableModel<E> getTableModel() {
        return this.tableModel;
    }

    public TableFormat<? super E> getTableFormat() {
        return this.tableFormat;
    }

    public TableComparatorChooser<E> getTableComparatorChooser() {
        return this.tableComparatorChooser;
    }

    public void uninstall() {
        JXTableSupport.checkAccessThread();
        this.tableComparatorChooser.dispose();
        this.tableMemento.restoreStateTo(this.table);
        this.tableModel.dispose();
        this.selectionModel.dispose();
        this.tableComparatorChooser = null;
        this.tableModel = null;
        this.selectionModel = null;
        this.tableFormat = null;
        this.table = null;
        this.tableMemento = null;
    }

    public boolean isInstalled() {
        return this.table != null;
    }

    private JXTableSupport(JXTable table, EventList<E> eventList, TableFormat<? super E> tableFormat, SortedList<E> sortedList, Object sortingStrategy) {
        this.table = table;
        this.tableFormat = tableFormat;
        this.tableMemento = JXTableMemento.create(table);
        this.tableMemento.storeStateFrom(table);
        this.tableMemento.configureStateForGlazedLists(table);
        if (table.getFillsViewportHeight()) {
            TableModelEventAdapter.Factory eventAdapterFactory = GlazedListsSwing.manyToOneEventAdapterFactory();
            this.tableModel = GlazedListsSwing.eventTableModelWithThreadProxyList(eventList, tableFormat, eventAdapterFactory);
        } else {
            this.tableModel = GlazedListsSwing.eventTableModelWithThreadProxyList(eventList, tableFormat);
        }
        table.setModel(this.tableModel);
        this.selectionModel = GlazedListsSwing.eventSelectionModelWithThreadProxyList(eventList);
        table.setSelectionModel(this.selectionModel);
        this.tableComparatorChooser = TableComparatorChooser.install((JTable)table, sortedList, sortingStrategy, tableFormat);
    }

    private static void checkAccessThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("JXTableSupport must be accessed from the Swing Event Dispatch Thread, but was called on Thread \"" + Thread.currentThread().getName() + "\"");
        }
    }

    private static class JXTable16Memento
    extends JXTableMemento {
        private boolean oldAutoCreateRowSorter;
        private RowSorter<? extends TableModel> oldRowSorter;

        private JXTable16Memento() {
        }

        @Override
        public void storeStateFrom(JXTable table) {
            super.storeStateFrom(table);
            this.oldAutoCreateRowSorter = table.getAutoCreateRowSorter();
            this.oldRowSorter = table.getRowSorter();
        }

        @Override
        public void restoreStateTo(JXTable table) {
            super.restoreStateTo(table);
            table.setAutoCreateRowSorter(this.oldAutoCreateRowSorter);
            table.setRowSorter(this.oldRowSorter);
        }

        @Override
        public void configureStateForGlazedLists(JXTable table) {
            super.configureStateForGlazedLists(table);
            table.setAutoCreateRowSorter(false);
            table.setRowSorter(null);
        }
    }

    private static abstract class JXTableMemento {
        private TableModel oldTableModel;
        private ListSelectionModel oldSelectionModel;
        private boolean oldSortable;

        private JXTableMemento() {
        }

        public void storeStateFrom(JXTable table) {
            this.oldTableModel = table.getModel();
            this.oldSelectionModel = table.getSelectionModel();
            this.oldSortable = table.isSortable();
        }

        public void restoreStateTo(JXTable table) {
            table.setModel(this.oldTableModel);
            table.setSelectionModel(this.oldSelectionModel);
            table.setSortable(this.oldSortable);
        }

        public void configureStateForGlazedLists(JXTable table) {
            table.setSortable(false);
        }

        public static JXTableMemento create(JXTable table) {
            return new JXTable16Memento();
        }
    }
}

