/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.symbol.ThunkReference;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class FunctionSymbol
extends SymbolDB {
    private FunctionManagerDB functionMgr;

    public FunctionSymbol(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, Address address, DBRecord record) {
        super(symbolMgr, cache, address, record);
        this.functionMgr = symbolMgr.getFunctionManager();
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.FUNCTION;
    }

    @Override
    public boolean isExternal() {
        return this.address.isExternalAddress();
    }

    boolean isThunk() {
        return this.functionMgr.isThunk(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNameAndNamespace(String newName, Namespace newNamespace, SourceType source) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.lock.acquire();
        try {
            boolean namespaceChange = !this.getParentNamespace().equals(newNamespace);
            super.setNameAndNamespace(newName, newNamespace, source);
            if (namespaceChange) {
                this.functionMgr.functionNamespaceChanged(this.key);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete() {
        this.lock.acquire();
        try {
            boolean restoreLabel = this.isExternal() || this.getSource() != SourceType.DEFAULT;
            String symName = this.getName();
            String extData = null;
            if (this.isExternal()) {
                extData = this.getSymbolStringData();
            }
            Namespace namespace = this.getParentNamespace();
            SourceType source = this.getSource();
            boolean pinned = this.isPinned();
            if (this.getID() > 0L) {
                this.symbolMgr.removeChildren(this);
            }
            if (!this.functionMgr.doRemoveFunction(this.key)) {
                boolean bl = false;
                return bl;
            }
            if (super.delete()) {
                boolean restored;
                if (restoreLabel && !(restored = this.createLabelForDeletedFunctionName(this.address, symName, extData, namespace, source, pinned)) && this.isExternal()) {
                    this.symbolMgr.getReferenceManager().removeAllReferencesTo(this.getAddress());
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    private boolean createLabelForDeletedFunctionName(Address entryPoint, String symName, String stringData, Namespace namespace, SourceType source, boolean pinned) {
        Symbol parentSymbol = namespace.getSymbol();
        if (parentSymbol instanceof SymbolDB && ((SymbolDB)parentSymbol).isDeleting()) {
            return false;
        }
        try {
            Symbol newSym = this.symbolMgr.createCodeSymbol(entryPoint, symName, namespace, source, stringData);
            newSym.setPrimary();
            if (pinned) {
                newSym.setPinned(true);
            }
            return true;
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public Object getObject() {
        return this.functionMgr.getFunction(this.key);
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean isPinned() {
        if (!this.isExternal()) {
            return this.doIsPinned();
        }
        return false;
    }

    @Override
    public void setPinned(boolean pinned) {
        if (!this.isExternal()) {
            this.doSetPinned(pinned);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramLocation getProgramLocation() {
        this.lock.acquire();
        try {
            if (!this.checkIsValid()) {
                ProgramLocation programLocation = null;
                return programLocation;
            }
            Function f = (Function)this.getObject();
            String signature = f.getPrototypeString(false, false);
            FunctionReturnTypeFieldLocation functionReturnTypeFieldLocation = new FunctionReturnTypeFieldLocation(this.getProgram(), this.address, 0, signature, f.getReturnType().getName());
            return functionReturnTypeFieldLocation;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return super.isValidParent(parent) && SymbolType.FUNCTION.isValidParent(this.symbolMgr.getProgram(), parent, this.address, this.isExternal());
    }

    @Override
    protected String doGetName() {
        if (this.getSource() == SourceType.DEFAULT) {
            if (this.isExternal()) {
                return ExternalManagerDB.getDefaultExternalName(this);
            }
            Symbol thunkedSymbol = this.getThunkedSymbol();
            if (thunkedSymbol instanceof FunctionSymbol) {
                FunctionSymbol thunkedFuncSym = (FunctionSymbol)thunkedSymbol;
                Object thunkName = thunkedFuncSym.getName();
                if (thunkedFuncSym.getSource() == SourceType.DEFAULT && thunkedFuncSym.getThunkedSymbol() == null) {
                    thunkName = "thunk_" + (String)thunkName;
                }
                return thunkName;
            }
            return SymbolUtilities.getDefaultFunctionName(this.address);
        }
        return super.doGetName();
    }

    @Override
    protected Namespace doGetParentNamespace() {
        Symbol thunkedSymbol;
        if (this.getSource() == SourceType.DEFAULT && (thunkedSymbol = this.getThunkedSymbol()) instanceof FunctionSymbol) {
            FunctionSymbol thunkedFuncSym = (FunctionSymbol)thunkedSymbol;
            return thunkedFuncSym.getParentNamespace();
        }
        return super.doGetParentNamespace();
    }

    private Symbol getThunkedSymbol() {
        long thunkedFunctionId = this.functionMgr.getThunkedFunctionId(this.key);
        return thunkedFunctionId >= 0L ? this.symbolMgr.getSymbol(thunkedFunctionId) : null;
    }

    @Override
    protected SourceType validateNameSource(String newName, SourceType source) {
        String defaultName;
        if (newName == null || newName.length() == 0) {
            return SourceType.DEFAULT;
        }
        if (this.isExternal() ? SymbolUtilities.isReservedDynamicLabelName(newName, this.symbolMgr.getProgram().getAddressFactory()) : (defaultName = SymbolUtilities.getDynamicName(6, this.address)).equals(newName)) {
            return SourceType.DEFAULT;
        }
        if (source == SourceType.DEFAULT) {
            source = SourceType.ANALYSIS;
        }
        return source;
    }

    @Override
    protected List<SymbolDB> getSymbolsDynamicallyRenamedByMyRename() {
        List<Long> thunkFunctionIds = this.functionMgr.getThunkFunctionIds(this.key);
        if (thunkFunctionIds == null) {
            return null;
        }
        ArrayList<SymbolDB> list = new ArrayList<SymbolDB>(thunkFunctionIds.size());
        for (long id : thunkFunctionIds) {
            SymbolDB s = (SymbolDB)this.symbolMgr.getSymbol(id);
            if (s == null || s.getSource() != SourceType.DEFAULT) continue;
            list.add(s);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference[] getReferences(TaskMonitor monitor) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Reference[] refs = super.getReferences(monitor);
            if (monitor == null) {
                monitor = TaskMonitor.DUMMY;
            }
            if (monitor.isCancelled()) {
                Reference[] referenceArray = refs;
                return referenceArray;
            }
            List<Long> thunkIds = this.functionMgr.getThunkFunctionIds(this.key);
            if (thunkIds == null) {
                Reference[] referenceArray = refs;
                return referenceArray;
            }
            int thunkCnt = thunkIds.size();
            Reference[] newRefs = new Reference[refs.length + thunkCnt];
            System.arraycopy(refs, 0, newRefs, thunkCnt, refs.length);
            for (int i = 0; i < thunkCnt; ++i) {
                if (monitor.isCancelled()) {
                    Reference[] referenceArray = refs;
                    return referenceArray;
                }
                Symbol s = this.symbolMgr.getSymbol(thunkIds.get(i));
                newRefs[i] = new ThunkReference(s.getAddress(), this.getAddress());
                monitor.setProgress((long)(refs.length + i));
            }
            Reference[] referenceArray = newRefs;
            return referenceArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReferenceCount() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int count = super.getReferenceCount();
            List<Long> thunkIds = this.functionMgr.getThunkFunctionIds(this.key);
            if (thunkIds != null) {
                count += thunkIds.size();
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasMultipleReferences() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (super.hasMultipleReferences()) {
                boolean bl = true;
                return bl;
            }
            List<Long> thunkIds = this.functionMgr.getThunkFunctionIds(this.key);
            if (thunkIds != null) {
                boolean bl = thunkIds.size() > 1;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasReferences() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (super.hasReferences()) {
                boolean bl = true;
                return bl;
            }
            List<Long> thunkIds = this.functionMgr.getThunkFunctionIds(this.key);
            boolean bl = thunkIds != null ? thunkIds.size() != 0 : false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }
}

