/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.ActionBindingPanel;
import docking.DockingActionInputBindingListener;
import docking.DockingUtils;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.actions.KeyBindingUtils;
import docking.actions.KeyBindings;
import docking.actions.ToolActions;
import docking.widgets.EmptyBorderButton;
import docking.widgets.MultiLineLabel;
import docking.widgets.OptionDialog;
import docking.widgets.label.GIconLabel;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.Gui;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import gui.event.MouseBinding;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import resources.Icons;

public class KeyBindingsPanel
extends JPanel {
    private static final int STATUS_LABEL_HEIGHT = 60;
    private static final int ACTION_NAME = 0;
    private static final int KEY_BINDING = 1;
    private static final int PLUGIN_NAME = 2;
    private static final String FONT_ID = "font.keybindings.status";
    private JTextPane statusLabel;
    private GTable actionTable;
    private JPanel infoPanel;
    private MultiLineLabel collisionLabel;
    private KeyBindingsTableModel tableModel;
    private ActionBindingListener actionBindingListener = new ActionBindingListener();
    private ActionBindingPanel actionBindingPanel;
    private GTableFilterPanel<DockingActionIf> tableFilterPanel;
    private EmptyBorderButton helpButton;
    private KeyBindings keyBindings;
    private boolean unappliedChanges;
    private PluginTool tool;
    private boolean firingTableDataChanged;
    private PropertyChangeListener propertyChangeListener;

    public KeyBindingsPanel(PluginTool tool) {
        this.tool = tool;
        this.keyBindings = new KeyBindings((Tool)tool);
        this.createPanelComponents();
        this.initializeTableWidth();
    }

    public void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListener = listener;
    }

    public void dispose() {
        this.tableFilterPanel.dispose();
        this.propertyChangeListener = null;
    }

    public void apply() {
        this.keyBindings.applyChanges();
        this.changesMade(false);
    }

    public void cancel() {
        this.keyBindings.cancelChanges();
        this.tableModel.fireTableDataChanged();
    }

    public void reload() {
        Swing.runLater(() -> {
            this.actionTable.clearSelection();
            this.restoreDefaultKeybindings();
        });
    }

    public String getStatusText() {
        return this.statusLabel.getText();
    }

    private void initializeTableWidth() {
        String longestName = this.keyBindings.getLongestActionName();
        Font f = this.actionTable.getFont();
        FontMetrics fm = this.actionTable.getFontMetrics(f);
        int maxWidth = 0;
        for (int i = 0; i < longestName.length(); ++i) {
            char c = longestName.charAt(i);
            maxWidth += fm.charWidth(c);
        }
        TableColumn col = this.actionTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(maxWidth);
        this.tableModel.fireTableDataChanged();
    }

    private void createPanelComponents() {
        this.setLayout(new BorderLayout(10, 10));
        this.tableModel = new KeyBindingsTableModel(new ArrayList<DockingActionIf>(this.keyBindings.getUniqueActions()));
        this.actionTable = new GTable((TableModel)((Object)this.tableModel));
        JScrollPane sp = new JScrollPane((Component)this.actionTable);
        this.actionTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.actionTable.setSelectionMode(0);
        this.actionTable.setHTMLRenderingEnabled(true);
        this.adjustTableColumns();
        JPanel importExportPanel = this.createImportExportPanel();
        this.tableFilterPanel = new GTableFilterPanel((JTable)this.actionTable, (RowObjectTableModel)this.tableModel);
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)this.tableFilterPanel, "North");
        middlePanel.add((Component)importExportPanel, "South");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)sp, "Center");
        centerPanel.add((Component)middlePanel, "South");
        JPanel keyPanel = this.createKeyEntryPanel();
        JPanel statusPanel = this.createStatusPanel(keyPanel);
        this.add((Component)centerPanel, "Center");
        this.add((Component)statusPanel, "South");
        this.actionTable.getSelectionModel().addListSelectionListener(new TableSelectionListener());
    }

    private JPanel createStatusPanel(JPanel keyPanel) {
        this.statusLabel = new JTextPane();
        this.statusLabel.setEnabled(false);
        DockingUtils.setTransparent((JComponent)this.statusLabel);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 5));
        this.statusLabel.setContentType("text/html");
        this.statusLabel.setPreferredSize(new Dimension(0, 60));
        this.statusLabel.setFont(Gui.getFont((String)FONT_ID));
        this.helpButton = new EmptyBorderButton(Icons.HELP_ICON);
        this.helpButton.setEnabled(false);
        this.helpButton.addActionListener(e -> {
            DockingActionIf action = this.getSelectedAction();
            HelpService hs = Help.getHelpService();
            hs.showHelp((Object)action, false, (Component)this);
        });
        JPanel helpButtonPanel = new JPanel();
        helpButtonPanel.setLayout(new BoxLayout(helpButtonPanel, 3));
        helpButtonPanel.add((Component)this.helpButton);
        helpButtonPanel.add(Box.createVerticalGlue());
        JPanel lowerStatusPanel = new JPanel();
        lowerStatusPanel.setLayout(new BoxLayout(lowerStatusPanel, 0));
        lowerStatusPanel.add(helpButtonPanel);
        lowerStatusPanel.add(this.statusLabel);
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.add(keyPanel);
        panel.add(lowerStatusPanel);
        return panel;
    }

    private JPanel createKeyEntryPanel() {
        this.actionBindingPanel = new ActionBindingPanel((DockingActionInputBindingListener)this.actionBindingListener);
        JPanel p = new JPanel(new FlowLayout(0));
        p.add((Component)this.actionBindingPanel);
        JPanel keyPanel = new JPanel(new BorderLayout());
        JPanel defaultPanel = new JPanel(new BorderLayout());
        MultiLineLabel mlabel = new MultiLineLabel("To add or change a key binding, select an action\nand type any key combination.");
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        BoxLayout bl = new BoxLayout(labelPanel, 0);
        labelPanel.setLayout(bl);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add((Component)new GIconLabel(Icons.INFO_ICON));
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add((Component)mlabel);
        defaultPanel.add((Component)labelPanel, "North");
        defaultPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.infoPanel = new JPanel(new FlowLayout(1));
        this.collisionLabel = new MultiLineLabel(" ");
        this.collisionLabel.setName("CollisionLabel");
        this.infoPanel.add((Component)this.collisionLabel);
        JScrollPane sp = new JScrollPane(this.infoPanel);
        sp.setPreferredSize(defaultPanel.getPreferredSize());
        JPanel innerPanel = new JPanel((LayoutManager)new PairLayout(2, 6));
        innerPanel.add(defaultPanel);
        innerPanel.add(sp);
        keyPanel.add((Component)innerPanel, "Center");
        keyPanel.add((Component)p, "South");
        return keyPanel;
    }

    private JPanel createImportExportPanel() {
        JButton importButton = new JButton("Import...");
        importButton.setToolTipText("Load key binding settings from a file");
        importButton.addActionListener(event -> {
            boolean continueImport = this.showImportPrompt();
            if (!continueImport) {
                return;
            }
            Swing.runLater(() -> {
                this.actionTable.clearSelection();
                this.loadKeyBindingsFromImportedOptions((Options)KeyBindingUtils.importKeyBindings());
            });
        });
        JButton exportButton = new JButton("Export...");
        exportButton.setToolTipText("Save key binding settings to a file");
        exportButton.addActionListener(event -> {
            boolean continueExport = this.showApplyPrompt();
            if (!continueExport) {
                return;
            }
            Swing.runLater(() -> {
                ToolOptions keyBindingOptions = this.tool.getOptions("Key Bindings");
                KeyBindingUtils.exportKeyBindings((ToolOptions)keyBindingOptions);
            });
        });
        JPanel containerPanel = new JPanel(new FlowLayout(2));
        containerPanel.add(importButton);
        containerPanel.add(exportButton);
        return containerPanel;
    }

    private boolean showApplyPrompt() {
        boolean continueOperation = true;
        if (this.unappliedChanges) {
            int userChoice = OptionDialog.showYesNoCancelDialog((Component)this, (String)"Apply Changes?", (String)"Apply current key binding changes?");
            if (userChoice == 1) {
                this.apply();
            } else if (userChoice == 0) {
                continueOperation = false;
            }
        }
        return continueOperation;
    }

    private boolean showImportPrompt() {
        int userChoice = OptionDialog.showYesNoDialog((Component)this, (String)"Continue Import?", (String)"Importing key bindings will overwrite the current settings.\nDo you want to continue?");
        return userChoice == 1;
    }

    private Map<String, KeyStroke> createActionNameToKeyStrokeMap(Options keyBindingOptions) {
        HashMap<String, KeyStroke> localActionMap = new HashMap<String, KeyStroke>();
        List optionNames = keyBindingOptions.getOptionNames();
        for (String name : optionNames) {
            ActionTrigger actionTrigger = keyBindingOptions.getActionTrigger(name, null);
            KeyStroke optionsKs = null;
            if (actionTrigger != null) {
                optionsKs = actionTrigger.getKeyStroke();
            }
            localActionMap.put(name, optionsKs);
        }
        return localActionMap;
    }

    private void adjustTableColumns() {
        this.actionTable.doLayout();
        TableColumn column = this.actionTable.getColumn((Object)this.actionTable.getColumnName(0));
        column.setPreferredWidth(250);
        column = this.actionTable.getColumn((Object)this.actionTable.getColumnName(1));
        column.setPreferredWidth(100);
        column = this.actionTable.getColumn((Object)this.actionTable.getColumnName(2));
        column.setPreferredWidth(150);
    }

    private void restoreDefaultKeybindings() {
        this.keyBindings.restoreOptions();
        this.tableModel.fireTableDataChanged();
    }

    private void changesMade(boolean changes) {
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", this.unappliedChanges, changes));
        this.unappliedChanges = changes;
    }

    private DockingActionIf getSelectedAction() {
        if (this.actionTable.getSelectedRowCount() == 0) {
            return null;
        }
        int selectedRow = this.actionTable.getSelectedRow();
        return (DockingActionIf)this.tableFilterPanel.getRowObject(selectedRow);
    }

    private String getSelectedActionName() {
        DockingActionIf action = this.getSelectedAction();
        if (action == null) {
            return null;
        }
        return action.getFullName();
    }

    private void showActionsMappedToKeyStroke(KeyStroke ks) {
        String text = this.keyBindings.getActionsForKeyStrokeText(ks);
        if (StringUtils.isBlank((CharSequence)text)) {
            text = " ";
        }
        this.updateCollisionPanel(text);
    }

    private void clearInfoPanel() {
        this.updateCollisionPanel(" ");
    }

    private void updateCollisionPanel(String text) {
        this.infoPanel.removeAll();
        this.infoPanel.repaint();
        this.collisionLabel = new MultiLineLabel(text);
        this.collisionLabel.setName("CollisionLabel");
        this.infoPanel.add((Component)this.collisionLabel);
        this.infoPanel.invalidate();
        this.validate();
    }

    private void loadKeyBindingsFromImportedOptions(Options keyBindingOptions) {
        if (keyBindingOptions == null) {
            return;
        }
        Map<String, KeyStroke> keyStrokesByActionName = this.createActionNameToKeyStrokeMap(keyBindingOptions);
        boolean changes = false;
        for (String name : keyStrokesByActionName.keySet()) {
            KeyStroke keyStroke = keyStrokesByActionName.get(name);
            keyStroke = KeyBindingUtils.validateKeyStroke((KeyStroke)keyStroke);
            if (!this.keyBindings.containsAction(name)) continue;
            changes |= this.setActionKeyStroke(name, keyStroke);
        }
        if (changes) {
            this.changesMade(true);
            this.tableModel.fireTableDataChanged();
        }
    }

    private void updateKeyStroke(KeyStroke ks) {
        this.clearInfoPanel();
        DockingActionIf action = this.getSelectedAction();
        if (action == null) {
            this.statusLabel.setText("No action is selected.");
            return;
        }
        ToolActions toolActions = (ToolActions)this.tool.getToolActions();
        String errorMessage = toolActions.validateActionKeyBinding(action, ks);
        if (errorMessage != null) {
            this.actionBindingPanel.clearKeyStroke();
            this.statusLabel.setText(errorMessage);
            return;
        }
        String selectedActionName = action.getFullName();
        if (this.setActionKeyStroke(selectedActionName, ks)) {
            this.showActionsMappedToKeyStroke(ks);
            this.tableModel.fireTableDataChanged();
            this.changesMade(true);
        }
    }

    private void updateMouseBinding(MouseBinding mb) {
        this.clearInfoPanel();
        DockingActionIf action = this.getSelectedAction();
        if (action == null) {
            this.statusLabel.setText("No action is selected.");
            return;
        }
        String selectedActionName = action.getFullName();
        if (this.setMouseBinding(selectedActionName, mb)) {
            this.tableModel.fireTableDataChanged();
            this.changesMade(true);
        }
    }

    private boolean setMouseBinding(String actionName, MouseBinding mouseBinding) {
        if (this.keyBindings.isMouseBindingInUse(actionName, mouseBinding)) {
            String existingName = this.keyBindings.getActionForMouseBinding(mouseBinding);
            String message = "Mouse binding '%s' already in use by '%s'.\nThe existing binding must be cleared before it can be used again.\n".formatted(mouseBinding, existingName);
            Msg.showInfo((Object)this, (Component)this.actionBindingPanel, (String)"Mouse Binding In Use", (Object)message);
            this.actionBindingPanel.clearMouseBinding();
            return false;
        }
        return this.keyBindings.setActionMouseBinding(actionName, mouseBinding);
    }

    private boolean setActionKeyStroke(String actionName, KeyStroke keyStroke) {
        if (!this.isValidKeyStroke(keyStroke)) {
            this.actionBindingPanel.clearKeyStroke();
            return this.keyBindings.removeKeyStroke(actionName);
        }
        return this.keyBindings.setActionKeyStroke(actionName, keyStroke);
    }

    private boolean isValidKeyStroke(KeyStroke ks) {
        if (ks == null) {
            return false;
        }
        char keyChar = ks.getKeyChar();
        return !Character.isWhitespace(keyChar) && Character.getType(keyChar) != 15;
    }

    Map<String, KeyStroke> getKeyStrokeMap() {
        return this.keyBindings.getKeyStrokesByFullActionName();
    }

    private class ActionBindingListener
    implements DockingActionInputBindingListener {
        private ActionBindingListener() {
        }

        public void keyStrokeChanged(KeyStroke ks) {
            KeyBindingsPanel.this.updateKeyStroke(ks);
        }

        public void mouseBindingChanged(MouseBinding mb) {
            KeyBindingsPanel.this.updateMouseBinding(mb);
        }
    }

    private class KeyBindingsTableModel
    extends AbstractSortedTableModel<DockingActionIf> {
        private final String[] columnNames;
        private List<DockingActionIf> actions;

        KeyBindingsTableModel(List<DockingActionIf> actions) {
            super(0);
            this.columnNames = new String[]{"Action Name", "KeyBinding", "Plugin Name"};
            this.actions = actions;
        }

        public String getName() {
            return "Keybindings";
        }

        public Object getColumnValueForRow(DockingActionIf action, int columnIndex) {
            String fullName = action.getFullName();
            switch (columnIndex) {
                case 0: {
                    return action.getName();
                }
                case 1: {
                    MouseBinding mb;
                    Object text = "";
                    KeyStroke ks = KeyBindingsPanel.this.keyBindings.getKeyStroke(fullName);
                    if (ks != null) {
                        text = (String)text + KeyBindingUtils.parseKeyStroke((KeyStroke)ks);
                    }
                    if ((mb = KeyBindingsPanel.this.keyBindings.getMouseBinding(fullName)) != null) {
                        text = (String)text + " (" + mb.getDisplayText() + ")";
                    }
                    return ((String)text).trim();
                }
                case 2: {
                    return action.getOwnerDescription();
                }
            }
            return "Unknown Column!";
        }

        public List<DockingActionIf> getModelData() {
            return this.actions;
        }

        public boolean isSortable(int columnIndex) {
            return true;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.actions.size();
        }

        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || KeyBindingsPanel.this.firingTableDataChanged) {
                return;
            }
            KeyBindingsPanel.this.helpButton.setEnabled(false);
            String fullActionName = KeyBindingsPanel.this.getSelectedActionName();
            if (fullActionName == null) {
                KeyBindingsPanel.this.statusLabel.setText("");
                KeyBindingsPanel.this.actionBindingPanel.setEnabled(false);
                return;
            }
            KeyBindingsPanel.this.actionBindingPanel.setEnabled(true);
            KeyBindingsPanel.this.helpButton.setEnabled(true);
            KeyBindingsPanel.this.clearInfoPanel();
            KeyStroke ks = KeyBindingsPanel.this.keyBindings.getKeyStroke(fullActionName);
            if (ks != null) {
                KeyBindingsPanel.this.showActionsMappedToKeyStroke(ks);
            }
            MouseBinding mb = KeyBindingsPanel.this.keyBindings.getMouseBinding(fullActionName);
            KeyBindingsPanel.this.actionBindingPanel.setKeyBindingData(ks, mb);
            KeyBindingsPanel.this.statusLabel.setPreferredSize(new Dimension(KeyBindingsPanel.this.statusLabel.getPreferredSize().width, 60));
            DockingActionIf action = KeyBindingsPanel.this.getSelectedAction();
            String description = action.getDescription();
            if (description == null || description.trim().isEmpty()) {
                description = action.getName();
            }
            KeyBindingsPanel.this.statusLabel.setText("<html>" + HTMLUtilities.escapeHTML((String)description));
        }
    }
}

