/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.data;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import sarif.export.data.ExtIsfDataTypeWriter;

public class ExtDataTypeWriterTask
extends Task {
    private final DataTypeManager programDataTypeMgr;
    private final List<DataType> dataTypeList;
    private final File file;

    public ExtDataTypeWriterTask(DataTypeManager programDataTypeMgr, List<DataType> dataTypeList, File file) {
        super("Export Data Types", true, false, true);
        this.programDataTypeMgr = programDataTypeMgr;
        this.dataTypeList = dataTypeList;
        this.file = file;
    }

    public void run(TaskMonitor monitor) {
        try {
            monitor.setMessage("Export to " + this.file.getName() + "...");
            try (ExtIsfDataTypeWriter dataTypeWriter = new ExtIsfDataTypeWriter(this.programDataTypeMgr, this.dataTypeList, new FileWriter(this.file));){
                dataTypeWriter.getRootObject(monitor);
            }
        }
        catch (CancelledException dataTypeWriter) {
        }
        catch (IOException e) {
            Msg.error((Object)"Export Data Types Failed", (Object)("Error exporting Data Types: " + String.valueOf(e)));
            return;
        }
    }
}

