/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.bitpatterns.info.FunctionBitPatternsGTreeNode;
import ghidra.bitpatterns.info.FunctionBitPatternsGTreeRootNode;
import ghidra.bitpatterns.info.InstructionSequence;
import ghidra.bitpatterns.info.PatternType;
import ghidra.bitpatterns.info.PercentageFilter;
import java.util.HashMap;
import java.util.List;

public class FunctionBitPatternsGTree
extends GTree {
    private int totalNum = 0;
    private PatternType type;

    public FunctionBitPatternsGTree(FunctionBitPatternsGTreeRootNode root, PatternType type) {
        super((GTreeNode)root);
        this.type = type;
    }

    public int getTotalNum() {
        return this.totalNum;
    }

    public PatternType getType() {
        return this.type;
    }

    public void setTotalNum(int totalNum) {
        this.totalNum = totalNum;
    }

    public static FunctionBitPatternsGTree createTree(List<InstructionSequence> instSeqs, PatternType patternType, PercentageFilter percentageFilter) {
        FunctionBitPatternsGTreeRootNode root = new FunctionBitPatternsGTreeRootNode();
        HashMap nodeMap = new HashMap();
        block0: for (InstructionSequence currentSeq : instSeqs) {
            FunctionBitPatternsGTreeRootNode currentNode = root;
            int maxLevel = currentSeq.getInstructions().length;
            String[] currentInsts = currentSeq.getInstructions();
            for (int level = 0; level < maxLevel; ++level) {
                GTreeNode currentNodeChild;
                StringBuilder keyBuilder = new StringBuilder();
                if (currentInsts[level] == null) continue block0;
                keyBuilder.append(currentSeq.getInstructions()[level]);
                keyBuilder.append(":");
                keyBuilder.append(Integer.toString(currentSeq.getSizes()[level]));
                String key = keyBuilder.toString();
                HashMap<String, GTreeNode> currentNodeChildMap = (HashMap<String, GTreeNode>)nodeMap.get((Object)currentNode);
                if (nodeMap.get((Object)currentNode) == null) {
                    currentNodeChildMap = new HashMap<String, GTreeNode>();
                    nodeMap.put(currentNode, currentNodeChildMap);
                }
                if ((currentNodeChild = (GTreeNode)currentNodeChildMap.get(key)) == null) {
                    currentNodeChild = new FunctionBitPatternsGTreeNode(key, currentSeq.getInstructions()[level], currentSeq.getSizes()[level]);
                    ((FunctionBitPatternsGTreeNode)currentNodeChild).incrementCount(1);
                    currentNodeChildMap.put(key, currentNodeChild);
                    currentNode.addNode(currentNodeChild);
                } else {
                    ((FunctionBitPatternsGTreeNode)currentNodeChild).incrementCount(1);
                }
                currentNode = currentNodeChild;
            }
        }
        FunctionBitPatternsGTree tree = new FunctionBitPatternsGTree(root, patternType);
        tree.setTotalNum(instSeqs.size());
        root.sort();
        root.filterByPercentage(percentageFilter);
        return tree;
    }
}

