/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.tree.GTreeNode;
import java.util.Iterator;
import java.util.Stack;
import org.apache.commons.collections4.IteratorUtils;

public class DepthFirstIterator
implements Iterator<GTreeNode> {
    private Stack<Iterator<GTreeNode>> stack = new Stack();
    private Iterator<GTreeNode> it;
    private GTreeNode lastNode;

    public DepthFirstIterator(GTreeNode node) {
        this.it = IteratorUtils.singletonIterator((Object)node);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty() || this.it.hasNext();
    }

    @Override
    public GTreeNode next() {
        if (!this.it.hasNext()) {
            if (this.stack.isEmpty()) {
                return null;
            }
            this.it = this.stack.pop();
        }
        this.lastNode = this.it.next();
        if (this.lastNode.getChildCount() > 0) {
            if (this.it.hasNext()) {
                this.stack.push(this.it);
            }
            this.it = this.lastNode.getChildren().iterator();
        }
        return this.lastNode;
    }

    @Override
    public void remove() {
        GTreeNode parent = this.lastNode.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Can't delete root node!");
        }
        parent.removeNode(this.lastNode);
    }
}

