/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.ReusableDialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GLabel;
import ghidra.framework.preferences.Preferences;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

class GFileChooserOptionsDialog
extends ReusableDialogComponentProvider {
    static final String SHOW_DOT_FILES_PROPERTY_NAME = "G_FILE_CHOOSER.ShowDotFiles";
    private static final String SHOW_DOT_FILES_DEFAULT = "false";
    private JCheckBox showDotFilesCheckBox;

    GFileChooserOptionsDialog() {
        super("File Chooser Options");
        this.addWorkPanel(this.buildComponent());
        this.addOKButton();
        this.addCancelButton();
    }

    @Override
    protected void dialogShown() {
        this.initializeValues();
    }

    private JComponent buildComponent() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        this.showDotFilesCheckBox = new GCheckBox();
        this.showDotFilesCheckBox.getAccessibleContext().setAccessibleName("Show Dot Files");
        this.showDotFilesCheckBox.setSelected(true);
        GLabel label = new GLabel("Show '.' files");
        label.getAccessibleContext().setAccessibleName("Show Files");
        label.setToolTipText("When toggled on the file chooser will show files with names that begin with a '.' character");
        panel.add(this.showDotFilesCheckBox);
        panel.add(label);
        panel.getAccessibleContext().setAccessibleName("GFile Chooser Options");
        return panel;
    }

    private void initializeValues() {
        boolean showDotFiles = this.getShowsDotFiles();
        this.showDotFilesCheckBox.setSelected(showDotFiles);
    }

    @Override
    protected void okCallback() {
        Preferences.setProperty((String)SHOW_DOT_FILES_PROPERTY_NAME, (String)Boolean.toString(this.showDotFilesCheckBox.isSelected()));
        Preferences.store();
        this.close();
    }

    boolean getShowsDotFiles() {
        String showDotFilesValue = Preferences.getProperty((String)SHOW_DOT_FILES_PROPERTY_NAME, (String)SHOW_DOT_FILES_DEFAULT, (boolean)true);
        return Boolean.parseBoolean(showDotFilesValue);
    }
}

