/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.ActionContext;
import docking.action.ActionContextProvider;
import docking.theme.gui.GThemeValuesCache;
import docking.theme.gui.IconValueEditor;
import docking.theme.gui.ThemeIconTableModel;
import docking.theme.gui.ThemeTable;
import docking.theme.gui.ThemeTableContext;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.GTable;
import generic.theme.IconValue;
import generic.theme.ThemeManager;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;

public class ThemeIconTable
extends JPanel
implements ActionContextProvider,
ThemeTable {
    private ThemeIconTableModel iconTableModel;
    private IconValueEditor iconEditor = new IconValueEditor(this::iconValueChanged);
    private GTable table;
    private GFilterTable<IconValue> filterTable;
    private ThemeManager themeManager;

    public ThemeIconTable(ThemeManager themeManager, GThemeValuesCache valuesProvider) {
        super(new BorderLayout());
        this.themeManager = themeManager;
        this.iconTableModel = new ThemeIconTableModel(valuesProvider);
        this.filterTable = new GFilterTable<IconValue>(this.iconTableModel);
        this.table = this.filterTable.getTable();
        this.table.setSelectionMode(0);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    IconValue iconValue = ThemeIconTable.this.filterTable.getSelectedRowObject();
                    if (iconValue != null) {
                        ThemeIconTable.this.iconEditor.editValue(iconValue);
                    }
                    e.consume();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    IconValue value = ThemeIconTable.this.filterTable.getItemAt(e.getPoint());
                    int col = ThemeIconTable.this.filterTable.getColumn(e.getPoint());
                    TableColumn column = ThemeIconTable.this.table.getColumnModel().getColumn(col);
                    Object identifier = column.getIdentifier();
                    if ("Current Icon".equals(identifier) || "Id".equals(identifier)) {
                        ThemeIconTable.this.iconEditor.editValue(value);
                    }
                }
            }
        });
        this.add(this.filterTable, "Center");
    }

    @Override
    public void setShowSystemValues(boolean show) {
        this.iconTableModel.setShowSystemValues(show);
        this.reloadAll();
    }

    @Override
    public boolean isShowingSystemValues() {
        return this.iconTableModel.isShowingSystemValues();
    }

    void iconValueChanged(PropertyChangeEvent event) {
        Swing.runLater(() -> {
            IconValue newValue = (IconValue)event.getNewValue();
            this.themeManager.setIcon(newValue);
        });
    }

    public void reloadAll() {
        this.iconTableModel.reloadAll();
    }

    public void reloadCurrent() {
        this.iconTableModel.reloadCurrent();
    }

    @Override
    public ActionContext getActionContext(MouseEvent e) {
        if (e != null && e.getSource() == this.table) {
            IconValue currentValue = this.filterTable.getSelectedRowObject();
            if (currentValue == null) {
                return null;
            }
            String id = currentValue.getId();
            IconValue themeValue = this.iconTableModel.getThemeValue(id);
            return new ThemeTableContext(currentValue, themeValue, this);
        }
        return null;
    }
}

