/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import generic.theme.GColor;
import ghidra.app.nav.Navigatable;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.SearchConstants;
import ghidra.app.util.viewer.field.BytesFieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.features.base.memsearch.gui.MemoryMatchTableModel;
import ghidra.features.base.memsearch.gui.MemorySearchOptions;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class MemoryMatchHighlighter
implements ListingHighlightProvider {
    private Navigatable navigatable;
    private Program program;
    private List<MemoryMatch> sortedResults;
    private MemoryMatchTableModel model;
    private MemorySearchOptions options;
    private MemoryMatch selectedMatch;

    public MemoryMatchHighlighter(Navigatable navigatable, MemoryMatchTableModel model, MemorySearchOptions options) {
        this.model = model;
        this.options = options;
        this.navigatable = navigatable;
        this.program = navigatable.getProgram();
        model.addThreadedTableModelListener(new ThreadedTableModelListener(){

            public void loadingStarted() {
                MemoryMatchHighlighter.this.clearCache();
            }

            public void loadingFinished(boolean wasCancelled) {
            }

            public void loadPending() {
                MemoryMatchHighlighter.this.clearCache();
            }
        });
    }

    @Override
    public Highlight[] createHighlights(String text, ListingField field, int cursorTextOffset) {
        if (!this.options.isShowHighlights()) {
            return NO_HIGHLIGHTS;
        }
        if (this.program != this.navigatable.getProgram()) {
            return NO_HIGHLIGHTS;
        }
        Class<?> fieldFactoryClass = field.getFieldFactory().getClass();
        if (fieldFactoryClass != BytesFieldFactory.class) {
            return NO_HIGHLIGHTS;
        }
        ProxyObj<?> proxy = field.getProxy();
        Object obj = proxy.getObject();
        if (!(obj instanceof CodeUnit)) {
            return NO_HIGHLIGHTS;
        }
        CodeUnit cu = (CodeUnit)obj;
        Address minAddr = cu.getMinAddress();
        Address maxAddr = cu.getMaxAddress();
        List<MemoryMatch> results = this.getMatchesInRange(minAddr, maxAddr);
        if (results.isEmpty()) {
            return NO_HIGHLIGHTS;
        }
        return this.getHighlights(text, minAddr, results);
    }

    private Highlight[] getHighlights(String text, Address minAddr, List<MemoryMatch> results) {
        Object[] highlights = new Highlight[results.size()];
        int selectedMatchIndex = -1;
        for (int i = 0; i < highlights.length; ++i) {
            MemoryMatch match = results.get(i);
            GColor highlightColor = SearchConstants.SEARCH_HIGHLIGHT_COLOR;
            if (match == this.selectedMatch) {
                selectedMatchIndex = i;
                highlightColor = SearchConstants.SEARCH_HIGHLIGHT_CURRENT_ADDR_COLOR;
            }
            highlights[i] = this.createHighlight(match, minAddr, text, (Color)highlightColor);
        }
        if (selectedMatchIndex >= 0) {
            ArrayUtils.swap((Object[])highlights, (int)selectedMatchIndex, (int)(highlights.length - 1));
        }
        return highlights;
    }

    private Highlight createHighlight(MemoryMatch match, Address start, String text, Color color) {
        int highlightLength = match.getLength();
        Address address = match.getAddress();
        int startByteOffset = (int)address.subtract(start);
        int endByteOffset = startByteOffset + highlightLength - 1;
        startByteOffset = Math.max(startByteOffset, 0);
        return this.getHighlight(text, startByteOffset, endByteOffset, color);
    }

    private Highlight getHighlight(String text, int start, int end, Color color) {
        int charStart = this.getCharPosition(text, start);
        int charEnd = this.getCharPosition(text, end) + 1;
        return new Highlight(charStart, charEnd, color);
    }

    private int getCharPosition(String text, int byteOffset) {
        int byteGroupSize = this.options.getByteGroupSize();
        int byteDelimiterLength = this.options.getByteDelimiter().length();
        int groupSize = byteGroupSize * 2 + byteDelimiterLength;
        int groupIndex = byteOffset / byteGroupSize;
        int groupOffset = byteOffset % byteGroupSize;
        int pos = groupIndex * groupSize + 2 * groupOffset;
        return Math.min(text.length() - 1, pos);
    }

    List<MemoryMatch> getMatches() {
        if (this.sortedResults != null) {
            return this.sortedResults;
        }
        if (this.model.isBusy()) {
            return Collections.emptyList();
        }
        List modelData = this.model.getModelData();
        if (this.model.isSortedOnAddress()) {
            return modelData;
        }
        this.sortedResults = new ArrayList<MemoryMatch>(modelData);
        Collections.sort(this.sortedResults);
        return this.sortedResults;
    }

    private List<MemoryMatch> getMatchesInRange(Address start, Address end) {
        List<MemoryMatch> matches = this.getMatches();
        int startIndex = this.findFirstIndex(matches, start, end);
        if (startIndex < 0) {
            return Collections.emptyList();
        }
        int endIndex = this.findIndexAtOrGreater(matches, end);
        if (endIndex < matches.size() && matches.get(endIndex).getAddress().equals((Object)end)) {
            ++endIndex;
        }
        List<MemoryMatch> resultList = matches.subList(startIndex, endIndex);
        return resultList;
    }

    private int findFirstIndex(List<MemoryMatch> matches, Address start, Address end) {
        int startIndex = this.findIndexAtOrGreater(matches, start);
        if (startIndex > 0) {
            MemoryMatch resultBefore = matches.get(startIndex - 1);
            Address beforeAddr = resultBefore.getAddress();
            int length = resultBefore.getLength();
            if (start.hasSameAddressSpace(beforeAddr) && start.subtract(beforeAddr) < (long)length) {
                return startIndex - 1;
            }
        }
        if (startIndex == matches.size()) {
            return -1;
        }
        MemoryMatch result = matches.get(startIndex);
        Address addr = result.getAddress();
        if (end.compareTo((Object)addr) >= 0) {
            return startIndex;
        }
        return -1;
    }

    private int findIndexAtOrGreater(List<MemoryMatch> matches, Address address) {
        MemoryMatch key = new MemoryMatch(address);
        int index = Collections.binarySearch(matches, key);
        if (index < 0) {
            index = -index - 1;
        }
        return index;
    }

    private void clearCache() {
        if (this.sortedResults != null) {
            this.sortedResults.clear();
            this.sortedResults = null;
        }
    }

    void dispose() {
        this.navigatable.removeHighlightProvider(this, this.program);
        this.clearCache();
    }

    void setSelectedMatch(MemoryMatch selectedMatch) {
        this.selectedMatch = selectedMatch;
    }
}

