/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.GenericDataTypeProgramLocation;
import ghidra.app.services.FieldMatcher;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import java.util.Objects;

public class GenericCompositeDataTypeProgramLocation
extends GenericDataTypeProgramLocation {
    private FieldMatcher fieldMatcher;

    GenericCompositeDataTypeProgramLocation(Program program, DataType dataType, String fieldName) {
        this(program, dataType, new FieldMatcher(dataType, fieldName));
    }

    GenericCompositeDataTypeProgramLocation(Program program, DataType dataType, FieldMatcher fieldMatcher) {
        super(program, dataType);
        this.fieldMatcher = Objects.requireNonNull(fieldMatcher);
        if (!Objects.equals(dataType, fieldMatcher.getDataType())) {
            throw new AssertException("Data type does not match the FieldMatcher type");
        }
    }

    public FieldMatcher getFieldMatcher() {
        return this.fieldMatcher;
    }
}

