/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.label.LabelHistoryDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.UserSearchUtils;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class LabelHistoryTask
extends Task {
    private Pattern regexp;
    private String dialogTitle;
    private List<LabelHistory> historyList;
    private Program program;
    private final PluginTool tool;

    LabelHistoryTask(PluginTool tool, Program program, String matchStr) {
        super("Get All Label History", true, false, true);
        this.tool = tool;
        this.program = program;
        if (matchStr != null) {
            this.regexp = UserSearchUtils.createSearchPattern((String)matchStr, (boolean)false);
            this.dialogTitle = "Label History Matching " + matchStr;
        } else {
            this.dialogTitle = "All Label History";
        }
    }

    public void run(final TaskMonitor monitor) {
        SymbolTable st = this.program.getSymbolTable();
        this.historyList = new ArrayList<LabelHistory>();
        Iterator iter = st.getLabelHistory();
        int count = 0;
        while (iter.hasNext()) {
            LabelHistory h = (LabelHistory)iter.next();
            if (this.regexp != null) {
                Matcher matcher = this.regexp.matcher(h.getLabelString());
                if (matcher.find()) {
                    this.historyList.add(h);
                }
            } else {
                this.historyList.add(h);
            }
            if (++count != 50) continue;
            count = 0;
            if (!monitor.isCancelled()) continue;
            break;
        }
        super.notifyTaskListeners(monitor.isCancelled());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!monitor.isCancelled() && LabelHistoryTask.this.historyList.size() > 0) {
                    LabelHistoryDialog dialog = new LabelHistoryDialog(LabelHistoryTask.this.tool, LabelHistoryTask.this.program, LabelHistoryTask.this.dialogTitle, LabelHistoryTask.this.historyList);
                    LabelHistoryTask.this.tool.showDialog((DialogComponentProvider)dialog);
                }
            }
        });
    }

    boolean labelsFound() {
        return this.historyList.size() > 0;
    }
}

