/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.list.GListCellRenderer;
import ghidra.program.model.lang.Register;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListCellRenderer;

public class RegisterDropDownSelectionDataModel
implements DropDownTextFieldDataModel<Register> {
    private List<Register> registers;

    public RegisterDropDownSelectionDataModel(List<Register> registers) {
        this.registers = registers;
    }

    public ListCellRenderer<Register> getListRenderer() {
        return new GListCellRenderer();
    }

    public String getDescription(Register value) {
        return null;
    }

    public String getDisplayText(Register value) {
        return value.getName();
    }

    public List<Register> getMatchingData(String searchText) {
        if (searchText == null || searchText.length() == 0) {
            return this.registers;
        }
        searchText = searchText.toLowerCase();
        ArrayList<Register> regList = new ArrayList<Register>();
        for (Register reg : this.registers) {
            String regName = reg.getName().toLowerCase();
            if (!regName.startsWith(searchText)) continue;
            regList.add(reg);
        }
        return regList;
    }

    public int getIndexOfFirstMatchingEntry(List<Register> data, String searchText) {
        String lcSearchText = searchText.toLowerCase();
        int len = data.size();
        for (int i = 0; i < len; ++i) {
            String name = data.get(i).getName();
            String lcName = name.toLowerCase();
            if (!lcName.startsWith(lcSearchText)) continue;
            return i;
        }
        return 0;
    }
}

