/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.memory;

import ghidra.app.cmd.memory.AbstractAddMemoryBlockCmd;
import ghidra.framework.store.LockException;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;

public class AddByteMappedMemoryBlockCmd
extends AbstractAddMemoryBlockCmd {
    private final Address mappedAddress;
    private final ByteMappingScheme byteMappingScheme;

    public AddByteMappedMemoryBlockCmd(String name, String comment, String source, Address start, long length, boolean read, boolean write, boolean execute, boolean isVolatile, Address mappedAddress, ByteMappingScheme byteMappingScheme, boolean isOverlay) {
        super(name, comment, source, start, length, read, write, execute, isVolatile, isOverlay);
        this.mappedAddress = mappedAddress;
        this.byteMappingScheme = byteMappingScheme;
    }

    public AddByteMappedMemoryBlockCmd(String name, String comment, String source, Address start, long length, boolean read, boolean write, boolean execute, boolean isVolatile, Address mappedAddress, boolean isOverlay) {
        this(name, comment, source, start, length, read, write, execute, isVolatile, mappedAddress, null, isOverlay);
    }

    @Override
    protected MemoryBlock createMemoryBlock(Memory memory) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException {
        return memory.createByteMappedBlock(this.name, this.start, this.mappedAddress, this.length, this.byteMappingScheme, this.isOverlay);
    }
}

