/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.buffers.BufferFile;
import db.buffers.LocalManagedBufferFile;
import db.buffers.ManagedBufferFile;
import generic.theme.GIcon;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.framework.data.DBContentHandler;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.local.LocalDatabaseItem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.Icon;

public class VTSessionContentHandler
extends DBContentHandler<VTSessionDB> {
    public static final String CONTENT_TYPE = "VersionTracking";
    private static final Icon ICON = new GIcon("icon.version.tracking.session.content.type");

    public long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject domainObject, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        if (!(domainObject instanceof VTSessionDB)) {
            throw new IOException("Unsupported domain object: " + domainObject.getClass().getName());
        }
        return this.createFile((VTSessionDB)domainObject, CONTENT_TYPE, fs, path, name, monitor);
    }

    public ChangeSet getChangeSet(FolderItem versionedFolderItem, int olderVersion, int newerVersion) throws VersionException, IOException {
        return null;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentTypeDisplayString() {
        return "Version Tracking Session";
    }

    public String getDefaultToolName() {
        return "Version Tracking";
    }

    private void checkContentAndExclusiveCheckout(FolderItem item) throws IOException {
        String contentType = item.getContentType();
        if (!contentType.equals(CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        if (item.isVersioned() || item.isCheckedOut() && !item.isCheckedOutExclusive()) {
            throw new IOException("Unsupported VT Session use: session file must be checked-out exclusive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VTSessionDB getDomainObject(FolderItem item, FileSystem userfs, long checkoutId, boolean okToUpgrade, boolean okToRecover, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        VTSessionDB vTSessionDB;
        block9: {
            this.checkContentAndExclusiveCheckout(item);
            if (item.isReadOnly()) {
                throw new ReadOnlyException("VT Session file is set read-only which prevents its use");
            }
            DatabaseItem dbItem = (DatabaseItem)item;
            ManagedBufferFile bf = dbItem.openForUpdate(checkoutId);
            DBHandle dbh = new DBHandle((BufferFile)bf, okToRecover, monitor);
            boolean success = false;
            try {
                VTSessionDB db = new VTSessionDB(dbh, monitor, consumer);
                success = true;
                vTSessionDB = db;
                if (success) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (!success) {
                        dbh.close();
                    }
                    throw throwable;
                }
                catch (CancelledException | VersionException | IOException e) {
                    throw e;
                }
                catch (Throwable t) {
                    Msg.error((Object)((Object)this), (Object)"getDomainObject failed", (Throwable)t);
                    String msg = t.getMessage();
                    if (msg == null) {
                        msg = t.toString();
                    }
                    throw new IOException("Open failed: " + msg, t);
                }
            }
            dbh.close();
        }
        return vTSessionDB;
    }

    public Class<VTSessionDB> getDomainObjectClass() {
        return VTSessionDB.class;
    }

    public Icon getIcon() {
        return ICON;
    }

    public VTSessionDB getImmutableObject(FolderItem item, Object consumer, int version, int minChangeVersion, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        return this.getReadOnlyObject(item, -1, false, consumer, monitor);
    }

    public DomainObjectMergeManager getMergeManager(DomainObject resultsObj, DomainObject sourceObj, DomainObject originalObj, DomainObject latestObj) {
        return null;
    }

    public VTSessionDB getReadOnlyObject(FolderItem item, int version, boolean okToUpgrade, Object consumer, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.checkContentAndExclusiveCheckout(item);
        throw new ReadOnlyException("VT Session does not support read-only use");
    }

    public boolean isPrivateContentType() {
        return false;
    }

    public boolean canResetDBSourceFile() {
        return true;
    }

    public void resetDBSourceFile(FolderItem item, DomainObjectAdapterDB domainObj) throws IOException {
        LocalDatabaseItem dbItem;
        block3: {
            block2: {
                if (!(item instanceof LocalDatabaseItem)) break block2;
                dbItem = (LocalDatabaseItem)item;
                if (domainObj instanceof VTSessionDB) break block3;
            }
            throw new IllegalArgumentException("LocalDatabaseItem and VTSessionDB required");
        }
        VTSessionDB vtSession = (VTSessionDB)domainObj;
        LocalManagedBufferFile bf = dbItem.openForUpdate(-1L);
        vtSession.getDBHandle().setDBVersionedSourceFile((BufferFile)bf);
    }
}

