/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import generic.util.PeekableIterator;
import ghidra.util.exception.AssertException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class MultiIterator<T>
implements Iterator<T> {
    protected List<PeekableIterator<T>> iterators;
    private Comparator<T> comparator;

    public MultiIterator(List<PeekableIterator<T>> iterators, boolean forward) {
        this(iterators, new TComparator(), forward);
    }

    public MultiIterator(List<PeekableIterator<T>> iterators, Comparator<T> comparator, boolean forward) {
        this.iterators = iterators;
        this.comparator = forward ? comparator : new ReverseComparatorWrapper(comparator);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        for (PeekableIterator<T> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        int result;
        T t;
        T lowest = null;
        for (PeekableIterator<T> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            t = iterator.peek();
            if (lowest == null) {
                lowest = t;
                continue;
            }
            result = this.comparator.compare(lowest, t);
            if (result <= 0) continue;
            lowest = t;
        }
        if (lowest == null) {
            throw new AssertException("next() has no more items to give!  Call hasNext() before calling next()");
        }
        for (PeekableIterator<T> iterator : this.iterators) {
            if (!iterator.hasNext() || (result = this.comparator.compare(lowest, t = iterator.peek())) != 0) continue;
            iterator.next();
            return lowest;
        }
        throw new AssertException("next() has no more items to give!  Call hasNext() before calling next()");
    }

    private static class TComparator<T>
    implements Comparator<T> {
        private TComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            if (!(t1 instanceof Comparable) || !(t2 instanceof Comparable)) {
                throw new AssertException("T must be comparable if you do not supply your own comparator");
            }
            return ((Comparable)t1).compareTo(t2);
        }
    }

    private static class ReverseComparatorWrapper<T>
    implements Comparator<T> {
        private Comparator<T> delegate;

        ReverseComparatorWrapper(Comparator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compare(T t1, T t2) {
            return -this.delegate.compare(t1, t2);
        }
    }
}

