/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.util.test.FreeColTestCase;

public class MarketTest
extends FreeColTestCase {
    public void testInitialMarket() {
        Game g = MarketTest.getStandardGame();
        Player p = g.getPlayerByNationId("model.nation.dutch");
        Market dm = p.getMarket();
        Specification s = MarketTest.spec();
        for (GoodsType good : s.getStorableGoodsTypeList()) {
            MarketTest.assertEquals((String)good.toString(), (int)good.getInitialBuyPrice(), (int)dm.getCostToBuy(good));
            MarketTest.assertEquals((String)good.toString(), (int)good.getInitialSellPrice(), (int)dm.getPaidForSale(good));
        }
    }

    public void testEuropeMarketPricing() {
        Game g = MarketTest.getStandardGame();
        Player p = g.getPlayerByNationId("model.nation.dutch");
        Specification s = MarketTest.spec();
        Europe eu = p.getEurope();
        for (GoodsType good : s.getGoodsTypeList()) {
            ArrayList<AbstractGoods> goods = new ArrayList<AbstractGoods>();
            MarketTest.assertEquals((int)p.getMarket().getSalePrice(good, 1), (int)eu.getOwner().getMarket().getSalePrice(good, 1));
            goods.add(new AbstractGoods(good, 1));
            int bidPrice = p.getMarket().getBidPrice(good, 1);
            int buyCost = p.getMarket().getCostToBuy(good);
            MarketTest.assertEquals((int)buyCost, (int)bidPrice);
            try {
                int priceGoods = eu.priceGoods(goods);
                MarketTest.assertEquals((int)buyCost, (int)priceGoods);
            }
            catch (FreeColException fce) {
                MarketTest.fail((String)fce.getMessage());
            }
        }
    }

    public void testSerialization() {
    }

    public void testTransactionListeners() {
    }
}

