﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-identity/ChimeSDKIdentityRequest.h>
#include <aws/chime-sdk-identity/ChimeSDKIdentity_EXPORTS.h>
#include <aws/chime-sdk-identity/model/ExpirationSettings.h>
#include <aws/chime-sdk-identity/model/Tag.h>
#include <aws/core/utils/UUID.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace ChimeSDKIdentity {
namespace Model {

/**
 */
class CreateAppInstanceUserRequest : public ChimeSDKIdentityRequest {
 public:
  AWS_CHIMESDKIDENTITY_API CreateAppInstanceUserRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateAppInstanceUser"; }

  AWS_CHIMESDKIDENTITY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ARN of the <code>AppInstance</code> request.</p>
   */
  inline const Aws::String& GetAppInstanceArn() const { return m_appInstanceArn; }
  inline bool AppInstanceArnHasBeenSet() const { return m_appInstanceArnHasBeenSet; }
  template <typename AppInstanceArnT = Aws::String>
  void SetAppInstanceArn(AppInstanceArnT&& value) {
    m_appInstanceArnHasBeenSet = true;
    m_appInstanceArn = std::forward<AppInstanceArnT>(value);
  }
  template <typename AppInstanceArnT = Aws::String>
  CreateAppInstanceUserRequest& WithAppInstanceArn(AppInstanceArnT&& value) {
    SetAppInstanceArn(std::forward<AppInstanceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user ID of the <code>AppInstance</code>.</p>
   */
  inline const Aws::String& GetAppInstanceUserId() const { return m_appInstanceUserId; }
  inline bool AppInstanceUserIdHasBeenSet() const { return m_appInstanceUserIdHasBeenSet; }
  template <typename AppInstanceUserIdT = Aws::String>
  void SetAppInstanceUserId(AppInstanceUserIdT&& value) {
    m_appInstanceUserIdHasBeenSet = true;
    m_appInstanceUserId = std::forward<AppInstanceUserIdT>(value);
  }
  template <typename AppInstanceUserIdT = Aws::String>
  CreateAppInstanceUserRequest& WithAppInstanceUserId(AppInstanceUserIdT&& value) {
    SetAppInstanceUserId(std::forward<AppInstanceUserIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user's name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateAppInstanceUserRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
   */
  inline const Aws::String& GetMetadata() const { return m_metadata; }
  inline bool MetadataHasBeenSet() const { return m_metadataHasBeenSet; }
  template <typename MetadataT = Aws::String>
  void SetMetadata(MetadataT&& value) {
    m_metadataHasBeenSet = true;
    m_metadata = std::forward<MetadataT>(value);
  }
  template <typename MetadataT = Aws::String>
  CreateAppInstanceUserRequest& WithMetadata(MetadataT&& value) {
    SetMetadata(std::forward<MetadataT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID of the request. Use different tokens to request additional
   * <code>AppInstances</code>.</p>
   */
  inline const Aws::String& GetClientRequestToken() const { return m_clientRequestToken; }
  inline bool ClientRequestTokenHasBeenSet() const { return m_clientRequestTokenHasBeenSet; }
  template <typename ClientRequestTokenT = Aws::String>
  void SetClientRequestToken(ClientRequestTokenT&& value) {
    m_clientRequestTokenHasBeenSet = true;
    m_clientRequestToken = std::forward<ClientRequestTokenT>(value);
  }
  template <typename ClientRequestTokenT = Aws::String>
  CreateAppInstanceUserRequest& WithClientRequestToken(ClientRequestTokenT&& value) {
    SetClientRequestToken(std::forward<ClientRequestTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
   */
  inline const Aws::Vector<Tag>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Vector<Tag>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Tag>>
  CreateAppInstanceUserRequest& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Tag>
  CreateAppInstanceUserRequest& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Settings that control the interval after which the
   * <code>AppInstanceUser</code> is automatically deleted.</p>
   */
  inline const ExpirationSettings& GetExpirationSettings() const { return m_expirationSettings; }
  inline bool ExpirationSettingsHasBeenSet() const { return m_expirationSettingsHasBeenSet; }
  template <typename ExpirationSettingsT = ExpirationSettings>
  void SetExpirationSettings(ExpirationSettingsT&& value) {
    m_expirationSettingsHasBeenSet = true;
    m_expirationSettings = std::forward<ExpirationSettingsT>(value);
  }
  template <typename ExpirationSettingsT = ExpirationSettings>
  CreateAppInstanceUserRequest& WithExpirationSettings(ExpirationSettingsT&& value) {
    SetExpirationSettings(std::forward<ExpirationSettingsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appInstanceArn;

  Aws::String m_appInstanceUserId;

  Aws::String m_name;

  Aws::String m_metadata;

  Aws::String m_clientRequestToken{Aws::Utils::UUID::PseudoRandomUUID()};

  Aws::Vector<Tag> m_tags;

  ExpirationSettings m_expirationSettings;
  bool m_appInstanceArnHasBeenSet = false;
  bool m_appInstanceUserIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_metadataHasBeenSet = false;
  bool m_clientRequestTokenHasBeenSet = true;
  bool m_tagsHasBeenSet = false;
  bool m_expirationSettingsHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKIdentity
}  // namespace Aws
