/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.locks;

import org.graalvm.visualvm.lib.jfluid.results.locks.ThreadInfo;

final class ThreadInfos {
    ThreadInfo[] threadInfos;
    int threadInfosLastIdx;
    ThreadInfo unknowThread = new ThreadInfo(-1, "Unknown", "N/A");

    ThreadInfos() {
        this.reset();
    }

    boolean isEmpty() {
        if (this.threadInfos == null || this.threadInfos.length == 0) {
            return true;
        }
        for (ThreadInfo threadInfo : this.threadInfos) {
            if (threadInfo == null) continue;
            return false;
        }
        return true;
    }

    void newThreadInfo(int threadId, String threadName, String threadClassName) {
        if (threadId > this.threadInfosLastIdx || this.threadInfos == null) {
            int newLen = threadId + 1;
            ThreadInfo[] newInfos = new ThreadInfo[newLen];
            if (this.threadInfos != null) {
                System.arraycopy(this.threadInfos, 0, newInfos, 0, this.threadInfos.length);
            }
            this.threadInfos = newInfos;
            this.threadInfosLastIdx = threadId;
        }
        this.threadInfos[threadId] = new ThreadInfo(threadId, threadName, threadClassName);
    }

    void reset() {
        this.threadInfos = null;
        this.threadInfosLastIdx = -1;
    }

    ThreadInfo getThreadInfo(int threadId) {
        if (threadId == -1) {
            return this.unknowThread;
        }
        if (!this.isEmpty()) {
            return this.threadInfos[threadId];
        }
        return null;
    }
}

