
/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the \"COPYING.LIB\" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.

 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

/*
 * IPlatformProperties.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_7_2;

import org.virtualbox_7_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Properties of a specific virtualization platform.

Interface ID: <code>{5BAE19D0-CA40-4CA2-A485-C8065190BBE5}</code>
*/
public class IPlatformProperties extends IUnknown
{

    public IPlatformProperties(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Indicates whether VirtualBox was built with raw-mode support.

When this reads as False, the{@link org.virtualbox_7_2.HWVirtExPropertyType#Enabled}setting will be ignored and assumed to be True.
NOTE: For guest platform properties, this attribute is being
ignored.

@return Boolean
*/
    public Boolean getRawModeSupported()
    {
        try
        {
            Boolean retVal = port.iPlatformPropertiesGetRawModeSupported(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Exclusive use of hardware virtualization by VirtualBox. When enabled,
VirtualBox assumes it can obtain full and exclusive access to the VT-x
or AMD-V feature of the host. To share hardware virtualization with
other hypervisors, this property must be disabled.
NOTE: For hosts running on macOS this is being ignored, as the kernel
mediates hardware access there.

NOTE: For guest platform properties, this attribute is being
ignored.

@return Boolean
*/
    public Boolean getExclusiveHwVirt()
    {
        try
        {
            Boolean retVal = port.iPlatformPropertiesGetExclusiveHwVirt(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Exclusive use of hardware virtualization by VirtualBox. When enabled,
VirtualBox assumes it can obtain full and exclusive access to the VT-x
or AMD-V feature of the host. To share hardware virtualization with
other hypervisors, this property must be disabled.
NOTE: For hosts running on macOS this is being ignored, as the kernel
mediates hardware access there.

NOTE: For guest platform properties, this attribute is being
ignored.

@param value Boolean

*/
    public void setExclusiveHwVirt(Boolean value)
    {
        try
        {
        port.iPlatformPropertiesSetExclusiveHwVirt(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Maximum number of serial ports associated with every{@link org.virtualbox_7_2.IMachine}instance.
@return Long
*/
    public Long getSerialPortCount()
    {
        try
        {
            Long retVal = port.iPlatformPropertiesGetSerialPortCount(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Maximum number of parallel ports associated with every{@link org.virtualbox_7_2.IMachine}instance.
@return Long
*/
    public Long getParallelPortCount()
    {
        try
        {
            Long retVal = port.iPlatformPropertiesGetParallelPortCount(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Maximum device position in the boot order. This value corresponds
to the total number of devices a machine can boot from, to make it
possible to include all possible devices to the boot list.
@return Long

@see org.virtualbox_7_2.IMachine#setBootOrder(Long,org.virtualbox_7_2.DeviceType)
*/
    public Long getMaxBootPosition()
    {
        try
        {
            Long retVal = port.iPlatformPropertiesGetMaxBootPosition(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.ParavirtProvider},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.ParavirtProvider&gt;
*/
    public List<org.virtualbox_7_2.ParavirtProvider> getSupportedParavirtProviders()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.ParavirtProvider> retVal = port.iPlatformPropertiesGetSupportedParavirtProviders(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.ParavirtProvider.class, org.virtualbox_7_2.ParavirtProvider.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.FirmwareType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.FirmwareType&gt;
*/
    public List<org.virtualbox_7_2.FirmwareType> getSupportedFirmwareTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.FirmwareType> retVal = port.iPlatformPropertiesGetSupportedFirmwareTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.FirmwareType.class, org.virtualbox_7_2.FirmwareType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.IGuestOSType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.IGuestOSType&gt;
*/
    public List<org.virtualbox_7_2.IGuestOSType> getSupportedGuestOSTypes()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            List<org.virtualbox_7_2.jaxws.IGuestOSType> retVal = port.iPlatformPropertiesGetSupportedGuestOSTypes(obj);
            return Helper.wrap2(org.virtualbox_7_2.IGuestOSType.class, org.virtualbox_7_2.jaxws.IGuestOSType.class, objMgr, port, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.GraphicsControllerType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.GraphicsControllerType&gt;
*/
    public List<org.virtualbox_7_2.GraphicsControllerType> getSupportedGfxControllerTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.GraphicsControllerType> retVal = port.iPlatformPropertiesGetSupportedGfxControllerTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.GraphicsControllerType.class, org.virtualbox_7_2.GraphicsControllerType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.NetworkAdapterPromiscModePolicy},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.NetworkAdapterPromiscModePolicy&gt;
*/
    public List<org.virtualbox_7_2.NetworkAdapterPromiscModePolicy> getSupportedNetAdpPromiscModePols()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.NetworkAdapterPromiscModePolicy> retVal = port.iPlatformPropertiesGetSupportedNetAdpPromiscModePols(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.NetworkAdapterPromiscModePolicy.class, org.virtualbox_7_2.NetworkAdapterPromiscModePolicy.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.NetworkAdapterType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.NetworkAdapterType&gt;
*/
    public List<org.virtualbox_7_2.NetworkAdapterType> getSupportedNetworkAdapterTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.NetworkAdapterType> retVal = port.iPlatformPropertiesGetSupportedNetworkAdapterTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.NetworkAdapterType.class, org.virtualbox_7_2.NetworkAdapterType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.UartType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.UartType&gt;
*/
    public List<org.virtualbox_7_2.UartType> getSupportedUartTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.UartType> retVal = port.iPlatformPropertiesGetSupportedUartTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.UartType.class, org.virtualbox_7_2.UartType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.USBControllerType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.USBControllerType&gt;
*/
    public List<org.virtualbox_7_2.USBControllerType> getSupportedUSBControllerTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.USBControllerType> retVal = port.iPlatformPropertiesGetSupportedUSBControllerTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.USBControllerType.class, org.virtualbox_7_2.USBControllerType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.AudioControllerType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.AudioControllerType&gt;
*/
    public List<org.virtualbox_7_2.AudioControllerType> getSupportedAudioControllerTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.AudioControllerType> retVal = port.iPlatformPropertiesGetSupportedAudioControllerTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.AudioControllerType.class, org.virtualbox_7_2.AudioControllerType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported boot devices for enum{@link org.virtualbox_7_2.DeviceType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.

The returned array also defines the default boot device order for all supported devices.
@return List&lt;org.virtualbox_7_2.DeviceType&gt;
*/
    public List<org.virtualbox_7_2.DeviceType> getSupportedBootDevices()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.DeviceType> retVal = port.iPlatformPropertiesGetSupportedBootDevices(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.DeviceType.class, org.virtualbox_7_2.DeviceType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.StorageBus},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.StorageBus&gt;
*/
    public List<org.virtualbox_7_2.StorageBus> getSupportedStorageBuses()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.StorageBus> retVal = port.iPlatformPropertiesGetSupportedStorageBuses(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.StorageBus.class, org.virtualbox_7_2.StorageBus.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.StorageControllerType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.StorageControllerType&gt;
*/
    public List<org.virtualbox_7_2.StorageControllerType> getSupportedStorageControllerTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.StorageControllerType> retVal = port.iPlatformPropertiesGetSupportedStorageControllerTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.StorageControllerType.class, org.virtualbox_7_2.StorageControllerType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.ChipsetType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.ChipsetType&gt;
*/
    public List<org.virtualbox_7_2.ChipsetType> getSupportedChipsetTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.ChipsetType> retVal = port.iPlatformPropertiesGetSupportedChipsetTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.ChipsetType.class, org.virtualbox_7_2.ChipsetType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.IommuType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.IommuType&gt;
*/
    public List<org.virtualbox_7_2.IommuType> getSupportedIommuTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.IommuType> retVal = port.iPlatformPropertiesGetSupportedIommuTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.IommuType.class, org.virtualbox_7_2.IommuType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns an array of officially supported values for enum{@link org.virtualbox_7_2.TpmType},
in the sense of what is e.g. worth offering in the VirtualBox GUI.
@return List&lt;org.virtualbox_7_2.TpmType&gt;
*/
    public List<org.virtualbox_7_2.TpmType> getSupportedTpmTypes()
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.TpmType> retVal = port.iPlatformPropertiesGetSupportedTpmTypes(obj);
            return Helper.convertEnums(org.virtualbox_7_2.jaxws.TpmType.class, org.virtualbox_7_2.TpmType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IPlatformProperties queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IPlatformProperties(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Maximum total number of network adapters associated with every{@link org.virtualbox_7_2.IMachine}instance.
@param chipset The chipset type to get the value for.

@return The maximum total number of network adapters allowed.

*/
    public Long getMaxNetworkAdapters(org.virtualbox_7_2.ChipsetType chipset)
    {
        try
        {
            Long retVal;
        retVal = port.iPlatformPropertiesGetMaxNetworkAdapters(obj, org.virtualbox_7_2.jaxws.ChipsetType.fromValue(chipset.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Maximum number of network adapters of a given attachment type,
associated with every{@link org.virtualbox_7_2.IMachine}instance.
@param chipset The chipset type to get the value for.

@param type Type of attachment.

@return The maximum number of network adapters allowed for
particular chipset and attachment type.

*/
    public Long getMaxNetworkAdaptersOfType(org.virtualbox_7_2.ChipsetType chipset, org.virtualbox_7_2.NetworkAttachmentType type)
    {
        try
        {
            Long retVal;
        retVal = port.iPlatformPropertiesGetMaxNetworkAdaptersOfType(obj, org.virtualbox_7_2.jaxws.ChipsetType.fromValue(chipset.name()), org.virtualbox_7_2.jaxws.NetworkAttachmentType.fromValue(type.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the maximum number of devices which can be attached to a port
for the given storage bus.
@param bus The storage bus type to get the value for.

@return The maximum number of devices which can be attached to the port for the given
storage bus.

*/
    public Long getMaxDevicesPerPortForStorageBus(org.virtualbox_7_2.StorageBus bus)
    {
        try
        {
            Long retVal;
        retVal = port.iPlatformPropertiesGetMaxDevicesPerPortForStorageBus(obj, org.virtualbox_7_2.jaxws.StorageBus.fromValue(bus.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the minimum number of ports the given storage bus supports.
@param bus The storage bus type to get the value for.

@return The minimum number of ports for the given storage bus.

*/
    public Long getMinPortCountForStorageBus(org.virtualbox_7_2.StorageBus bus)
    {
        try
        {
            Long retVal;
        retVal = port.iPlatformPropertiesGetMinPortCountForStorageBus(obj, org.virtualbox_7_2.jaxws.StorageBus.fromValue(bus.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the maximum number of ports the given storage bus supports.
@param bus The storage bus type to get the value for.

@return The maximum number of ports for the given storage bus.

*/
    public Long getMaxPortCountForStorageBus(org.virtualbox_7_2.StorageBus bus)
    {
        try
        {
            Long retVal;
        retVal = port.iPlatformPropertiesGetMaxPortCountForStorageBus(obj, org.virtualbox_7_2.jaxws.StorageBus.fromValue(bus.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the maximum number of storage bus instances which
can be configured for each VM. This corresponds to the number of
storage controllers one can have. Value may depend on chipset type
used.
@param chipset The chipset type to get the value for.

@param bus The storage bus type to get the value for.

@return The maximum number of instances for the given storage bus.

*/
    public Long getMaxInstancesOfStorageBus(org.virtualbox_7_2.ChipsetType chipset, org.virtualbox_7_2.StorageBus bus)
    {
        try
        {
            Long retVal;
        retVal = port.iPlatformPropertiesGetMaxInstancesOfStorageBus(obj, org.virtualbox_7_2.jaxws.ChipsetType.fromValue(chipset.name()), org.virtualbox_7_2.jaxws.StorageBus.fromValue(bus.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the VRAM range of a given graphics controller.
@param graphicsControllerType Graphics controller type to return VRAM range for.

@param accelerate3DEnabled Whether 3D acceleration for the graphics controller type is enabled or not.
Ignored if the given graphics controller does not support 3D acceleration.

@param minMB The minimum size (in MB) the graphics controller supports.

@param maxMB The maximum size (in MB) the graphics controller supports.

@return The stride size the graphics controller supports. This marks the allowed steps between the values
when increasing / decreasing the VRAM size.

*/
    public Long getSupportedVRAMRange(org.virtualbox_7_2.GraphicsControllerType graphicsControllerType, Boolean accelerate3DEnabled, Holder<Long> minMB, Holder<Long> maxMB)
    {
        try
        {
        javax.xml.ws.Holder<Long> tmp_minMB = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_maxMB = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> retVal = new javax.xml.ws.Holder<Long>();
        port.iPlatformPropertiesGetSupportedVRAMRange(obj, org.virtualbox_7_2.jaxws.GraphicsControllerType.fromValue(graphicsControllerType.name()), accelerate3DEnabled, tmp_minMB, tmp_maxMB, retVal);
        minMB.value = tmp_minMB.value;
        maxMB.value = tmp_maxMB.value;
           return retVal.value;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the supported features of a given graphics controller.
@param graphicsControllerType Graphics controller type to return features for.

@return The graphics controller features which are valid.

*/
    public List<org.virtualbox_7_2.GraphicsFeature> getSupportedGfxFeaturesForType(org.virtualbox_7_2.GraphicsControllerType graphicsControllerType)
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.GraphicsFeature> retVal;
        retVal = port.iPlatformPropertiesGetSupportedGfxFeaturesForType(obj, org.virtualbox_7_2.jaxws.GraphicsControllerType.fromValue(graphicsControllerType.name()));
           return Helper.convertEnums(org.virtualbox_7_2.jaxws.GraphicsFeature.class, org.virtualbox_7_2.GraphicsFeature.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns list of all the supported device types
({@link org.virtualbox_7_2.DeviceType}) for the given type of storage
bus.
@param bus The storage bus type to get the value for.

@return The list of all supported device types for the given storage bus.

*/
    public List<org.virtualbox_7_2.DeviceType> getDeviceTypesForStorageBus(org.virtualbox_7_2.StorageBus bus)
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.DeviceType> retVal;
        retVal = port.iPlatformPropertiesGetDeviceTypesForStorageBus(obj, org.virtualbox_7_2.jaxws.StorageBus.fromValue(bus.name()));
           return Helper.convertEnums(org.virtualbox_7_2.jaxws.DeviceType.class, org.virtualbox_7_2.DeviceType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the{@link org.virtualbox_7_2.StorageBus}enum value
for a given storage controller type.
@param storageControllerType The storage controller type to get the value for.

@return The storage bus which is applicable.

*/
    public org.virtualbox_7_2.StorageBus getStorageBusForControllerType(org.virtualbox_7_2.StorageControllerType storageControllerType)
    {
        try
        {
            org.virtualbox_7_2.jaxws.StorageBus retVal;
        retVal = port.iPlatformPropertiesGetStorageBusForControllerType(obj, org.virtualbox_7_2.jaxws.StorageControllerType.fromValue(storageControllerType.name()));
           return org.virtualbox_7_2.StorageBus.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the possible{@link org.virtualbox_7_2.StorageControllerType}enum values
for a given storage bus.
@param storageBus The storage bus type to get the values for.

@return The enum values (sorted by what should be a sensible decreasing
importance of the type) which are valid.

*/
    public List<org.virtualbox_7_2.StorageControllerType> getStorageControllerTypesForBus(org.virtualbox_7_2.StorageBus storageBus)
    {
        try
        {
            List<org.virtualbox_7_2.jaxws.StorageControllerType> retVal;
        retVal = port.iPlatformPropertiesGetStorageControllerTypesForBus(obj, org.virtualbox_7_2.jaxws.StorageBus.fromValue(storageBus.name()));
           return Helper.convertEnums(org.virtualbox_7_2.jaxws.StorageControllerType.class, org.virtualbox_7_2.StorageControllerType.class, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns whether the given storage controller supports
hot-plugging devices.
@param controllerType The storage controller to check the setting for.

@return Returned flag indicating whether the controller is hotplug capable

*/
    public Boolean getStorageControllerHotplugCapable(org.virtualbox_7_2.StorageControllerType controllerType)
    {
        try
        {
            Boolean retVal;
        retVal = port.iPlatformPropertiesGetStorageControllerHotplugCapable(obj, org.virtualbox_7_2.jaxws.StorageControllerType.fromValue(controllerType.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the maximum number of USB controller instances which
can be configured for each VM. This corresponds to the number of
USB controllers one can have. Value may depend on chipset type
used.
@param chipset The chipset type to get the value for.

@param type The USB controller type to get the value for.

@return The maximum number of instances for the given USB controller type.

*/
    public Long getMaxInstancesOfUSBControllerType(org.virtualbox_7_2.ChipsetType chipset, org.virtualbox_7_2.USBControllerType type)
    {
        try
        {
            Long retVal;
        retVal = port.iPlatformPropertiesGetMaxInstancesOfUSBControllerType(obj, org.virtualbox_7_2.jaxws.ChipsetType.fromValue(chipset.name()), org.virtualbox_7_2.jaxws.USBControllerType.fromValue(type.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
