/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jsonrpc.io;

import org.directwebremoting.jsonrpc.io.JsonRpcCallException;
import org.directwebremoting.jsonrpc.io.JsonRpcCalls;

public class JsonRpcError {
    private final String jsonrpc;
    private final String id;
    private final Object data;
    private final int code;
    private final String message;

    public JsonRpcError(JsonRpcCalls calls, String message, int code, Object data) {
        if (calls != null) {
            this.jsonrpc = calls.getVersion();
            this.id = calls.getBatchId();
        } else {
            this.jsonrpc = "2.0";
            this.id = "";
        }
        this.data = data;
        this.message = message;
        this.code = code;
    }

    public JsonRpcError(String version, String id, String message, int code, Object data) {
        this.jsonrpc = version;
        this.id = id;
        this.data = data;
        this.message = message;
        this.code = code;
    }

    public JsonRpcError(JsonRpcCallException ex) {
        this.jsonrpc = ex.getVersion();
        this.id = ex.getId();
        this.code = ex.getJsonRpcErrorCode();
        this.message = ex.getMessage();
        this.data = ex.getData();
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public String getId() {
        return this.id;
    }

    public Object getData() {
        return this.data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }
}

