/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser.processors;

import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.model.FxNewInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.javafx2.editor.parser.BuildEnvironment;
import org.netbeans.modules.javafx2.editor.parser.ModelBuilderStep;
import org.netbeans.modules.javafx2.editor.parser.processors.Bundle;

public class ValueChecker
extends FxNodeVisitor.ModelTraversal
implements ModelBuilderStep {
    private BuildEnvironment env;

    private ValueChecker(BuildEnvironment env) {
        this.env = env;
    }

    public ValueChecker() {
    }

    @Override
    public void visitInstance(FxNewInstance decl) {
        if (decl.isConstant()) {
            this.checkConstant(decl);
        }
        super.visitInstance(decl);
    }

    private void checkConstant(FxNewInstance decl) {
        int end;
        int start;
        String s = decl.getInitValue();
        FxBean def = decl.getDefinition();
        if (def == null) {
            return;
        }
        if (def.getConstants().contains(s)) {
            return;
        }
        int[] attributePos = this.env.getTreeUtilities().findAttributePos(decl, null, "source", true);
        if (attributePos == null) {
            TextPositions pos = this.env.getTreeUtilities().positions(decl);
            start = pos.getStart();
            end = pos.isDefined(TextPositions.Position.ContentStart) ? pos.getContentStart() : pos.getEnd();
        } else {
            start = attributePos[0];
            end = attributePos[1];
        }
        this.env.addError(ErrorMark.makeError(start, end - start, "undefined-constant", Bundle.ERR_undefinedConstant(s, decl.getSourceName()), decl));
    }

    @Override
    public FxNodeVisitor createVisitor(BuildEnvironment env) {
        return new ValueChecker(env);
    }
}

