/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ObjectReferenceWrapper {
    private ObjectReferenceWrapper() {
    }

    public static void disableCollection(ObjectReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "disableCollection", "JDI CALL: com.sun.jdi.ObjectReference({0}).disableCollection()", new Object[]{a});
        }
        try {
            a.disableCollection();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (UnsupportedOperationException ex) {
            throw new UnsupportedOperationExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "disableCollection", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static void enableCollection(ObjectReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "enableCollection", "JDI CALL: com.sun.jdi.ObjectReference({0}).enableCollection()", new Object[]{a});
        }
        try {
            a.enableCollection();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (UnsupportedOperationException ex) {
            throw new UnsupportedOperationExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "enableCollection", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static int entryCount0(ObjectReference a) throws IncompatibleThreadStateException {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "entryCount", "JDI CALL: com.sun.jdi.ObjectReference({0}).entryCount()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.entryCount();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            int n = 0;
            return n;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            int n = 0;
            return n;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            int n = 0;
            return n;
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "entryCount", retValue);
            }
        }
    }

    public static int entryCount(ObjectReference a) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "entryCount", "JDI CALL: com.sun.jdi.ObjectReference({0}).entryCount()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.entryCount();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "entryCount", retValue);
            }
        }
    }

    public static boolean equals0(ObjectReference a, Object b) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "equals", "JDI CALL: com.sun.jdi.ObjectReference({0}).equals({1})", new Object[]{a, b});
        }
        Serializable retValue = null;
        try {
            boolean ret = a.equals(b);
            retValue = Boolean.valueOf(ret);
            boolean bl = ret;
            return bl;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            boolean bl = false;
            return bl;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            boolean bl = false;
            return bl;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "equals", retValue);
            }
        }
    }

    public static boolean equals(ObjectReference a, Object b) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "equals", "JDI CALL: com.sun.jdi.ObjectReference({0}).equals({1})", new Object[]{a, b});
        }
        Serializable retValue = null;
        try {
            boolean ret = a.equals(b);
            retValue = Boolean.valueOf(ret);
            boolean bl = ret;
            return bl;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "equals", retValue);
            }
        }
    }

    public static Value getValue(ObjectReference a, Field b) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "getValue", "JDI CALL: com.sun.jdi.ObjectReference({0}).getValue({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            Value ret = a.getValue(b);
            retValue = ret;
            Value value = ret;
            return value;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "getValue", retValue);
            }
        }
    }

    public static Map<Field, Value> getValues0(ObjectReference a, List<? extends Field> b) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "getValues", "JDI CALL: com.sun.jdi.ObjectReference({0}).getValues({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            Map<Field, Value> ret = a.getValues(b);
            retValue = ret;
            Map<Field, Value> map = ret;
            return map;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            Map<Field, Value> map = Collections.emptyMap();
            return map;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            Map<Field, Value> map = Collections.emptyMap();
            return map;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            Map<Field, Value> map = Collections.emptyMap();
            return map;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "getValues", retValue);
            }
        }
    }

    public static Map<Field, Value> getValues(ObjectReference a, List<? extends Field> b) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "getValues", "JDI CALL: com.sun.jdi.ObjectReference({0}).getValues({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            Map<Field, Value> ret = a.getValues(b);
            retValue = ret;
            Map<Field, Value> map = ret;
            return map;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "getValues", retValue);
            }
        }
    }

    public static int hashCode0(ObjectReference a) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "hashCode", "JDI CALL: com.sun.jdi.ObjectReference({0}).hashCode()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.hashCode();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            int n = 0;
            return n;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            int n = 0;
            return n;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            int n = 0;
            return n;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "hashCode", retValue);
            }
        }
    }

    public static int hashCode(ObjectReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "hashCode", "JDI CALL: com.sun.jdi.ObjectReference({0}).hashCode()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.hashCode();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "hashCode", retValue);
            }
        }
    }

    public static Value invokeMethod(ObjectReference a, ThreadReference b, Method c, List<? extends Value> d, int e) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "invokeMethod", "JDI CALL: com.sun.jdi.ObjectReference({0}).invokeMethod({1}, {2}, {3}, {4})", new Object[]{a, b, c, d, e});
        }
        Object retValue = null;
        try {
            Value ret = a.invokeMethod(b, c, d, e);
            retValue = ret;
            Value value = ret;
            return value;
        }
        catch (InternalException iex) {
            if (iex.errorCode() == 502) {
                iex = (InternalException)Exceptions.attachLocalizedMessage((Throwable)iex, (String)NbBundle.getMessage(JPDADebuggerImpl.class, (String)"JDWPError502"));
                Exceptions.printStackTrace((Throwable)iex);
                Value value = null;
                return value;
            }
            try {
                throw iex;
            }
            catch (InternalException ex) {
                retValue = ex;
                JDIExceptionReporter.report(ex);
                throw new InternalExceptionWrapper(ex);
            }
            catch (VMDisconnectedException ex) {
                retValue = ex;
                if (a instanceof Mirror) {
                    VirtualMachine vm = a.virtualMachine();
                    try {
                        vm.dispose();
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        // empty catch block
                    }
                }
                throw new VMDisconnectedExceptionWrapper(ex);
            }
            catch (ObjectCollectedException ex) {
                retValue = ex;
                throw new ObjectCollectedExceptionWrapper(ex);
            }
            catch (InvalidTypeException ex) {
                retValue = ex;
                throw ex;
            }
            catch (ClassNotLoadedException ex) {
                retValue = ex;
                throw ex;
            }
            catch (IncompatibleThreadStateException ex) {
                retValue = ex;
                throw ex;
            }
            catch (InvocationException ex) {
                retValue = ex;
                throw ex;
            }
            catch (Error err) {
                retValue = err;
                throw err;
            }
            catch (RuntimeException rex) {
                retValue = rex;
                throw rex;
            }
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "invokeMethod", retValue);
            }
        }
    }

    public static boolean isCollected0(ObjectReference a) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "isCollected", "JDI CALL: com.sun.jdi.ObjectReference({0}).isCollected()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            boolean ret = a.isCollected();
            retValue = Boolean.valueOf(ret);
            boolean bl = ret;
            return bl;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            boolean bl = false;
            return bl;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            boolean bl = false;
            return bl;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "isCollected", retValue);
            }
        }
    }

    public static boolean isCollected(ObjectReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "isCollected", "JDI CALL: com.sun.jdi.ObjectReference({0}).isCollected()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            boolean ret = a.isCollected();
            retValue = Boolean.valueOf(ret);
            boolean bl = ret;
            return bl;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "isCollected", retValue);
            }
        }
    }

    public static ThreadReference owningThread(ObjectReference a) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "owningThread", "JDI CALL: com.sun.jdi.ObjectReference({0}).owningThread()", new Object[]{a});
        }
        Object retValue = null;
        try {
            ThreadReference ret = a.owningThread();
            retValue = ret;
            ThreadReference threadReference = ret;
            return threadReference;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "owningThread", retValue);
            }
        }
    }

    public static ReferenceType referenceType(ObjectReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "referenceType", "JDI CALL: com.sun.jdi.ObjectReference({0}).referenceType()", new Object[]{a});
        }
        Object retValue = null;
        try {
            ReferenceType ret = a.referenceType();
            retValue = ret;
            ReferenceType referenceType = ret;
            return referenceType;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "referenceType", retValue);
            }
        }
    }

    public static List<ObjectReference> referringObjects0(ObjectReference a, long b) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "referringObjects", "JDI CALL: com.sun.jdi.ObjectReference({0}).referringObjects({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            List<ObjectReference> ret = a.referringObjects(b);
            retValue = ret;
            List<ObjectReference> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<ObjectReference> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            List<ObjectReference> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            List<ObjectReference> list = Collections.emptyList();
            return list;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "referringObjects", retValue);
            }
        }
    }

    public static List<ObjectReference> referringObjects(ObjectReference a, long b) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "referringObjects", "JDI CALL: com.sun.jdi.ObjectReference({0}).referringObjects({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            List<ObjectReference> ret = a.referringObjects(b);
            retValue = ret;
            List<ObjectReference> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "referringObjects", retValue);
            }
        }
    }

    public static void setValue(ObjectReference a, Field b, Value c) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalArgumentExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "setValue", "JDI CALL: com.sun.jdi.ObjectReference({0}).setValue({1}, {2})", new Object[]{a, b, c});
        }
        try {
            a.setValue(b, c);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "setValue", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static long uniqueID(ObjectReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "uniqueID", "JDI CALL: com.sun.jdi.ObjectReference({0}).uniqueID()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            long ret = a.uniqueID();
            retValue = Long.valueOf(ret);
            long l = ret;
            return l;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "uniqueID", retValue);
            }
        }
    }

    public static List<ThreadReference> waitingThreads0(ObjectReference a) throws IncompatibleThreadStateException {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "waitingThreads", "JDI CALL: com.sun.jdi.ObjectReference({0}).waitingThreads()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<ThreadReference> ret = a.waitingThreads();
            retValue = ret;
            List<ThreadReference> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<ThreadReference> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            List<ThreadReference> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            List<ThreadReference> list = Collections.emptyList();
            return list;
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "waitingThreads", retValue);
            }
        }
    }

    public static List<ThreadReference> waitingThreads(ObjectReference a) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ObjectReference", "waitingThreads", "JDI CALL: com.sun.jdi.ObjectReference({0}).waitingThreads()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<ThreadReference> ret = a.waitingThreads();
            retValue = ret;
            List<ThreadReference> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (IncompatibleThreadStateException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ObjectReference", "waitingThreads", retValue);
            }
        }
    }
}

