/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.breakpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.java.lsp.server.debugging.NbThreads;
import org.netbeans.modules.java.lsp.server.debugging.breakpoints.NbBreakpoint;

public final class BreakpointsManager {
    private static final Logger LOGGER = Logger.getLogger(BreakpointsManager.class.getName());
    private final NbThreads threadsProvider;
    private final List<NbBreakpoint> breakpoints;
    private final HashMap<String, HashMap<Integer, NbBreakpoint>> sourceToBreakpoints;
    private final AtomicInteger nextBreakpointId = new AtomicInteger(1);
    private final AtomicReference<ExceptionBreakpoint> exceptionBreakpoint = new AtomicReference<Object>(null);
    private final ExceptionBreakpointListener exceptionBreakpointListener = new ExceptionBreakpointListener();
    private final Map<Integer, Breakpoint> hitBreakpoints = new ConcurrentHashMap<Integer, Breakpoint>();
    private final Map<Integer, Variable> exceptionsByThreads = new ConcurrentHashMap<Integer, Variable>();

    public BreakpointsManager(NbThreads threadsProvider) {
        this.threadsProvider = threadsProvider;
        this.breakpoints = Collections.synchronizedList(new ArrayList(5));
        this.sourceToBreakpoints = new HashMap();
    }

    public NbBreakpoint[] setBreakpoints(String source, NbBreakpoint[] breakpoints, boolean sourceModified) {
        ArrayList<NbBreakpoint> result = new ArrayList<NbBreakpoint>();
        HashMap<Integer, NbBreakpoint> breakpointMap = this.sourceToBreakpoints.get(source);
        if (sourceModified && breakpointMap != null) {
            for (NbBreakpoint bp : breakpointMap.values()) {
                try {
                    bp.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, String.format("Remove breakpoint exception: %s", e.toString()), e);
                }
                this.breakpoints.remove(bp);
            }
            this.sourceToBreakpoints.put(source, null);
            breakpointMap = null;
        }
        if (breakpointMap == null) {
            breakpointMap = new HashMap();
            this.sourceToBreakpoints.put(source, breakpointMap);
        }
        ArrayList<NbBreakpoint> toAdd = new ArrayList<NbBreakpoint>();
        ArrayList<Integer> visitedLineNumbers = new ArrayList<Integer>();
        for (NbBreakpoint breakpoint : breakpoints) {
            NbBreakpoint existingBP = breakpointMap.get(breakpoint.getLineNumber());
            if (existingBP != null) {
                result.add(existingBP);
                visitedLineNumbers.add(existingBP.getLineNumber());
                continue;
            }
            result.add(breakpoint);
            toAdd.add(breakpoint);
        }
        ArrayList<NbBreakpoint> toRemove = new ArrayList<NbBreakpoint>();
        for (NbBreakpoint breakpoint : breakpointMap.values()) {
            if (visitedLineNumbers.contains(breakpoint.getLineNumber())) continue;
            toRemove.add(breakpoint);
        }
        this.removeBreakpointsInternally(source, toRemove.toArray(new NbBreakpoint[0]));
        this.addBreakpointsInternally(source, toAdd.toArray(new NbBreakpoint[0]));
        return result.toArray(new NbBreakpoint[0]);
    }

    private void addBreakpointsInternally(String source, NbBreakpoint[] breakpoints) {
        Map breakpointMap = this.sourceToBreakpoints.computeIfAbsent(source, k -> new HashMap());
        if (breakpoints != null && breakpoints.length > 0) {
            for (NbBreakpoint breakpoint : breakpoints) {
                breakpoint.putProperty("id", this.nextBreakpointId.getAndIncrement());
                this.breakpoints.add(breakpoint);
                breakpointMap.put(breakpoint.getLineNumber(), breakpoint);
            }
        }
    }

    private void removeBreakpointsInternally(String source, NbBreakpoint[] breakpoints) {
        Map breakpointMap = this.sourceToBreakpoints.get(source);
        if (breakpointMap == null || breakpointMap.isEmpty() || breakpoints.length == 0) {
            return;
        }
        for (NbBreakpoint breakpoint : breakpoints) {
            if (!this.breakpoints.contains(breakpoint)) continue;
            try {
                breakpoint.close();
                this.breakpoints.remove(breakpoint);
                breakpointMap.remove(breakpoint.getLineNumber());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, String.format("Remove breakpoint exception: %s", e.toString()), e);
            }
        }
    }

    public NbBreakpoint[] getBreakpoints() {
        return this.breakpoints.toArray(new NbBreakpoint[0]);
    }

    public NbBreakpoint[] getBreakpoints(String source) {
        HashMap<Integer, NbBreakpoint> breakpointMap = this.sourceToBreakpoints.get(source);
        if (breakpointMap == null) {
            return new NbBreakpoint[0];
        }
        return breakpointMap.values().toArray(new NbBreakpoint[0]);
    }

    void setExceptionBreakpoints(boolean notifyCaught, boolean notifyUncaught) {
        ExceptionBreakpoint oldEP;
        ExceptionBreakpoint newEP = null;
        if (notifyCaught || notifyUncaught) {
            int catchType = notifyCaught ? (notifyUncaught ? 3 : 1) : 2;
            newEP = ExceptionBreakpoint.create((String)"*", (int)catchType);
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)newEP);
        }
        if ((oldEP = (ExceptionBreakpoint)this.exceptionBreakpoint.getAndSet(newEP)) != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)oldEP);
        }
    }

    public void notifyBreakpointHit(int threadId, Breakpoint currentBreakpoint) {
        if (currentBreakpoint != null) {
            this.hitBreakpoints.put(threadId, currentBreakpoint);
        } else {
            this.hitBreakpoints.remove(threadId);
        }
    }

    public Variable getExceptionOn(int threadId) {
        return this.exceptionsByThreads.get(threadId);
    }

    public void disposeBreakpoints() {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        for (NbBreakpoint breakpoint : this.breakpoints) {
            debuggerManager.removeBreakpoint(breakpoint.getNBBreakpoint());
        }
        ExceptionBreakpoint ep = this.exceptionBreakpoint.getAndSet(null);
        if (ep != null) {
            debuggerManager.removeBreakpoint((Breakpoint)ep);
        }
        debuggerManager.removeAllWatches();
        this.sourceToBreakpoints.clear();
        this.breakpoints.clear();
        this.nextBreakpointId.set(1);
    }

    private class ExceptionBreakpointListener
    implements JPDABreakpointListener {
        private ExceptionBreakpointListener() {
        }

        public void breakpointReached(JPDABreakpointEvent event) {
            Variable exceptionVariable = event.getVariable();
            if (exceptionVariable != null) {
                int threadId = BreakpointsManager.this.threadsProvider.getId(event.getThread());
                BreakpointsManager.this.exceptionsByThreads.put(threadId, exceptionVariable);
            }
        }
    }
}

