/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.SigningStrategy;
import java.beans.ConstructorProperties;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AuthnClientFilter
implements RequestInterceptor {
    public static final String SIGNING_STRATEGY_PROPERTY_NAME = "x-obmcs-internal-signing-strategy-name";
    private final RequestSigner defaultRequestSigner;
    private final Map<SigningStrategy, RequestSigner> requestSigners;

    @ConstructorProperties(value={"defaultRequestSigner", "requestSigners"})
    public AuthnClientFilter(RequestSigner defaultRequestSigner, Map<SigningStrategy, RequestSigner> requestSigners) {
        this.defaultRequestSigner = defaultRequestSigner;
        this.requestSigners = requestSigners;
    }

    public void intercept(HttpRequest request) {
        RequestSigner chosenRequestSigner = this.defaultRequestSigner;
        SigningStrategy perOperationSigningStrategy = (SigningStrategy)((Object)request.attribute(SIGNING_STRATEGY_PROPERTY_NAME));
        if (perOperationSigningStrategy != null && this.requestSigners.containsKey((Object)perOperationSigningStrategy)) {
            chosenRequestSigner = this.requestSigners.get((Object)perOperationSigningStrategy);
            request.removeAttribute(SIGNING_STRATEGY_PROPERTY_NAME);
        }
        Map oldHeaders = request.headers();
        Map<String, String> authHeaders = chosenRequestSigner.signRequest(request.uri(), request.method().name(), oldHeaders, request.body());
        Set oldHeaderNamesLowerCase = oldHeaders.keySet().stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        for (Map.Entry<String, String> e : authHeaders.entrySet()) {
            if (oldHeaderNamesLowerCase.contains(e.getKey().toLowerCase(Locale.ROOT))) continue;
            request.header(e.getKey(), e.getValue());
        }
    }
}

