/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.analysis.api.CodeAnalysis;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.Hacks;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.SPIAccessor;
import org.netbeans.modules.java.hints.spiimpl.SyntheticFix;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.editor.hints.settings.FileHintPreferences;
import org.netbeans.spi.java.hints.Bundle;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class ErrorDescriptionFactory {
    private static final Logger LOG = Logger.getLogger(ErrorDescriptionFactory.class.getName());
    private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.ANNOTATION_TYPE, new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.METHOD, Tree.Kind.VARIABLE});

    private ErrorDescriptionFactory() {
    }

    public static ErrorDescription forTree(HintContext context, TreePath tree, String text, Fix ... fixes) {
        return ErrorDescriptionFactory.forTree(context, tree.getLeaf(), text, fixes);
    }

    public static ErrorDescription forTree(HintContext context, Tree tree, String text, Fix ... fixes) {
        int end;
        int start;
        if (context.getHintMetadata().kind == Hint.Kind.INSPECTION) {
            start = (int)context.getInfo().getTrees().getSourcePositions().getStartPosition(context.getInfo().getCompilationUnit(), tree);
            int javacEnd = (int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree);
            end = Math.min(javacEnd, ErrorDescriptionFactory.findLineEnd(context.getInfo(), start));
        } else {
            int javacEnd = end = context.getCaretLocation();
            start = end;
        }
        if (start != -1 && end != -1) {
            if (start > end) {
                LOG.log(Level.WARNING, "Wrong positions reported for tree (start = {0}, end = {1}): {2}", new Object[]{start, end, tree});
            }
            LazyFixList fixesForED = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.lazyListForFixes(ErrorDescriptionFactory.resolveDefaultFixes(context, fixes));
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((String)("text/x-java:" + context.getHintMetadata().id), (Severity)context.getSeverity(), (String)text, (CharSequence)context.getHintMetadata().description, (LazyFixList)fixesForED, (FileObject)context.getInfo().getFileObject(), (int)start, (int)end);
        }
        return null;
    }

    public static ErrorDescription forSpan(HintContext context, int start, int end, String text, Fix ... fixes) {
        if (context.getHintMetadata().kind != Hint.Kind.INSPECTION) {
            start = end = context.getCaretLocation();
        }
        if (start != -1 && end != -1) {
            LazyFixList fixesForED = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.lazyListForFixes(ErrorDescriptionFactory.resolveDefaultFixes(context, fixes));
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((String)("text/x-java:" + context.getHintMetadata().id), (Severity)context.getSeverity(), (String)text, (CharSequence)context.getHintMetadata().description, (LazyFixList)fixesForED, (FileObject)context.getInfo().getFileObject(), (int)start, (int)end);
        }
        return null;
    }

    public static ErrorDescription forName(HintContext context, TreePath tree, String text, Fix ... fixes) {
        return ErrorDescriptionFactory.forName(context, tree.getLeaf(), text, fixes);
    }

    public static ErrorDescription forName(HintContext context, Tree tree, String text, Fix ... fixes) {
        int[] span = context.getHintMetadata().kind == Hint.Kind.INSPECTION ? ErrorDescriptionFactory.computeNameSpan(tree, context) : new int[]{context.getCaretLocation(), context.getCaretLocation()};
        if (span != null && span[0] != -1 && span[1] != -1) {
            LazyFixList fixesForED = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.lazyListForFixes(ErrorDescriptionFactory.resolveDefaultFixes(context, fixes));
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((String)("text/x-java:" + context.getHintMetadata().id), (Severity)context.getSeverity(), (String)text, (CharSequence)context.getHintMetadata().description, (LazyFixList)fixesForED, (FileObject)context.getInfo().getFileObject(), (int)span[0], (int)span[1]);
        }
        return null;
    }

    private static int[] computeNameSpan(Tree tree, HintContext context) {
        BlockTree bt;
        Collection<? extends TreePath> prefix;
        CompilationInfo info = context.getInfo();
        switch (tree.getKind()) {
            case LABELED_STATEMENT: {
                return info.getTreeUtilities().findNameSpan((LabeledStatementTree)tree);
            }
            case METHOD: {
                return info.getTreeUtilities().findNameSpan((MethodTree)tree);
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return info.getTreeUtilities().findNameSpan((ClassTree)tree);
            }
            case VARIABLE: {
                return info.getTreeUtilities().findNameSpan((VariableTree)tree);
            }
            case MEMBER_SELECT: {
                MemberSelectTree mst = (MemberSelectTree)tree;
                int[] span = info.getTreeUtilities().findNameSpan(mst);
                if (span == null) {
                    int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree);
                    span = new int[]{end - mst.getIdentifier().length(), end};
                }
                return span;
            }
            case METHOD_INVOCATION: {
                return ErrorDescriptionFactory.computeNameSpan(((MethodInvocationTree)tree).getMethodSelect(), context);
            }
        }
        if (tree.getKind() == Tree.Kind.BLOCK && (prefix = context.getMultiVariables().get("$$1$")) != null && (bt = (BlockTree)tree).getStatements().size() > prefix.size()) {
            return ErrorDescriptionFactory.computeNameSpan(bt.getStatements().get(prefix.size()), context);
        }
        int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree);
        if (StatementTree.class.isAssignableFrom(tree.getKind().asInterface()) && tree.getKind() != Tree.Kind.EXPRESSION_STATEMENT && tree.getKind() != Tree.Kind.BLOCK) {
            TokenSequence ts = info.getTokenHierarchy().tokenSequence();
            ts.move(start);
            if (ts.moveNext()) {
                return new int[]{ts.offset(), ts.offset() + ts.token().length()};
            }
        }
        return new int[]{start, Math.min((int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree), ErrorDescriptionFactory.findLineEnd(info, start))};
    }

    private static int findLineEnd(CompilationInfo info, int start) {
        String text = info.getText();
        for (int i = start + 1; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            return i;
        }
        return text.length();
    }

    static List<Fix> resolveDefaultFixes(HintContext ctx, Fix ... provided) {
        LinkedList<Fix> auxiliaryFixes = new LinkedList<Fix>();
        HintMetadata hm = SPIAccessor.getINSTANCE().getHintMetadata(ctx);
        if (hm != null) {
            LinkedHashSet<String> suppressWarningsKeys = new LinkedHashSet<String>();
            for (String string : hm.suppressWarnings) {
                if (string == null || string.isEmpty()) break;
                suppressWarningsKeys.add(string);
            }
            auxiliaryFixes.add(new DisableConfigure(ctx.getInfo().getFileObject(), hm, true, SPIAccessor.getINSTANCE().getHintSettings(ctx)));
            auxiliaryFixes.add(new DisableConfigure(ctx.getInfo().getFileObject(), hm, false, null));
            if (hm.kind == Hint.Kind.INSPECTION && !hm.options.contains((Object)HintMetadata.Options.NO_BATCH)) {
                auxiliaryFixes.add(new InspectFix(hm, false));
                if (!hm.options.contains((Object)HintMetadata.Options.QUERY)) {
                    auxiliaryFixes.add(new InspectFix(hm, true));
                }
            }
            if (!suppressWarningsKeys.isEmpty()) {
                auxiliaryFixes.addAll(ErrorDescriptionFactory.createSuppressWarnings(ctx.getInfo(), ctx.getPath(), (String[])suppressWarningsKeys.toArray(String[]::new)));
            }
            LinkedList<Fix> result = new LinkedList<Fix>();
            for (Fix f : provided != null ? provided : new Fix[]{}) {
                if (f == null) continue;
                result.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes((Fix)f, auxiliaryFixes));
            }
            if (result.isEmpty()) {
                result.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes((Fix)new TopLevelConfigureFix(ctx.getInfo().getFileObject(), hm), auxiliaryFixes));
            }
            return result;
        }
        return Arrays.asList(provided);
    }

    static Fix createSuppressWarningsFix(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"keys", (Object)keys);
        if (keys.length == 0) {
            throw new IllegalArgumentException("key must not be empty");
        }
        if (!ErrorDescriptionFactory.isSuppressWarningsSupported(compilationInfo)) {
            return null;
        }
        while (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)treePath.getLeaf().getKind())) {
            treePath = treePath.getParentPath();
        }
        if (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            FixImpl javaFix = new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), compilationInfo.getFileObject(), keys);
            class SyntheticJavaFixImpl
            extends JavaFixImpl
            implements SyntheticFix {
                public SyntheticJavaFixImpl(JavaFix jf) {
                    super(jf);
                }
            }
            return new SyntheticJavaFixImpl(javaFix);
        }
        return null;
    }

    static List<Fix> createSuppressWarnings(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"keys", (Object)keys);
        if (keys.length == 0) {
            throw new IllegalArgumentException("key must not be empty");
        }
        Fix f = ErrorDescriptionFactory.createSuppressWarningsFix(compilationInfo, treePath, keys);
        return f != null ? List.of(f) : List.of();
    }

    private static boolean isSuppressWarningsSupported(CompilationInfo info) {
        if (info.getElements().getTypeElement("java.lang.SuppressWarnings") == null) {
            return false;
        }
        return info.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0;
    }

    private static class DisableConfigure
    implements Fix,
    SyntheticFix {
        @NonNull
        private final FileObject file;
        @NonNull
        private final HintMetadata metadata;
        private final boolean disable;
        private final HintsSettings hintsSettings;

        DisableConfigure(@NonNull FileObject file, @NonNull HintMetadata metadata, boolean disable, HintsSettings hintsSettings) {
            this.file = file;
            this.metadata = metadata;
            this.disable = disable;
            this.hintsSettings = hintsSettings;
        }

        public String getText() {
            String displayName = this.metadata.displayName;
            String key = switch (this.metadata.kind) {
                default -> throw new IncompatibleClassChangeError();
                case Hint.Kind.INSPECTION -> {
                    if (this.disable) {
                        yield "FIX_DisableHint";
                    }
                    yield "FIX_ConfigureHint";
                }
                case Hint.Kind.ACTION -> this.disable ? "FIX_DisableSuggestion" : "FIX_ConfigureSuggestion";
            };
            return NbBundle.getMessage(ErrorDescriptionFactory.class, (String)key, (Object)displayName);
        }

        public ChangeInfo implement() throws Exception {
            if (this.disable) {
                this.hintsSettings.setEnabled(this.metadata, false);
            } else {
                FileHintPreferences.openFilePreferences((FileObject)this.file, (String)"text/x-java", (String)this.metadata.id);
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DisableConfigure other = (DisableConfigure)obj;
            if (!(this.metadata == other.metadata || this.metadata != null && this.metadata.equals(other.metadata))) {
                return false;
            }
            return this.disable == other.disable;
        }

        public int hashCode() {
            int hash = 7;
            hash = 43 * hash + (this.metadata != null ? this.metadata.hashCode() : 0);
            hash = 43 * hash + (this.disable ? 1 : 0);
            return hash;
        }
    }

    private record InspectFix(@NonNull HintMetadata metadata, boolean transform) implements Fix,
    SyntheticFix
    {
        public String getText() {
            return this.transform ? Bundle.DN_InspectAndTransform() : Bundle.DN_Inspect();
        }

        public ChangeInfo implement() throws Exception {
            SwingUtilities.invokeLater(() -> {
                if (this.transform) {
                    Hacks.InspectAndTransformOpener o = (Hacks.InspectAndTransformOpener)Lookup.getDefault().lookup(Hacks.InspectAndTransformOpener.class);
                    if (o != null) {
                        o.openIAT(this.metadata);
                    }
                } else {
                    CodeAnalysis.open((Analyzer.WarningDescription)Analyzer.WarningDescription.create((String)("text/x-java:" + this.metadata.id), null, null, null));
                }
            });
            return null;
        }
    }

    private static final class TopLevelConfigureFix
    extends DisableConfigure
    implements EnhancedFix {
        public TopLevelConfigureFix(@NonNull FileObject file, @NonNull HintMetadata metadata) {
            super(file, metadata, false, null);
        }

        public CharSequence getSortText() {
            return "\uffffzz";
        }
    }

    private static final class FixImpl
    extends JavaFix {
        private final String[] keys;
        private final TreePathHandle handle;
        private final FileObject file;

        public FixImpl(TreePathHandle handle, FileObject file, String ... keys) {
            super(handle);
            this.keys = keys;
            this.handle = handle;
            this.file = file;
        }

        @Override
        public String getText() {
            StringBuilder keyNames = new StringBuilder();
            for (int i = 0; i < this.keys.length; ++i) {
                String string = this.keys[i];
                keyNames.append(string);
                if (i >= this.keys.length - 1) continue;
                keyNames.append(", ");
            }
            return NbBundle.getMessage(ErrorDescriptionFactory.class, (String)"LBL_FIX_Suppress_Waning", (Object)keyNames.toString());
        }

        @Override
        public void performRewrite(JavaFix.TransformationContext ctx) throws IOException {
            ModifiersTree modifiers;
            TreePath path;
            WorkingCopy copy = ctx.getWorkingCopy();
            for (path = ctx.getPath(); path != null && path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)path.getLeaf().getKind()); path = path.getParentPath()) {
            }
            if (path == null || path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                return;
            }
            Tree top = path.getLeaf();
            TreePath lambdaPath = null;
            switch (top.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    ModifiersTree modifiersTree = ((ClassTree)top).getModifiers();
                    break;
                }
                case METHOD: {
                    ModifiersTree modifiersTree = ((MethodTree)top).getModifiers();
                    break;
                }
                case VARIABLE: {
                    TreePath parent = path.getParentPath();
                    if (parent != null && parent.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                        TreePath typePath = TreePath.getPath(parent, ((VariableTree)top).getType());
                        if (copy.getTreeUtilities().isSynthetic(typePath)) {
                            lambdaPath = parent;
                        }
                    }
                    ModifiersTree modifiersTree = ((VariableTree)top).getModifiers();
                    break;
                }
                default: {
                    assert (false) : "Unhandled Tree.Kind";
                    ModifiersTree modifiersTree = modifiers = null;
                }
            }
            if (modifiers == null) {
                return;
            }
            TypeElement el = copy.getElements().getTypeElement("java.lang.SuppressWarnings");
            if (el == null) {
                return;
            }
            ExpressionTree[] keyLiterals = new LiteralTree[this.keys.length];
            for (int i = 0; i < this.keys.length; ++i) {
                keyLiterals[i] = copy.getTreeMaker().Literal((Object)this.keys[i]);
            }
            if (lambdaPath != null) {
                LambdaExpressionTree let = (LambdaExpressionTree)lambdaPath.getLeaf();
                for (VariableTree variableTree : let.getParameters()) {
                    TreePath typePath = TreePath.getPath(lambdaPath, variableTree.getType());
                    if (!copy.getTreeUtilities().isSynthetic(typePath)) continue;
                    Tree imported = copy.getTreeMaker().Type(copy.getTrees().getTypeMirror(typePath));
                    copy.rewrite(variableTree.getType(), imported);
                }
            }
            ModifiersTree nueMods = GeneratorUtilities.get((WorkingCopy)copy).appendToAnnotationValue(modifiers, el, "value", keyLiterals);
            copy.rewrite((Tree)modifiers, (Tree)nueMods);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FixImpl other = (FixImpl)obj;
            if (!Arrays.deepEquals(this.keys, other.keys)) {
                return false;
            }
            if (!(this.handle == other.handle || this.handle != null && this.handle.equals((Object)other.handle))) {
                return false;
            }
            return this.file == other.file || this.file != null && this.file.equals(other.file);
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + Arrays.deepHashCode(this.keys);
            hash = 79 * hash + (this.handle != null ? this.handle.hashCode() : 0);
            hash = 79 * hash + (this.file != null ? this.file.hashCode() : 0);
            return hash;
        }
    }
}

