/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.LocallyDownloadedTableModel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitDetails;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateUnitListener;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.UninstallUnitWizard;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class UnitTab
extends JPanel {
    static final String PROP_LAST_CHECK = "lastCheckTime";
    private PreferenceChangeListener preferenceChangeListener;
    private UnitTable table = null;
    private UnitDetails details = null;
    private UnitCategoryTableModel model = null;
    private DocumentListener dlForSearch;
    private FocusListener flForSearch;
    private String filter = "";
    private PluginManagerUI manager = null;
    private PopupActionSupport popupActionsSupport;
    private ButtonActionSupport buttonsActionsSupport;
    private TabAction reloadAction;
    private RowTabAction moreAction;
    private RowTabAction lessAction;
    private RowTabAction removeLocallyDownloaded;
    private static Boolean isWaitingForExternal = false;
    private static final RequestProcessor SEARCH_PROCESSOR = new RequestProcessor("search-processor");
    private final RequestProcessor.Task searchTask = SEARCH_PROCESSOR.create(new Runnable(){

        @Override
        public void run() {
            if (UnitTab.this.filter != null) {
                int row = UnitTab.this.getSelectedRow();
                final Unit u = row >= 0 ? UnitTab.this.getModel().getUnitAtRow(row) : null;
                final Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                Runnable runAftreWards = new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (u != null) {
                            int row = this.this$1.UnitTab.this.findRow(u.updateUnit.getCodeName());
                            this.this$1.UnitTab.this.restoreSelectedRow(row);
                        }
                        UnitCategoryTableModel.restoreState(this.this$1.UnitTab.this.model.getUnits(), state, this.this$1.UnitTab.this.model.isMarkedAsDefault());
                        this.this$1.UnitTab.this.refreshState();
                    }
                };
                UnitTab.this.model.setFilter(UnitTab.this.filter, runAftreWards);
            }
        }
    });
    private static final RequestProcessor DOWNLOAD_SIZE_PROCESSOR = new RequestProcessor("download-size-processor", 1, true);
    private RequestProcessor.Task getDownloadSizeTask = null;
    private Collection<Unit> oldUnits = Collections.emptySet();
    private JButton bDeactivate;
    private JButton bTabAction;
    private JButton bUninstall;
    private JCheckBox detailView;
    private JLabel lSearch;
    private JLabel lSelectionInfo;
    private JLabel lWarning;
    private JSplitPane spTab;
    private JTextField tfSearch;
    private JButton topButton;

    public UnitTab(UnitTable table, UnitDetails details, PluginManagerUI manager) {
        this.table = table;
        this.details = details;
        this.manager = manager;
        TableModel m = table.getModel();
        assert (m instanceof UnitCategoryTableModel) : m + " instanceof UnitCategoryTableModel.";
        this.model = (UnitCategoryTableModel)m;
        table.getSelectionModel().setSelectionMode(0);
        this.initComponents();
        this.lWarning.setVisible(false);
        this.spTab.setLeftComponent(new JScrollPane(table));
        this.spTab.setRightComponent(new JScrollPane(details, 20, 30));
        this.initTab();
        this.listenOnSelection();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                super.componentShown(e);
                UnitTab.this.focusTable();
            }
        });
        this.addUpdateUnitListener(new UpdateUnitListener(){

            @Override
            public void updateUnitsChanged() {
                UnitTab.this.manager.updateUnitsChanged();
            }

            @Override
            public void buttonsChanged() {
                UnitTab.this.manager.buttonsChanged();
            }

            @Override
            public void filterChanged() {
                UnitTab.this.model.fireTableDataChanged();
                UnitTab.this.manager.decorateTabTitle(UnitTab.this.table);
                UnitTab.this.refreshState();
            }
        });
        table.getInputMap().put(KeyStroke.getKeyStroke(121, 64), "org.netbeans.modules.autoupdate.ui.UnitTab.PopupActionSupport");
        table.getActionMap().put("org.netbeans.modules.autoupdate.ui.UnitTab.PopupActionSupport", this.popupActionsSupport.popupOnF10);
    }

    void focusTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UnitTab.this.table.requestFocusInWindow();
            }
        });
    }

    UnitCategoryTableModel getModel() {
        return this.model;
    }

    UnitTable getTable() {
        return this.table;
    }

    public String getHelpId() {
        return UnitTab.class.getName() + '.' + (Object)((Object)this.model.getType());
    }

    void setWaitingState(boolean waitingState) {
        Component[] all;
        boolean enabled = !waitingState;
        for (Component component : all = this.getComponents()) {
            if (component == this.bTabAction || component == this.bDeactivate || component == this.bUninstall) {
                if (enabled) {
                    TabAction a = (TabAction)((AbstractButton)component).getAction();
                    component.setEnabled(a == null ? false : a.isEnabled());
                    continue;
                }
                component.setEnabled(enabled);
                continue;
            }
            if (component == this.spTab) {
                this.spTab.getLeftComponent().setEnabled(enabled);
                this.spTab.getRightComponent().setEnabled(enabled);
                this.details.setEnabled(enabled);
                this.table.setEnabled(enabled);
                continue;
            }
            component.setEnabled(enabled);
        }
        if (this.reloadAction != null) {
            this.reloadAction.setEnabled(enabled);
        }
        Container parent = this.getParent();
        JRootPane rootPane = this.getRootPane();
        if (parent != null) {
            parent.setEnabled(enabled);
        }
        if (rootPane != null) {
            if (enabled) {
                rootPane.setCursor(null);
            } else {
                rootPane.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
        this.focusTable();
    }

    private void prepareTopButton(Action action) {
        if (action != null) {
            this.topButton.setToolTipText((String)action.getValue("ToolTipText"));
            this.topButton.setAction(action);
            this.topButton.setVisible(true);
        } else {
            this.topButton.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        super.addNotify();
        if (this.dlForSearch == null) {
            this.tfSearch.getDocument().addDocumentListener(this.getDocumentListener());
        }
        if (this.flForSearch == null) {
            this.flForSearch = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    UnitTab.this.tfSearch.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    UnitTab.this.tfSearch.select(0, 0);
                }
            };
            this.tfSearch.addFocusListener(this.flForSearch);
        }
        RequestProcessor.Task runningTask = PluginManagerUI.getRunningTask(new Runnable(){

            @Override
            public void run() {
                if (isWaitingForExternal.booleanValue()) {
                    UnitTab.this.reloadTask(false).schedule(10);
                    isWaitingForExternal = false;
                }
            }
        });
        UnitTab unitTab = this;
        synchronized (unitTab) {
            if (runningTask != null && !runningTask.isFinished() && !isWaitingForExternal.booleanValue()) {
                isWaitingForExternal = true;
                runningTask.addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        if (isWaitingForExternal.booleanValue()) {
                            UnitTab.this.reloadTask(false).schedule(10);
                        }
                        isWaitingForExternal = false;
                    }
                });
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.dlForSearch != null) {
            this.tfSearch.getDocument().removeDocumentListener(this.getDocumentListener());
        }
        this.dlForSearch = null;
        if (this.flForSearch != null) {
            this.tfSearch.removeFocusListener(this.flForSearch);
        }
        this.flForSearch = null;
        Preferences p = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        if (this.preferenceChangeListener != null) {
            p.removePreferenceChangeListener(this.preferenceChangeListener);
            this.preferenceChangeListener = null;
        }
    }

    public void refreshState() {
        this.detailView.setVisible(this.model.supportsTwoViews());
        Collection<Unit> units = this.model.getMarkedUnits();
        if (this.oldUnits.equals(units)) {
            return;
        }
        this.oldUnits = units;
        this.popupActionsSupport.tableDataChanged();
        this.buttonsActionsSupport.tableDataChanged();
        if (units.isEmpty()) {
            this.cleanSelectionInfo();
        } else {
            this.setSelectionInfo(null, units.size());
        }
        this.getDefaultAction().tableDataChanged(units);
        boolean alreadyScheduled = false;
        if (this.getDownloadSizeTask != null) {
            if (this.getDownloadSizeTask.getDelay() > 0) {
                this.getDownloadSizeTask.schedule(1000);
                alreadyScheduled = true;
            } else if (!this.getDownloadSizeTask.isFinished()) {
                this.getDownloadSizeTask.cancel();
            }
        }
        if (units.size() > 0 && !alreadyScheduled) {
            this.getDownloadSizeTask = DOWNLOAD_SIZE_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    int downloadSize = UnitTab.this.model.getDownloadSize();
                    if (Thread.interrupted()) {
                        return;
                    }
                    if (UnitTab.this.model.getMarkedUnits().isEmpty()) {
                        UnitTab.this.cleanSelectionInfo();
                    } else {
                        UnitTab.this.setSelectionInfo(Utilities.getDownloadSizeAsString(downloadSize), UnitTab.this.model.getMarkedUnits().size());
                    }
                }
            }, 150);
        }
    }

    final void updateTab(final Map<String, Boolean> state) {
        Runnable addUpdates = new Runnable(){
            final /* synthetic */ UnitTab this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                LocallyDownloadedTableModel downloadedTableModel = (LocallyDownloadedTableModel)this.this$0.model;
                List<UpdateUnit> empty = Collections.emptyList();
                downloadedTableModel.setUnits(empty);
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.fireUpdataUnitChange();
                        UnitCategoryTableModel.restoreState(this.this$1.this$0.model.getUnits(), state, this.this$1.this$0.model.isMarkedAsDefault());
                        this.this$1.this$0.refreshState();
                        this.this$1.this$0.setWaitingState(false);
                    }
                });
            }
        };
        this.setWaitingState(true);
        Utilities.startAsWorkerThread(addUpdates, 250);
    }

    private TabAction getDefaultAction() {
        return (TabAction)this.bTabAction.getAction();
    }

    private void initTab() {
        RowTabAction[] forPopup = null;
        TabAction[] forButtons = null;
        switch (this.model.getType()) {
            case INSTALLED: {
                CheckCategoryAction checkCategoryAction = new CheckCategoryAction();
                UncheckCategoryAction uncheckCategoryAction = new UncheckCategoryAction();
                CheckAllAction checkAllAction = new CheckAllAction();
                UncheckAllAction uncheckAllAction = new UncheckAllAction();
                ActivateCategoryAction activateCategoryAction = new ActivateCategoryAction();
                DeactivateCategoryAction deactivateCategoryAction = new DeactivateCategoryAction();
                ActivateAction activateAction = new ActivateAction();
                DeactivateAction deactivateAction = new DeactivateAction();
                UninstallAction uninstallAction = new UninstallAction();
                ActivateRowAction activateRowAction = new ActivateRowAction();
                DeactivateRowAction deactivateRowAction = new DeactivateRowAction();
                UninstallRowAction uninstallRowAction = new UninstallRowAction();
                forPopup = new RowTabAction[]{activateRowAction, deactivateRowAction, activateCategoryAction, deactivateCategoryAction, checkCategoryAction, uncheckCategoryAction, checkAllAction, uncheckAllAction, new CheckAction(), uninstallRowAction};
                forButtons = new TabAction[]{activateAction, deactivateAction, uninstallAction};
                this.bDeactivate.setVisible(true);
                this.bUninstall.setVisible(true);
                this.bTabAction.setAction(activateAction);
                this.bDeactivate.setAction(deactivateAction);
                this.bUninstall.setAction(uninstallAction);
                this.prepareTopButton(null);
                this.table.setEnableRenderer(new EnableRenderer());
                this.initReloadTooltip();
                break;
            }
            case UPDATE: {
                CheckCategoryAction selectCategoryAction = new CheckCategoryAction();
                UncheckCategoryAction deselectCategoryAction = new UncheckCategoryAction();
                CheckAllAction selectAllAction = new CheckAllAction();
                UncheckAllAction deselectAllAction = new UncheckAllAction();
                this.moreAction = new MoreAction();
                this.lessAction = new LessAction();
                forPopup = new RowTabAction[]{new UpdateRowAction(), selectCategoryAction, deselectCategoryAction, selectAllAction, deselectAllAction, new CheckAction(), this.moreAction, this.lessAction};
                this.bTabAction.setAction(new UpdateAction());
                this.bDeactivate.setVisible(false);
                this.bUninstall.setVisible(false);
                this.reloadAction = new ReloadAction("UnitTab_ReloadActionUpdates");
                this.prepareTopButton(this.reloadAction);
                this.initReloadTooltip();
                break;
            }
            case AVAILABLE: {
                CheckCategoryAction selectCategoryAction = new CheckCategoryAction();
                UncheckCategoryAction deselectCategoryAction = new UncheckCategoryAction();
                CheckAllAction selectAllAction = new CheckAllAction();
                UncheckAllAction deselectAllAction = new UncheckAllAction();
                this.moreAction = new MoreAction();
                this.lessAction = new LessAction();
                forPopup = new RowTabAction[]{new AvailableRowAction(), selectCategoryAction, deselectCategoryAction, selectAllAction, deselectAllAction, new CheckAction(), this.moreAction, this.lessAction};
                this.bTabAction.setAction(new AvailableAction());
                this.bDeactivate.setVisible(false);
                this.bUninstall.setVisible(false);
                this.reloadAction = new ReloadAction("UnitTab_ReloadAction");
                this.prepareTopButton(this.reloadAction);
                this.table.setEnableRenderer(new SourceCategoryRenderer());
                this.initReloadTooltip();
                break;
            }
            case LOCAL: {
                this.removeLocallyDownloaded = new RemoveLocallyDownloadedAction();
                forPopup = new RowTabAction[]{new LocalUpdateRowAction(), this.removeLocallyDownloaded, new CheckAction()};
                this.bTabAction.setAction(new LocalUpdateAction());
                this.bDeactivate.setVisible(false);
                this.bUninstall.setVisible(false);
                this.prepareTopButton(new AddLocallyDownloadedAction());
            }
        }
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                UnitTab.this.refreshState();
            }
        });
        this.popupActionsSupport = new PopupActionSupport(forPopup);
        this.table.addMouseListener(this.popupActionsSupport);
        this.buttonsActionsSupport = new ButtonActionSupport(forButtons);
        this.getDefaultAction().setEnabled(this.model.getMarkedUnits().size() > 0);
    }

    private void cleanSelectionInfo() {
        this.lSelectionInfo.setText("");
        this.lWarning.setText("");
        this.lWarning.setIcon(null);
    }

    private void setSelectionInfo(String downloadSize, int count) {
        String key;
        String operationNameKey = null;
        switch (this.model.getType()) {
            case INSTALLED: {
                operationNameKey = "UnitTab_OperationName_Text_INSTALLED";
                break;
            }
            case UPDATE: {
                operationNameKey = "UnitTab_OperationName_Text_UPDATE";
                break;
            }
            case AVAILABLE: {
                operationNameKey = "UnitTab_OperationName_Text_AVAILABLE";
                break;
            }
            case LOCAL: {
                operationNameKey = "UnitTab_OperationName_Text_LOCAL";
            }
        }
        String string = key = count == 1 ? "UnitTab_lHowManySelected_Single_Text" : "UnitTab_lHowManySelected_Many_Text";
        if (UnitCategoryTableModel.Type.INSTALLED == this.model.getType() || UnitCategoryTableModel.Type.LOCAL == this.model.getType()) {
            this.lSelectionInfo.setText(NbBundle.getMessage(UnitTab.class, (String)key, (Object)count));
        } else if (downloadSize == null) {
            this.lSelectionInfo.setText(NbBundle.getMessage(UnitTab.class, (String)key, (Object)count));
        } else {
            this.lSelectionInfo.setText(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_lHowManySelected_TextFormatWithSize", (Object)NbBundle.getMessage(UnitTab.class, (String)key, (Object)count), (Object)downloadSize));
        }
        if (this.model.needsRestart()) {
            ImageIcon warningIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/warning.gif", (boolean)false);
            this.lWarning.setIcon(warningIcon);
            this.lWarning.setText(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_lWarning_Text", (Object)NbBundle.getMessage(UnitTab.class, (String)operationNameKey)));
        }
    }

    private void showDetailsAtRow(int row) {
        this.showDetailsAtRow(row, null);
    }

    private void showDetailsAtRow(int row, Action action) {
        if (row == -1) {
            this.details.setUnit(null);
        } else {
            Unit u;
            Unit unit = u = this.model.isExpansionControlAtRow(row) ? null : this.model.getUnitAtRow(row);
            if (u != null) {
                this.details.setUnit(u, action);
            }
        }
    }

    private void listenOnSelection() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(final ListSelectionEvent e) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.valueChanged(e);
                        }
                    });
                    return;
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    UnitTab.this.showDetailsAtRow(-1);
                    UnitTab.this.popupActionsSupport.rowChanged(-1);
                } else {
                    int selectedRow = UnitTab.this.table.convertRowIndexToModel(lsm.getMinSelectionIndex());
                    UnitTab.this.popupActionsSupport.rowChanged(selectedRow);
                    RowTabAction action = null;
                    if (UnitTab.this.removeLocallyDownloaded != null && UnitTab.this.removeLocallyDownloaded.isEnabled()) {
                        action = UnitTab.this.removeLocallyDownloaded;
                    }
                    UnitTab.this.showDetailsAtRow(selectedRow, action);
                }
            }
        });
    }

    public void addUpdateUnitListener(UpdateUnitListener l) {
        this.model.addUpdateUnitListener(l);
    }

    public void removeUpdateUnitListener(UpdateUnitListener l) {
        this.model.removeUpdateUnitListener(l);
    }

    void fireUpdataUnitChange() {
        this.model.fireUpdataUnitChange();
    }

    DocumentListener getDocumentListener() {
        if (this.dlForSearch == null) {
            this.dlForSearch = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent arg0) {
                    UnitTab.this.filter = UnitTab.this.tfSearch.getText().trim();
                    UnitTab.this.searchTask.schedule(350);
                }

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                    this.insertUpdate(arg0);
                }

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                    this.insertUpdate(arg0);
                }
            };
        }
        return this.dlForSearch;
    }

    private void initComponents() {
        this.lSelectionInfo = new JLabel();
        this.bTabAction = new JButton();
        this.lSearch = new JLabel();
        this.tfSearch = new JTextField();
        this.spTab = new JSplitPane();
        this.topButton = new JButton();
        this.lWarning = new JLabel();
        this.detailView = new JCheckBox();
        this.bDeactivate = new JButton();
        this.bUninstall = new JButton();
        this.lSearch.setLabelFor(this.tfSearch);
        Mnemonics.setLocalizedText((JLabel)this.lSearch, (String)NbBundle.getMessage(UnitTab.class, (String)"lSearch1.text"));
        this.spTab.setBorder(null);
        this.spTab.setDividerLocation(Integer.parseInt(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Splitter_DefaultDividerLocation")));
        this.spTab.setResizeWeight(0.5);
        this.spTab.setOneTouchExpandable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.topButton, (String)"jButton1");
        this.detailViewInit();
        Mnemonics.setLocalizedText((AbstractButton)this.detailView, (String)NbBundle.getMessage(UnitTab.class, (String)"UnitTab.detailView.text"));
        this.detailView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                UnitTab.this.detailViewItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.topButton).addGap(18, 18, 18).addComponent(this.detailView).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 443, Short.MAX_VALUE).addComponent(this.lSearch).addGap(4, 4, 4).addComponent(this.tfSearch, -2, 114, -2)).addComponent(this.spTab, -1, 776, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.bTabAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDeactivate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bUninstall).addGap(8, 8, 8).addComponent(this.lSelectionInfo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lWarning, -1, 542, Short.MAX_VALUE).addGap(99, 99, 99))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.lSearch).addComponent(this.topButton).addComponent(this.detailView)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spTab, -1, 73, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.bTabAction).addComponent(this.lSelectionInfo, -1, -1, Short.MAX_VALUE).addComponent(this.lWarning).addComponent(this.bDeactivate).addComponent(this.bUninstall)).addContainerGap()));
        layout.linkSize(1, this.lSelectionInfo, this.lWarning);
        this.lSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_Search"));
        this.topButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTab.class, (String)"ACN_Reload"));
        this.topButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_Reload"));
    }

    private void detailViewItemStateChanged(ItemEvent evt) {
        if (this.model.supportsTwoViews()) {
            this.manager.setDetailView(this.detailView.isSelected());
            this.uncheckAll();
            this.manager.updateUnitsChanged();
            System.setProperty("plugin.manager.detail.view.selected", "" + this.detailView.isSelected());
        }
    }

    private void detailViewInit() {
        this.detailView.setVisible(this.model.supportsTwoViews());
        if (this.model.supportsTwoViews()) {
            this.detailView.setSelected(Boolean.getBoolean("plugin.manager.detail.view.selected"));
        }
    }

    private LocalDownloadSupport getLocalDownloadSupport() {
        return this.model instanceof LocallyDownloadedTableModel ? ((LocallyDownloadedTableModel)this.model).getLocalDownloadSupport() : null;
    }

    private RequestProcessor.Task reloadTask(final boolean force) {
        Runnable checkUpdates = new Runnable(){
            final /* synthetic */ UnitTab this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadAction"));
                JComponent progressComp = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
                JLabel detailLabel = new JLabel(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_PrepareReloadAction"));
                this.this$0.manager.setProgressComponent(detailLabel, progressComp);
                handle.setInitialDelay(0);
                handle.start();
                ((UnitTab)this.this$0).manager.initTask.waitFinished();
                this.this$0.setWaitingState(true);
                if (this.this$0.getDownloadSizeTask != null && !this.this$0.getDownloadSizeTask.isFinished()) {
                    if (this.this$0.getDownloadSizeTask.getDelay() > 0) {
                        this.this$0.getDownloadSizeTask.cancel();
                    } else {
                        this.this$0.getDownloadSizeTask.waitFinished();
                    }
                }
                final int row = this.this$0.getSelectedRow();
                final Map<String, Boolean> state = UnitCategoryTableModel.captureState(this.this$0.model.getUnits());
                if (this.this$0.model instanceof LocallyDownloadedTableModel) {
                    ((LocallyDownloadedTableModel)this.this$0.model).removeInstalledUnits();
                    ((LocallyDownloadedTableModel)this.this$0.model).setUnits(null);
                }
                this.this$0.manager.unsetProgressComponent(detailLabel, progressComp);
                Utilities.presentRefreshProviders(this.this$0.manager, force);
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.fireUpdataUnitChange();
                        UnitCategoryTableModel.restoreState(this.this$1.this$0.model.getUnits(), state, this.this$1.this$0.model.isMarkedAsDefault());
                        this.this$1.this$0.restoreSelectedRow(row);
                        this.this$1.this$0.refreshState();
                        this.this$1.this$0.setWaitingState(false);
                    }
                });
            }
        };
        return Utilities.startAsWorkerThread(checkUpdates);
    }

    private void showPopup(Point e, Component invoker) {
        int row = this.table.rowAtPoint(e);
        if (row >= 0) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
            JPopupMenu finalPopup = this.popupActionsSupport.createPopup();
            if (finalPopup != null && finalPopup.getComponentCount() > 0) {
                finalPopup.show(invoker, e.x, e.y);
            }
        }
    }

    private int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    private void restoreSelectedRow(int row) {
        if (row < 0) {
            row = 0;
        }
        for (int temp = row; temp >= 0; --temp) {
            if (temp >= this.table.getRowCount() || temp <= -1) continue;
            this.table.getSelectionModel().setSelectionInterval(temp, temp);
            break;
        }
    }

    int findRow(String codeName) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Unit u = this.model.getUnitAtRow(i);
            if (u == null || !codeName.equals(u.updateUnit.getCodeName())) continue;
            return i;
        }
        return -1;
    }

    private void initReloadTooltip() {
        Preferences p = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        long lastTime = p.getLong(PROP_LAST_CHECK, 0L);
        if (lastTime > 0L) {
            this.topButton.setToolTipText("<html>" + NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime", (Object)("<b>" + new SimpleDateFormat().format(new Date(lastTime)) + "</b>")) + "</html>");
        } else {
            String never = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime_Never");
            this.topButton.setToolTipText("<html>" + NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime", (Object)("<b>" + never + "</b>")) + "/<html>");
        }
        if (this.preferenceChangeListener == null) {
            this.preferenceChangeListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UnitTab.this.initReloadTooltip();
                        }
                    });
                }
            };
            p.addPreferenceChangeListener(this.preferenceChangeListener);
        }
    }

    static String textForKey(String key) {
        JButton jb = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jb, (String)NbBundle.getMessage(UnitTab.class, (String)key));
        return jb.getText();
    }

    static int mnemonicForKey(String key) {
        JButton jb = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jb, (String)NbBundle.getMessage(UnitTab.class, (String)key));
        return jb.getMnemonic();
    }

    private void uncheckAll() {
        Collection<Unit> markedUnits = this.model.getMarkedUnits();
        for (Unit u : markedUnits) {
            if (u == null || !u.isMarked() || !u.canBeMarked()) continue;
            u.setMarked(false);
        }
        this.model.fireTableDataChanged();
    }

    private abstract class RowTabAction
    extends TabAction {
        private Unit u;
        private int row;

        public RowTabAction(String nameKey, String actionCategoryKey) {
            super(nameKey, actionCategoryKey);
        }

        public RowTabAction(String nameKey, KeyStroke accelerator, String actionCategoryKey) {
            super(nameKey, accelerator, actionCategoryKey);
        }

        public void unitChanged(int row, Unit u) {
            this.u = u;
            this.row = row;
            this.unitChanged();
        }

        public final boolean isVisible() {
            return this.u != null ? this.isVisible(this.u) : this.isVisible(this.row);
        }

        private void unitChanged() {
            if (this.u != null) {
                this.setEnabled(this.isEnabled(this.u));
                this.setContextName(this.getContextName(this.u));
            } else {
                this.setEnabled(this.isEnabled(this.row));
                this.setContextName(this.getContextName(this.row));
            }
        }

        @Override
        public void tableDataChanged() {
            this.unitChanged();
        }

        @Override
        public void tableDataChanged(Collection<Unit> units) {
            this.unitChanged();
        }

        @Override
        public final void performerImpl() {
            this.performerImpl(this.u);
        }

        protected boolean isVisible(Unit u) {
            return u != null;
        }

        protected boolean isVisible(int row) {
            return false;
        }

        public abstract void performerImpl(Unit var1);

        protected abstract boolean isEnabled(Unit var1);

        protected boolean isEnabled(int row) {
            return false;
        }

        protected abstract String getContextName(Unit var1);

        protected String getContextName(int row) {
            return this.getActionName();
        }
    }

    class PopupActionSupport
    extends MouseAdapter
    implements Runnable {
        private final RowTabAction[] actions;
        public final Action popupOnF10 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitTab.this.popupActionsSupport.run();
            }

            @Override
            public boolean isEnabled() {
                return UnitTab.this.table.isFocusOwner();
            }
        };

        PopupActionSupport(RowTabAction[] actions) {
            this.actions = actions;
        }

        void rowChanged(int row) {
            Unit u = null;
            if (row > -1) {
                u = UnitTab.this.model.getUnitAtRow(row);
            }
            for (RowTabAction action : this.actions) {
                if (!(action instanceof RowTabAction)) continue;
                RowTabAction rowAction = action;
                rowAction.unitChanged(row, u);
            }
        }

        void tableDataChanged() {
            Collection<Unit> units = UnitTab.this.model.getMarkedUnits();
            for (RowTabAction action : this.actions) {
                action.tableDataChanged(units);
            }
        }

        private JPopupMenu createPopup() {
            JPopupMenu popup = new JPopupMenu();
            for (RowTabAction action : this.actions) {
                if (!action.isVisible()) continue;
                popup.add(new JMenuItem(action));
            }
            return popup;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.maybeShowPopup(e)) {
                int row = UnitTab.this.table.rowAtPoint(e.getPoint());
                if (UnitTab.this.model.isExpansionControlAtRow(row)) {
                    UnitTab.this.moreAction.unitChanged(row, null);
                    UnitTab.this.lessAction.unitChanged(row, null);
                    if (UnitTab.this.moreAction.isEnabled()) {
                        UnitTab.this.moreAction.performAction();
                    } else if (UnitTab.this.lessAction.isEnabled()) {
                        UnitTab.this.lessAction.performAction();
                    }
                }
            }
        }

        private boolean maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                UnitTab.this.focusTable();
                UnitTab.this.showPopup(e.getPoint(), e.getComponent());
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            Point p = this.getPositionForPopup();
            if (p != null) {
                UnitTab.this.showPopup(p, UnitTab.this.table);
            }
        }

        private Point getPositionForPopup() {
            int r = UnitTab.this.table.getSelectedRow();
            int c = UnitTab.this.table.getSelectedColumn();
            if (r < 0 || c < 0) {
                return null;
            }
            Rectangle rect = UnitTab.this.table.getCellRect(r, c, false);
            if (rect == null) {
                return null;
            }
            return SwingUtilities.convertPoint(UnitTab.this.table, rect.x, rect.y, UnitTab.this.table);
        }
    }

    private abstract class TabAction
    extends AbstractAction {
        private String name;
        private String actionCategory;

        public TabAction(String nameKey, KeyStroke accelerator, String actionCategoryKey) {
            super(UnitTab.textForKey(nameKey));
            this.actionCategory = actionCategoryKey;
            if (accelerator != null) {
                this.putValue("AcceleratorKey", accelerator);
            }
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey(nameKey));
            this.name = (String)this.getValue("Name");
            this.putIntoActionMap(UnitTab.this.table);
        }

        public TabAction(String key, String actionCategoryKey) {
            this(key, null, actionCategoryKey);
        }

        protected String getActionName() {
            return this.name;
        }

        public String getActionCategory() {
            return this.getActionCategoryImpl();
        }

        protected String getActionCategoryImpl() {
            return this.actionCategory;
        }

        protected void setContextName(String name) {
            this.putValue("Name", name);
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.isEnabled() != enabled) {
                if (enabled) {
                    RequestProcessor.Task t = PluginManagerUI.getRunningTask(new Runnable(){

                        @Override
                        public void run() {
                            TabAction.this.setEnabled(true);
                        }
                    });
                    if (t != null && !t.isFinished()) {
                        t.addTaskListener(new TaskListener(){

                            public void taskFinished(Task task) {
                                TabAction.this.setEnabled(true);
                            }
                        });
                    } else {
                        super.setEnabled(true);
                    }
                } else {
                    super.setEnabled(false);
                }
            }
        }

        private void putIntoActionMap(JComponent component) {
            KeyStroke ks = (KeyStroke)this.getValue("AcceleratorKey");
            Object key = this.getValue("Name");
            if (ks == null) {
                ks = KeyStroke.getKeyStroke((Integer)this.getValue("MnemonicKey"), 512);
            }
            if (ks != null && key != null) {
                component.getInputMap(0).put(ks, key);
                component.getActionMap().put(key, this);
            }
        }

        public final void performAction() {
            if (this.isEnabled()) {
                this.actionPerformed(null);
            }
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.performerImpl();
        }

        public void tableDataChanged() {
            this.tableDataChanged(UnitTab.this.model.getMarkedUnits());
        }

        public void tableDataChanged(Collection<Unit> units) {
            this.setEnabled(units.size() > 0);
        }

        public abstract void performerImpl();
    }

    class ButtonActionSupport {
        private final TabAction[] actions;

        ButtonActionSupport(TabAction[] actions) {
            this.actions = actions;
        }

        void tableDataChanged() {
            if (this.actions != null) {
                Collection<Unit> units = UnitTab.this.model.getMarkedUnits();
                for (TabAction ta : this.actions) {
                    ta.tableDataChanged(units);
                }
            }
        }
    }

    private class CheckCategoryAction
    extends RowTabAction {
        protected CheckCategoryAction(String nameKey, KeyStroke stroke, String actionCategoryKey) {
            super(nameKey, stroke, actionCategoryKey);
        }

        public CheckCategoryAction() {
            super("UnitTab_CheckCategoryAction", "Check");
        }

        @Override
        protected boolean isEnabled(Unit u) {
            boolean retval = false;
            String category = u.getCategoryName();
            List<Unit> units = UnitTab.this.model.getUnits();
            for (Unit unit : units) {
                if (unit == null || !category.equals(unit.getCategoryName()) || unit.isMarked() || !unit.canBeMarked()) continue;
                retval = true;
                break;
            }
            return retval;
        }

        @Override
        protected String getContextName(Unit u) {
            return this.getActionName() + " \"" + u.getCategoryName() + "\"";
        }

        @Override
        public void performerImpl(Unit u) {
            String category = u.getCategoryName();
            int count = UnitTab.this.model.getRowCount();
            int row = UnitTab.this.getSelectedRow();
            for (int i = 0; i < count; ++i) {
                u = UnitTab.this.model.getUnitAtRow(i);
                if (u == null || !category.equals(u.getCategoryName()) || u.isMarked() || !u.canBeMarked()) continue;
                u.setMarked(true);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(row);
        }

        @Override
        protected boolean isVisible(Unit u) {
            if (u.getRelevantElement().getUpdateUnit().getType() == UpdateManager.TYPE.FEATURE) {
                return false;
            }
            return super.isVisible(u);
        }
    }

    private class UncheckCategoryAction
    extends RowTabAction {
        public UncheckCategoryAction() {
            super("UnitTab_UncheckCategoryAction", "Uncheck");
        }

        @Override
        protected boolean isEnabled(Unit u) {
            boolean retval = false;
            String category = u.getCategoryName();
            List<Unit> units = UnitTab.this.model.getUnits();
            for (Unit uu : units) {
                if (uu == null || !category.equals(uu.getCategoryName()) || !uu.isMarked()) continue;
                retval = true;
                break;
            }
            return retval;
        }

        @Override
        public void performerImpl(Unit u) {
            String category = u.getCategoryName();
            int row = UnitTab.this.getSelectedRow();
            int count = UnitTab.this.model.getRowCount();
            for (int i = 0; i < count; ++i) {
                u = UnitTab.this.model.getUnitAtRow(i);
                if (u == null || !category.equals(u.getCategoryName()) || !u.isMarked() || !u.canBeMarked()) continue;
                u.setMarked(false);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(row);
            UnitTab.this.focusTable();
        }

        @Override
        protected boolean isVisible(Unit u) {
            if (u.getRelevantElement().getUpdateUnit().getType() == UpdateManager.TYPE.FEATURE) {
                return false;
            }
            return super.isVisible(u);
        }

        @Override
        protected String getContextName(Unit u) {
            return this.getActionName() + " \"" + u.getCategoryName() + "\"";
        }
    }

    private class CheckAllAction
    extends RowTabAction {
        public CheckAllAction() {
            super("UnitTab_CheckAllAction", KeyStroke.getKeyStroke(65, 128), "Check");
        }

        @Override
        public void performerImpl(Unit uu) {
            int row = UnitTab.this.getSelectedRow();
            List<Unit> allUnits = UnitTab.this.model.getUnits();
            for (Unit u : allUnits) {
                if (u == null || u.isMarked() || !u.canBeMarked()) continue;
                u.setMarked(true);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(row);
        }

        @Override
        protected boolean isEnabled(Unit uu) {
            return true;
        }

        @Override
        protected String getContextName(Unit u) {
            return this.getActionName();
        }
    }

    private class UncheckAllAction
    extends RowTabAction {
        public UncheckAllAction() {
            super("UnitTab_UncheckAllAction", "Uncheck");
        }

        @Override
        public void performerImpl(Unit uu) {
            int row = UnitTab.this.getSelectedRow();
            UnitTab.this.uncheckAll();
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(row);
        }

        @Override
        protected boolean isEnabled(Unit uu) {
            return true;
        }

        @Override
        protected String getContextName(Unit u) {
            return this.getActionName();
        }
    }

    private class ActivateCategoryAction
    extends RowTabAction {
        public ActivateCategoryAction() {
            super("UnitTab_ActivateCategoryAction", "EnableDisable");
        }

        @Override
        protected boolean isEnabled(Unit uu) {
            boolean retval = false;
            String category = uu.getCategoryName();
            List<Unit> units = UnitTab.this.model.getUnits();
            for (Unit u : units) {
                Unit.Installed installed;
                if (!(u instanceof Unit.Installed) || !category.equals(u.getCategoryName()) || (installed = (Unit.Installed)u).getRelevantElement().isEnabled()) continue;
                retval = Unit.Installed.isOperationAllowed(installed.updateUnit, installed.getRelevantElement(), Containers.forEnable());
            }
            return retval;
        }

        @Override
        protected String getContextName(Unit u) {
            if (u instanceof Unit.Installed) {
                return this.getActionName() + " \"" + u.getCategoryName() + "\"";
            }
            return this.getActionName();
        }

        @Override
        public void performerImpl(Unit uu) {
            Unit.Installed unit = (Unit.Installed)uu;
            int row = UnitTab.this.getSelectedRow();
            String category = unit.getCategoryName();
            int count = UnitTab.this.model.getRowCount();
            for (int i = 0; i < count; ++i) {
                OperationContainer.OperationInfo info;
                Unit.Installed installed;
                Unit u = UnitTab.this.model.getUnitAtRow(i);
                if (!(u instanceof Unit.Installed) || !category.equals(u.getCategoryName()) || (installed = (Unit.Installed)u).getRelevantElement().isEnabled() || installed.updateUnit.isPending() || (info = Containers.forEnable().add(installed.updateUnit, installed.getRelevantElement())) != null) continue;
                Logger.getLogger(UnitTab.class.getName()).log(Level.WARNING, "Null OperationInfo for {0}", installed.getRelevantElement());
            }
            if (Containers.forEnable().listAll().size() > 0) {
                UninstallUnitWizard wizard = new UninstallUnitWizard();
                wizard.invokeWizard(true);
                Containers.forEnable().removeAll();
            }
            UnitTab.this.fireUpdataUnitChange();
            UnitTab.this.restoreSelectedRow(row);
            UnitTab.this.focusTable();
        }

        @Override
        protected boolean isVisible(Unit u) {
            if (u.getRelevantElement().getUpdateUnit().getType() == UpdateManager.TYPE.FEATURE) {
                return false;
            }
            return this.isEnabled();
        }
    }

    private class DeactivateCategoryAction
    extends RowTabAction {
        public DeactivateCategoryAction() {
            super("UnitTab_DeactivateCategoryAction", "EnableDisable");
        }

        @Override
        protected boolean isEnabled(Unit uu) {
            boolean retval = false;
            String category = uu.getCategoryName();
            List<Unit> units = UnitTab.this.model.getUnits();
            for (Unit u : units) {
                Unit.Installed installed;
                if (!(u instanceof Unit.Installed) || !category.equals(u.getCategoryName()) || !(installed = (Unit.Installed)u).getRelevantElement().isEnabled()) continue;
                retval = Unit.Installed.isOperationAllowed(installed.updateUnit, installed.getRelevantElement(), Containers.forDisable());
            }
            return retval;
        }

        @Override
        protected String getContextName(Unit u) {
            if (u instanceof Unit.Installed) {
                return this.getActionName() + " \"" + u.getCategoryName() + "\"";
            }
            return this.getActionName();
        }

        @Override
        public void performerImpl(Unit uu) {
            Unit.Installed unit = (Unit.Installed)uu;
            int row = UnitTab.this.getSelectedRow();
            String category = unit.getCategoryName();
            int count = UnitTab.this.model.getRowCount();
            for (int i = 0; i < count; ++i) {
                Unit.Installed installed;
                Unit u = UnitTab.this.model.getUnitAtRow(i);
                if (!(u instanceof Unit.Installed) || !category.equals(u.getCategoryName()) || !(installed = (Unit.Installed)u).getRelevantElement().isEnabled() || installed.updateUnit.isPending()) continue;
                OperationContainer.OperationInfo operationInfo = Containers.forDisable().add(installed.updateUnit, installed.getRelevantElement());
            }
            if (Containers.forDisable().listAll().size() > 0) {
                UninstallUnitWizard wizard = new UninstallUnitWizard();
                wizard.invokeWizard(false);
                Containers.forDisable().removeAll();
            }
            UnitTab.this.fireUpdataUnitChange();
            UnitTab.this.restoreSelectedRow(row);
            UnitTab.this.focusTable();
        }

        @Override
        protected boolean isVisible(Unit u) {
            if (u.getRelevantElement().getUpdateUnit().getType() == UpdateManager.TYPE.FEATURE) {
                return false;
            }
            return this.isEnabled();
        }
    }

    private class ActivateAction
    extends TabAction {
        boolean finished;
        Map<String, Boolean> state;

        public ActivateAction() {
            super("UnitTab_ActivateAction", "EnableDisable");
            this.finished = false;
        }

        @Override
        public void tableDataChanged(Collection<Unit> units) {
            if (units.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            for (Unit u : units) {
                if (!this.isEnabled(u)) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        void clearContainers() {
            Containers.forEnable().removeAll();
            Containers.forDisable().removeAll();
            Containers.forAvailable().removeAll();
            Containers.forUninstall().removeAll();
        }

        OperationContainer refreshData() {
            if (!SwingUtilities.isEventDispatchThread()) {
                OperationContainer[] c = new OperationContainer[1];
                RequestProcessor.Task runningTask = PluginManagerUI.getRunningTask();
                if (runningTask != null) {
                    runningTask.waitFinished();
                }
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        c[0] = this.refreshData();
                    });
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    OperationContainer<OperationSupport> x = Containers.forEnable();
                    x.removeAll();
                }
                return c[0];
            }
            UnitTab.this.refreshState();
            try {
                this.clearContainers();
                UnitTab.this.fireUpdataUnitChange();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (!this.finished) {
                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), this.state, UnitTab.this.model.isMarkedAsDefault());
            }
            return this.prepareContainer();
        }

        OperationContainer prepareContainer() {
            OperationContainer<OperationSupport> c = Containers.forEnable();
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Unit u : UnitTab.this.model.getUnits()) {
                if (!u.isMarked() || !this.isEnabled(u)) continue;
                units.add(u);
            }
            c.removeAll();
            for (Unit u : units) {
                c.add(u.updateUnit, u.getRelevantElement());
            }
            return c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            int row = UnitTab.this.getSelectedRow();
            this.state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            UninstallUnitWizard wizard = new UninstallUnitWizard();
            this.finished = false;
            OperationContainer c = this.prepareContainer();
            try {
                this.finished = wizard.invokeWizard(true, this::refreshData);
            }
            finally {
                this.clearContainers();
                if (this.finished) {
                    for (Unit u : UnitTab.this.model.getMarkedUnits()) {
                        u.setMarked(false);
                    }
                }
                UnitTab.this.fireUpdataUnitChange();
                if (!this.finished) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), this.state, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(row);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }

        protected boolean isEnabled(Unit u) {
            Unit.Installed i;
            boolean retval = false;
            if (u instanceof Unit.Installed && !(i = (Unit.Installed)u).getRelevantElement().isEnabled()) {
                retval = Unit.Installed.isOperationAllowed(u.updateUnit, u.getRelevantElement(), Containers.forEnable());
            }
            return retval;
        }

        protected String getContextName(Unit u) {
            return this.getActionName();
        }
    }

    private class DeactivateAction
    extends TabAction {
        public DeactivateAction() {
            super("UnitTab_DeactivateAction", "EnableDisable");
        }

        @Override
        public void tableDataChanged(Collection<Unit> units) {
            if (units.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            for (Unit u : units) {
                if (!this.isEnabled(u)) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            OperationContainer<OperationSupport> c = Containers.forDisable();
            for (Unit u : UnitTab.this.model.getUnits()) {
                if (!u.isMarked() || !this.isEnabled(u)) continue;
                c.add(u.updateUnit, u.getRelevantElement());
            }
            UninstallUnitWizard wizard = new UninstallUnitWizard();
            boolean finished = false;
            try {
                finished = wizard.invokeWizard(false);
            }
            finally {
                Containers.forUninstall().removeAll();
                Containers.forDisable().removeAll();
                Containers.forEnable().removeAll();
                UnitTab.this.fireUpdataUnitChange();
                if (!finished) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(row);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }

        protected boolean isEnabled(Unit u) {
            Unit.Installed i;
            boolean retval = false;
            if (u instanceof Unit.Installed && (i = (Unit.Installed)u).getRelevantElement().isEnabled()) {
                retval = Unit.Installed.isOperationAllowed(u.updateUnit, u.getRelevantElement(), Containers.forDisable());
            }
            return retval;
        }

        protected String getContextName(Unit u) {
            return this.getActionName();
        }
    }

    private class UninstallAction
    extends TabAction {
        public UninstallAction() {
            super("UnitTab_bTabAction_Name_INSTALLED", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            boolean wizardFinished = false;
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            UninstallUnitWizard wizard = new UninstallUnitWizard();
            try {
                wizardFinished = wizard.invokeWizard();
            }
            finally {
                Containers.forUninstall().removeAll();
                Containers.forDisable().removeAll();
                Containers.forEnable().removeAll();
                UnitTab.this.fireUpdataUnitChange();
                if (!wizardFinished) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(row);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }

        @Override
        public void tableDataChanged(Collection<Unit> units) {
            if (units.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            for (Unit u : units) {
                Unit.Installed inst;
                if (!(u instanceof Unit.Installed) || !(inst = (Unit.Installed)u).isUninstallAllowed()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ActivateRowAction
    extends RowTabAction {
        public ActivateRowAction() {
            super("UnitTab_ActivateRowAction", "EnableDisable");
        }

        @Override
        protected boolean isEnabled(Unit u) {
            Unit.Installed i;
            boolean retval = false;
            if (u instanceof Unit.Installed && !(i = (Unit.Installed)u).getRelevantElement().isEnabled()) {
                retval = Unit.Installed.isOperationAllowed(u.updateUnit, u.getRelevantElement(), Containers.forEnable());
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl(Unit u) {
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            Containers.forEnable().removeAll();
            Containers.forEnable().add(u.updateUnit, u.getRelevantElement());
            UninstallUnitWizard wizard = new UninstallUnitWizard();
            boolean finished = false;
            try {
                if (Containers.forEnable().listAll().size() > 0) {
                    finished = wizard.invokeWizard(true);
                }
            }
            finally {
                Containers.forUninstall().removeAll();
                Containers.forDisable().removeAll();
                Containers.forEnable().removeAll();
                UnitTab.this.fireUpdataUnitChange();
                if (!finished) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(row);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }

        @Override
        protected String getContextName(Unit u) {
            if (u instanceof Unit.Installed) {
                return this.getActionName() + " \"" + u.getDisplayName() + "\"";
            }
            return this.getActionName();
        }
    }

    private class DeactivateRowAction
    extends RowTabAction {
        public DeactivateRowAction() {
            super("UnitTab_DeactivateRowAction", "EnableDisable");
        }

        @Override
        protected boolean isEnabled(Unit u) {
            Unit.Installed i;
            boolean retval = false;
            if (u instanceof Unit.Installed && (i = (Unit.Installed)u).getRelevantElement().isEnabled()) {
                retval = Unit.Installed.isOperationAllowed(u.updateUnit, u.getRelevantElement(), Containers.forDisable());
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl(Unit u) {
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            Containers.forDisable().removeAll();
            Containers.forDisable().add(u.updateUnit, u.getRelevantElement());
            UninstallUnitWizard wizard = new UninstallUnitWizard();
            boolean finished = false;
            try {
                if (Containers.forDisable().listAll().size() > 0) {
                    finished = wizard.invokeWizard(false);
                }
            }
            finally {
                Containers.forUninstall().removeAll();
                Containers.forDisable().removeAll();
                Containers.forEnable().removeAll();
                UnitTab.this.fireUpdataUnitChange();
                if (!finished) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(row);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }

        @Override
        protected String getContextName(Unit u) {
            if (u instanceof Unit.Installed) {
                return this.getActionName() + " \"" + u.getDisplayName() + "\"";
            }
            return this.getActionName();
        }
    }

    private class UninstallRowAction
    extends RowTabAction {
        public UninstallRowAction() {
            super("UnitTab_UninstallRowAction", "EnableDisable");
        }

        @Override
        protected boolean isEnabled(Unit u) {
            boolean retval = false;
            if (u instanceof Unit.Installed) {
                retval = ((Unit.Installed)u).isUninstallAllowed();
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl(Unit u) {
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            Containers.forUninstall().removeAll();
            Containers.forUninstall().add(u.updateUnit, u.getRelevantElement());
            UninstallUnitWizard wizard = new UninstallUnitWizard();
            boolean finished = false;
            try {
                if (Containers.forUninstall().listAll().size() > 0) {
                    finished = wizard.invokeWizard();
                }
            }
            finally {
                Containers.forUninstall().removeAll();
                Containers.forDisable().removeAll();
                Containers.forEnable().removeAll();
                UnitTab.this.fireUpdataUnitChange();
                if (!finished) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(row);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }

        @Override
        protected String getContextName(Unit u) {
            if (u instanceof Unit.Installed) {
                return this.getActionName() + " \"" + u.getDisplayName() + "\"";
            }
            return this.getActionName();
        }
    }

    private class CheckAction
    extends RowTabAction {
        public CheckAction() {
            super("UnitTab_CheckAction", KeyStroke.getKeyStroke(32, 0), null);
        }

        @Override
        public void performerImpl(Unit u) {
            int row = UnitTab.this.getSelectedRow();
            if (UnitTab.this.model.isExpansionControlAtRow(row)) {
                if (UnitTab.this.moreAction != null && UnitTab.this.moreAction.isEnabled()) {
                    UnitTab.this.moreAction.performAction();
                } else if (UnitTab.this.lessAction != null && UnitTab.this.lessAction.isEnabled()) {
                    UnitTab.this.lessAction.performAction();
                }
            } else if (u != null && u.canBeMarked()) {
                u.setMarked(!u.isMarked());
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(row);
        }

        @Override
        protected boolean isEnabled(Unit u) {
            return u != null && u.canBeMarked();
        }

        @Override
        protected boolean isEnabled(int row) {
            return UnitTab.this.model.isExpansionControlAtRow(row);
        }

        @Override
        protected String getContextName(Unit u) {
            return this.getActionName();
        }

        @Override
        protected boolean isVisible(Unit u) {
            return false;
        }

        @Override
        protected boolean isVisible(int row) {
            return false;
        }
    }

    private class EnableRenderer
    extends DefaultTableCellRenderer {
        private EnableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel renderComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Boolean) {
                Unit u = UnitTab.this.model.getUnitAtRow(table.convertRowIndexToModel(row));
                if (u != null && u.getRelevantElement().getUpdateUnit().isPending()) {
                    renderComponent.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/restart.png", (boolean)false));
                } else {
                    Boolean state = (Boolean)value;
                    if (state.booleanValue()) {
                        renderComponent.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/active.png", (boolean)false));
                    } else {
                        renderComponent.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/inactive.png", (boolean)false));
                    }
                }
                renderComponent.setText("");
                renderComponent.setHorizontalAlignment(0);
            }
            JLabel retval = renderComponent;
            return retval;
        }
    }

    private class MoreAction
    extends RowTabAction {
        public MoreAction() {
            super("UnitTab_MoreAction", "Expand");
        }

        @Override
        public void performerImpl(Unit uu) {
            try {
                UnitTab.this.setWaitingState(true);
                Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                UnitTab.this.model.setExpanded(true);
                UnitTab.this.fireUpdataUnitChange();
                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                UnitTab.this.focusTable();
            }
            finally {
                UnitTab.this.setWaitingState(false);
            }
        }

        @Override
        protected boolean isVisible(Unit u) {
            return this.isEnabled(u);
        }

        @Override
        protected boolean isVisible(int row) {
            return !UnitTab.this.model.isExpansionControlAtRow(row) && this.isEnabled(row);
        }

        @Override
        protected boolean isEnabled(Unit uu) {
            return uu != null && UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isCollapsed();
        }

        @Override
        protected boolean isEnabled(int row) {
            return UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isCollapsed();
        }

        @Override
        protected String getContextName(Unit u) {
            return this.getActionName();
        }
    }

    private class LessAction
    extends RowTabAction {
        public LessAction() {
            super("UnitTab_LessAction", "Expand");
        }

        @Override
        public void performerImpl(Unit uu) {
            try {
                UnitTab.this.setWaitingState(true);
                Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                UnitTab.this.model.setExpanded(false);
                UnitTab.this.fireUpdataUnitChange();
                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                UnitTab.this.focusTable();
            }
            finally {
                UnitTab.this.setWaitingState(false);
            }
        }

        @Override
        protected boolean isVisible(Unit u) {
            return this.isEnabled(u);
        }

        @Override
        protected boolean isVisible(int row) {
            return !UnitTab.this.model.isExpansionControlAtRow(row) && this.isEnabled(row);
        }

        @Override
        protected boolean isEnabled(Unit uu) {
            return uu != null && UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isExpanded();
        }

        @Override
        protected boolean isEnabled(int row) {
            return UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isExpanded();
        }

        @Override
        protected String getContextName(Unit u) {
            return this.getActionName();
        }
    }

    private class UpdateRowAction
    extends RowTabAction {
        public UpdateRowAction() {
            super("UnitTab_UpdateRowAction", null);
        }

        @Override
        protected boolean isEnabled(Unit u) {
            boolean retval = false;
            if (u instanceof Unit.Update) {
                retval = u.canBeMarked();
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl(Unit u) {
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            Containers.forUpdate().removeAll();
            if (u instanceof Unit.CompoundUpdate) {
                Unit.CompoundUpdate uc = (Unit.CompoundUpdate)u;
                OperationContainer<InstallSupport> container = Containers.forUpdate();
                for (UpdateUnit invisible : uc.getUpdateUnits()) {
                    if (!container.canBeAdded(invisible, (UpdateElement)invisible.getAvailableUpdates().get(0))) continue;
                    container.add(invisible, (UpdateElement)invisible.getAvailableUpdates().get(0));
                }
            } else {
                Containers.forUpdate().add(u.updateUnit, u.getRelevantElement());
            }
            boolean finished = false;
            try {
                if (Containers.forUpdate().listAll().size() > 0) {
                    finished = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.UPDATE, UnitTab.this.manager);
                }
            }
            finally {
                Containers.forUpdate().removeAll();
                if (UnitTab.this.manager == null || !UnitTab.this.manager.isClosing()) {
                    Containers.forUpdate().removeAll();
                    UnitTab.this.fireUpdataUnitChange();
                    if (!finished) {
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                    }
                    UnitTab.this.restoreSelectedRow(row);
                    UnitTab.this.refreshState();
                    UnitTab.this.focusTable();
                }
            }
        }

        @Override
        protected String getContextName(Unit u) {
            if (u != null) {
                return this.getActionName() + " \"" + u.getDisplayName() + "\"";
            }
            return this.getActionName();
        }
    }

    private class UpdateAction
    extends TabAction {
        public UpdateAction() {
            super("UnitTab_bTabAction_Name_UPDATE", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            boolean wizardFinished = false;
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            try {
                wizardFinished = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.UPDATE, UnitTab.this.manager);
            }
            finally {
                if (UnitTab.this.manager == null || !UnitTab.this.manager.isClosing()) {
                    UnitTab.this.fireUpdataUnitChange();
                    if (!wizardFinished) {
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                    }
                    UnitTab.this.restoreSelectedRow(row);
                    UnitTab.this.refreshState();
                    UnitTab.this.focusTable();
                }
            }
        }
    }

    private class ReloadAction
    extends TabAction {
        RequestProcessor.Task reloadTask;

        public ReloadAction(String nameKey) {
            super(nameKey, KeyStroke.getKeyStroke(82, 128), null);
            this.reloadTask = null;
            String tooltip = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Tooltip_RefreshAction");
            this.putValue("ToolTipText", tooltip);
            this.setEnabled(false);
        }

        @Override
        public void performerImpl() {
            this.setEnabled(false);
            this.reloadTask = UnitTab.this.reloadTask(true);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            super.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
        }
    }

    private class AvailableRowAction
    extends RowTabAction {
        public AvailableRowAction() {
            super("UnitTab_InstallRowAction", null);
        }

        @Override
        protected boolean isEnabled(Unit u) {
            boolean retval = false;
            if (u instanceof Unit.Available) {
                retval = u.canBeMarked();
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl(Unit u) {
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            Containers.forAvailable().removeAll();
            if (u instanceof Unit.Available) {
                Containers.forAvailable().add(u.updateUnit, u.getRelevantElement());
            }
            boolean finished = false;
            try {
                if (Containers.forAvailable().listAll().size() > 0) {
                    finished = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.INSTALL, UnitTab.this.manager);
                }
            }
            finally {
                Containers.forAvailable().removeAll();
                if (UnitTab.this.manager == null || !UnitTab.this.manager.isClosing()) {
                    UnitTab.this.fireUpdataUnitChange();
                    if (!finished) {
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                    }
                    UnitTab.this.restoreSelectedRow(row);
                    UnitTab.this.refreshState();
                    UnitTab.this.focusTable();
                }
            }
        }

        @Override
        protected String getContextName(Unit u) {
            if (u != null) {
                return this.getActionName() + " \"" + u.getDisplayName() + "\"";
            }
            return this.getActionName();
        }
    }

    private class AvailableAction
    extends TabAction {
        public AvailableAction() {
            super("UnitTab_bTabAction_Name_AVAILABLE", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            boolean wizardFinished = false;
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            try {
                wizardFinished = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.INSTALL, UnitTab.this.manager);
            }
            finally {
                if (UnitTab.this.manager != null) {
                    UnitTab.this.fireUpdataUnitChange();
                }
                if (!wizardFinished) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(row);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }
    }

    class SourceCategoryRenderer
    extends DefaultTableCellRenderer {
        SourceCategoryRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Unit u;
            JLabel renderComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Image && (u = UnitTab.this.model.getUnitAtRow(table.convertRowIndexToModel(row))) instanceof Unit.Available) {
                Unit.Available a = (Unit.Available)u;
                renderComponent.setIcon(ImageUtilities.image2Icon((Image)a.getSourceIcon()));
                renderComponent.setText("");
                renderComponent.setHorizontalAlignment(0);
            }
            JLabel retval = renderComponent;
            return retval;
        }
    }

    private class RemoveLocallyDownloadedAction
    extends RowTabAction {
        public RemoveLocallyDownloadedAction() {
            super("UnitTab_RemoveLocallyDownloadedAction", null);
            String tooltip = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Tooltip_RemoveAction_LOCAL");
            this.putValue("ToolTipText", tooltip);
        }

        @Override
        protected boolean isEnabled(Unit uu) {
            return uu != null && UnitTab.this.model.getType().equals((Object)UnitCategoryTableModel.Type.LOCAL);
        }

        @Override
        public boolean isEnabled() {
            if (super.isEnabled()) {
                return UnitTab.this.table.getSelectedRow() > -1;
            }
            return false;
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            super.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
        }

        @Override
        public void performerImpl(final Unit unit) {
            Runnable removeUpdates = new Runnable(){
                final /* synthetic */ RemoveLocallyDownloadedAction this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    Map<String, Boolean> state = UnitCategoryTableModel.captureState(this.this$1.UnitTab.this.model.getUnits());
                    try {
                        if (unit.isMarked()) {
                            unit.setMarked(false);
                        }
                        this.this$1.UnitTab.this.getLocalDownloadSupport().remove(unit.updateUnit);
                        this.this$1.UnitTab.this.getLocalDownloadSupport().getUpdateUnits();
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ Map val$state;
                            final /* synthetic */ 1 this$2;
                            {
                                this.val$state = map;
                                this.this$2 = this$2;
                            }

                            @Override
                            public void run() {
                                this.this$2.this$1.UnitTab.this.fireUpdataUnitChange();
                                UnitCategoryTableModel.restoreState(this.this$2.this$1.UnitTab.this.model.getUnits(), this.val$state, this.this$2.this$1.UnitTab.this.model.isMarkedAsDefault());
                                this.this$2.this$1.UnitTab.this.refreshState();
                                this.this$2.this$1.UnitTab.this.setWaitingState(false);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            };
            UnitTab.this.setWaitingState(true);
            Utilities.startAsWorkerThread(removeUpdates, 250);
        }

        @Override
        protected String getContextName(Unit u) {
            return this.getActionName();
        }

        @Override
        protected boolean isVisible(Unit u) {
            return false;
        }
    }

    private class LocalUpdateRowAction
    extends RowTabAction {
        public LocalUpdateRowAction() {
            super("UnitTab_LocalUpdateRowAction", null);
        }

        @Override
        protected boolean isEnabled(Unit u) {
            boolean retval = false;
            if (u != null) {
                retval = u.canBeMarked();
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl(Unit u) {
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            Containers.forAvailableNbms().removeAll();
            Containers.forUpdateNbms().removeAll();
            if (u instanceof Unit.Available) {
                Containers.forAvailableNbms().add(u.updateUnit, u.getRelevantElement());
            } else if (u instanceof Unit.Update) {
                Containers.forUpdateNbms().add(u.updateUnit, u.getRelevantElement());
            }
            boolean finished = false;
            try {
                if (Containers.forAvailableNbms().listAll().size() > 0 || Containers.forUpdateNbms().listAll().size() > 0) {
                    finished = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.LOCAL_DOWNLOAD, UnitTab.this.manager);
                }
            }
            finally {
                Containers.forAvailableNbms().removeAll();
                Containers.forUpdateNbms().removeAll();
                if (UnitTab.this.manager == null || !UnitTab.this.manager.isClosing()) {
                    UnitTab.this.fireUpdataUnitChange();
                    if (!finished) {
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                    }
                    UnitTab.this.restoreSelectedRow(row);
                    UnitTab.this.refreshState();
                    UnitTab.this.focusTable();
                }
            }
        }

        @Override
        protected String getContextName(Unit u) {
            if (u != null) {
                return this.getActionName() + " \"" + u.getDisplayName() + "\"";
            }
            return this.getActionName();
        }
    }

    private class LocalUpdateAction
    extends TabAction {
        public LocalUpdateAction() {
            super("UnitTab_bTabAction_Name_LOCAL", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            boolean wizardFinished = false;
            int row = UnitTab.this.getSelectedRow();
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            try {
                wizardFinished = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.LOCAL_DOWNLOAD, UnitTab.this.manager);
            }
            finally {
                if (wizardFinished) {
                    UnitTab.this.reloadTask(false).schedule(10);
                } else {
                    UnitTab.this.fireUpdataUnitChange();
                    if (!wizardFinished) {
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), state, UnitTab.this.model.isMarkedAsDefault());
                    }
                    UnitTab.this.restoreSelectedRow(row);
                    UnitTab.this.refreshState();
                }
                UnitTab.this.focusTable();
            }
        }
    }

    private class AddLocallyDownloadedAction
    extends TabAction {
        public AddLocallyDownloadedAction() {
            super("UnitTab_bAddLocallyDownloads_Name", null);
            UnitTab.this.topButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_bAddLocallyDownloads_ACN"));
            UnitTab.this.topButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_bAddLocallyDownloads_ACD"));
            String tooltip = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Tooltip_AddAction_LOCAL");
            this.putValue("ToolTipText", tooltip);
        }

        @Override
        public void performerImpl() {
            Map<String, Boolean> state = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            if (UnitTab.this.getLocalDownloadSupport().chooseNbmFiles()) {
                UnitTab.this.updateTab(state);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            super.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
        }
    }
}

