/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PullUpPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_PullUp_Selected", "LBL_PullUp_Member", "LBL_PullUp_MakeAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, TreePathHandle.class, Boolean.class};
    private final PullUpRefactoring refactoring;
    private final TableModel tableModel;
    private final Set<MemberInfo<ElementHandle>> selectedMembers;
    private MemberInfo<ElementHandle<TypeElement>> targetType;
    private final ChangeListener parent;
    private boolean initialized = false;
    private JLabel chooseLabel;
    private JTable membersTable;
    private JScrollPane scrollPane;
    private JComboBox supertypeCombo;
    private JLabel supertypeLabel;
    private JPanel supertypePanel;

    public PullUpPanel(PullUpRefactoring refactoring, Set<MemberInfo<ElementHandle>> selectedMembers, ElementKind sourceKind, final ChangeListener parent) {
        this.parent = parent;
        this.refactoring = refactoring;
        this.tableModel = new TableModel(sourceKind);
        this.selectedMembers = selectedMembers;
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new UIUtilities.JavaElementTableCellRenderer(){

            @Override
            protected String extractText(Object value) {
                Object displayValue = super.extractText(value);
                if (value instanceof MemberInfo && ((MemberInfo)value).getGroup() == MemberInfo.Group.IMPLEMENTS) {
                    displayValue = "implements " + (String)displayValue;
                }
                return displayValue;
            }
        });
        this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer(this.membersTable){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                MemberInfo object = (MemberInfo)table.getModel().getValueAt(row, 1);
                if (((ElementHandle)object.getElementHandle()).getKind() == ElementKind.METHOD && PullUpPanel.this.targetType.getElementHandle().getKind().isInterface() && !object.getModifiers().contains((Object)Modifier.STATIC) && !object.getModifiers().contains((Object)Modifier.ABSTRACT) && !object.getModifiers().contains((Object)Modifier.DEFAULT)) {
                    value = Boolean.TRUE;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.scrollPane.setBackground(this.membersTable.getBackground());
        this.scrollPane.getViewport().setBackground(this.membersTable.getBackground());
        this.membersTable.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.membersTable.setGridColor(UIManager.getColor("control"));
        }
        UIUtilities.initColumnWidth(this.membersTable, 0, Boolean.TRUE, 4);
        UIUtilities.initColumnWidth(this.membersTable, 2, Boolean.TRUE, 4);
        this.supertypeCombo.setRenderer(new UIUtilities.JavaElementListCellRenderer());
        this.membersTable.getModel().addTableModelListener(new TableModelListener(){
            final /* synthetic */ PullUpPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                parent.stateChanged(null);
            }
        });
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        final TreePathHandle handle = this.refactoring.getSourceType();
        JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){
                final /* synthetic */ PullUpPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    Collection<TypeElement> supertypes = JavaRefactoringUtils.getSuperTypes((TypeElement)handle.resolveElement((CompilationInfo)controller), (CompilationInfo)controller, true);
                    final LinkedList<MemberInfo<ElementHandle<TypeElement>>> minfo = new LinkedList<MemberInfo<ElementHandle<TypeElement>>>();
                    for (TypeElement e : supertypes) {
                        MemberInfo<ElementHandle<TypeElement>> memberInfo = MemberInfo.create(e, (CompilationInfo)controller);
                        if (memberInfo.getElementHandle().resolve((CompilationInfo)controller) == null) continue;
                        minfo.add(memberInfo);
                    }
                    TypeElement sourceTypeElement = (TypeElement)handle.resolveElement((CompilationInfo)controller);
                    final String name = ElementHeaders.getHeader((Element)sourceTypeElement, (CompilationInfo)controller, (String)"%name%");
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.this$0.supertypeCombo.setModel(this.this$1.this$0.new ComboModel(minfo.toArray(new MemberInfo[0])));
                            this.this$1.this$0.setName(NbBundle.getMessage(PullUpPanel.class, (String)"LBL_PullUpHeader", (Object[])new Object[]{name}));
                        }
                    });
                }
            }, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.initialized = true;
    }

    public MemberInfo<ElementHandle<TypeElement>> getTargetType() {
        return this.targetType;
    }

    public MemberInfo[] getMembers() {
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>();
        boolean targetIsInterface = this.targetType.getElementHandle().getKind().isInterface();
        for (int i = 0; i < this.tableModel.members.length; ++i) {
            MemberInfo element;
            if (!this.tableModel.members[i][0].equals(Boolean.TRUE)) continue;
            element.setMakeAbstract(((ElementHandle)(element = (MemberInfo)this.tableModel.members[i][1]).getElementHandle()).getKind() == ElementKind.METHOD && targetIsInterface && !((MemberInfo)this.tableModel.members[i][1]).getModifiers().contains((Object)Modifier.DEFAULT) || ((Boolean)this.tableModel.members[i][2] == null ? Boolean.FALSE : (Boolean)this.tableModel.members[i][2]) != false);
            list.add(element);
        }
        return list.toArray(new MemberInfo[0]);
    }

    private void initComponents() {
        this.supertypePanel = new JPanel();
        this.supertypeCombo = new JComboBox();
        this.supertypeLabel = new JLabel();
        this.chooseLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new BorderLayout());
        this.supertypePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.supertypePanel.setLayout(new BorderLayout(12, 0));
        this.supertypePanel.add((Component)this.supertypeCombo, "Center");
        this.supertypeLabel.setLabelFor(this.supertypeCombo);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.supertypeLabel, (String)bundle.getString("LBL_PullUp_Supertype"));
        this.supertypePanel.add((Component)this.supertypeLabel, "West");
        this.supertypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullUpPanel.class, (String)"ACSD_DestinationSupertypeName"));
        this.supertypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullUpPanel.class, (String)"ACSD_DestinationSupertypeDescription"));
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage(PullUpPanel.class, (String)"LBL_PullUpLabel"));
        this.chooseLabel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.supertypePanel.add((Component)this.chooseLabel, "South");
        this.add((Component)this.supertypePanel, "North");
        this.membersTable.setModel(this.tableModel);
        this.membersTable.setAutoResizeMode(1);
        this.scrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullUpPanel.class, (String)"ACSD_MembersToPullUp"));
        this.membersTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullUpPanel.class, (String)"ACSD_MembersToPullUpDescription"));
        this.add((Component)this.scrollPane, "Center");
    }

    public Component getComponent() {
        return this;
    }

    private class TableModel
    extends AbstractTableModel {
        private Object[][] members = new Object[0][0];
        private final ElementKind sourceKind;

        public TableModel(ElementKind sourceKind) {
            this.sourceKind = sourceKind;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return UIUtilities.getColumnName(NbBundle.getMessage(PullUpPanel.class, (String)COLUMN_NAMES[column]));
        }

        public Class getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.members.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.members[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.members[rowIndex][columnIndex] = value;
            PullUpPanel.this.parent.stateChanged(null);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                if (this.members[rowIndex][2] == null) {
                    return false;
                }
                Object element = this.members[rowIndex][1];
                MemberInfo member = (MemberInfo)element;
                return member.getModifiers().contains((Object)Modifier.DEFAULT) || !this.sourceKind.isInterface() && !member.getModifiers().contains((Object)Modifier.STATIC) && !member.getModifiers().contains((Object)Modifier.ABSTRACT);
            }
            return columnIndex == 0;
        }

        void update(final MemberInfo<ElementHandle<TypeElement>> selectedTarget) {
            final HashMap map = new HashMap();
            JavaSource source = JavaSource.forFileObject((FileObject)PullUpPanel.this.refactoring.getSourceType().getFileObject());
            try {
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){
                    final /* synthetic */ TableModel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void cancel() {
                    }

                    public void run(CompilationController info) {
                        try {
                            info.toPhase(JavaSource.Phase.RESOLVED);
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                        TypeElement targetElement = (TypeElement)((ElementHandle)selectedTarget.getElementHandle()).resolve((CompilationInfo)info);
                        TypeElement sourceElement = (TypeElement)this.this$1.PullUpPanel.this.refactoring.getSourceType().resolveElement((CompilationInfo)info);
                        TypeMirror sourceTM = sourceElement.asType();
                        TypeMirror targetTM = targetElement.asType();
                        ArrayList<TypeElement> classes = new ArrayList<TypeElement>();
                        classes.add(sourceElement);
                        classes.addAll(JavaRefactoringUtils.getSuperTypes(sourceElement, (CompilationInfo)info, true));
                        for (TypeElement superType : classes) {
                            if (!info.getTypes().isSubtype(sourceTM, targetTM) || info.getTypes().isSameType(superType.asType(), targetTM)) continue;
                            for (TypeMirror typeMirror : superType.getInterfaces()) {
                                MemberInfo<ElementHandle<TypeElement>> memberInfo = MemberInfo.create(RefactoringUtils.typeToElement(typeMirror, (CompilationInfo)info), (CompilationInfo)info, MemberInfo.Group.IMPLEMENTS);
                                map.put(memberInfo, new Object[]{Boolean.FALSE, memberInfo, null});
                            }
                            List<? extends Element> features = superType.getEnclosedElements();
                            block7: for (Element element : features) {
                                switch (element.getKind()) {
                                    case CONSTRUCTOR: 
                                    case STATIC_INIT: 
                                    case INSTANCE_INIT: {
                                        continue block7;
                                    }
                                }
                                MemberInfo<ElementHandle<Element>> mi = MemberInfo.create(element, (CompilationInfo)info);
                                map.put(mi, new Object[]{Boolean.FALSE, mi, element.getKind() == ElementKind.METHOD ? Boolean.FALSE : null});
                            }
                        }
                        if (this.this$1.members.length == 0) {
                            Iterator<MemberInfo<ElementHandle>> it = this.this$1.PullUpPanel.this.selectedMembers.iterator();
                            while (it.hasNext()) {
                                value = (Object[])map.get(it.next());
                                if (value == null) continue;
                                value[0] = Boolean.TRUE;
                            }
                        } else {
                            for (int i = 0; i < this.this$1.members.length; ++i) {
                                value = (Object[])map.get(this.this$1.members[i][1]);
                                if (value == null) continue;
                                map.put(value[1], this.this$1.members[i]);
                            }
                        }
                        TreeMap treeMap = new TreeMap(new Comparator(){

                            public int compare(Object o1, Object o2) {
                                return ((MemberInfo)o1).getHtmlText().compareTo(((MemberInfo)o2).getHtmlText());
                            }
                        });
                        treeMap.putAll(map);
                        this.this$1.members = new Object[treeMap.size()][];
                        int i = 0;
                        Iterator it = treeMap.values().iterator();
                        while (it.hasNext()) {
                            this.this$1.members[i] = (Object[])it.next();
                            ++i;
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.fireTableDataChanged();
        }
    }

    private class ComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final MemberInfo<ElementHandle>[] supertypes;

        ComboModel(MemberInfo[] supertypes) {
            this.supertypes = supertypes;
            if (supertypes.length > 0) {
                this.setSelectedItem(supertypes[0]);
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (PullUpPanel.this.targetType != anItem) {
                PullUpPanel.this.targetType = (MemberInfo)anItem;
                this.fireContentsChanged(this, -1, -1);
                PullUpPanel.this.tableModel.update(PullUpPanel.this.targetType);
            }
        }

        @Override
        public Object getSelectedItem() {
            return PullUpPanel.this.targetType;
        }

        @Override
        public Object getElementAt(int index) {
            return this.supertypes[index];
        }

        @Override
        public int getSize() {
            return this.supertypes.length;
        }
    }
}

