/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.j2ee.ddloaders.app.EarDataObject;
import org.openide.actions.OpenAction;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class EarDataNode
extends DataNode {
    private static final String DEPLOYMENT = "deployment";
    private EarDataObject dataObject;
    public static final String PROPERTY_DOCUMENT_TYPE = "documentType";
    private PropertyChangeListener ddListener;
    private Action[] filteredActions;

    public EarDataNode(EarDataObject obj) {
        this(obj, Children.LEAF);
    }

    public EarDataNode(EarDataObject obj, Children ch) {
        super((DataObject)obj, ch);
        this.dataObject = obj;
        this.setIconBaseWithExtension(this.dataObject.getIconBaseForValidDocument());
        this.initListeners();
    }

    public Action[] getActions(boolean context) {
        if (this.filteredActions == null) {
            Action[] origActions = super.getActions(context);
            ArrayList<Action> actions = new ArrayList<Action>();
            SystemAction openAction = SystemAction.get(OpenAction.class);
            for (int i = 0; i < origActions.length; ++i) {
                if (origActions[i] instanceof OpenAction || openAction != null && origActions[i] != null && openAction.getValue("Name").equals(origActions[i].getValue("Name"))) continue;
                actions.add(origActions[i]);
            }
            this.filteredActions = actions.toArray(new Action[0]);
        }
        return this.filteredActions;
    }

    private void initListeners() {
        this.ddListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("documentDTD".equals(evt.getPropertyName())) {
                    EarDataNode.this.firePropertyChange(EarDataNode.PROPERTY_DOCUMENT_TYPE, evt.getOldValue(), evt.getNewValue());
                }
                if ("valid".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                    EarDataNode.this.removePropertyChangeListener(EarDataNode.this.ddListener);
                }
                if ("documentValid".equals(evt.getPropertyName())) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        EarDataNode.this.setIconBaseWithExtension(EarDataNode.this.dataObject.getIconBaseForValidDocument());
                    } else {
                        EarDataNode.this.setIconBaseWithExtension(EarDataNode.this.dataObject.getIconBaseForInvalidDocument());
                    }
                }
                if ("propertySets".equals(evt.getPropertyName())) {
                    EarDataNode.this.firePropertySetsChange(null, null);
                }
            }
        };
        this.getDataObject().addPropertyChangeListener(this.ddListener);
    }

    protected Sheet createSheet() {
        Sheet s = new Sheet();
        Sheet.Set ss = new Sheet.Set();
        ss.setName(DEPLOYMENT);
        ss.setDisplayName(NbBundle.getMessage(EarDataNode.class, (String)"PROP_deploymentSet"));
        ss.setShortDescription(NbBundle.getMessage(EarDataNode.class, (String)"HINT_deploymentSet"));
        ss.setValue("helpID", (Object)"TBD---Ludo ejbjar node");
        PropertySupport.ReadOnly p = new PropertySupport.ReadOnly(PROPERTY_DOCUMENT_TYPE, String.class, NbBundle.getBundle(EarDataNode.class).getString("PROP_documentDTD"), NbBundle.getBundle(EarDataNode.class).getString("HINT_documentDTD")){

            public Object getValue() {
                return EarDataNode.this.dataObject.getApplication().getVersion();
            }
        };
        ss.put((Node.Property)p);
        s.put(ss);
        return s;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("TBD ejbjar file");
    }
}

