/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileRenderKit
extends RenderKit {
    public static final String RENDER_KIT_ID = "PRIMEFACES_MOBILE";
    private RenderKit defaultRenderKit = null;
    private ConcurrentHashMap<String, HashMap<String, Renderer>> rendererFamilies = new ConcurrentHashMap();

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        HashMap<String, Object> renderers = this.rendererFamilies.get(family);
        if (renderers == null) {
            renderers = new HashMap();
            this.rendererFamilies.put(family, renderers);
        }
        renderers.put(rendererType, renderer);
    }

    public Renderer getRenderer(String family, String rendererType) {
        Renderer renderer = null;
        HashMap<String, Renderer> renderers = this.rendererFamilies.get(family);
        if (renderers != null) {
            renderer = renderers.get(rendererType);
        }
        if (renderer == null) {
            renderer = this.getDefaultRenderKit().getRenderer(family, rendererType);
        }
        return renderer;
    }

    public Iterator<String> getRendererTypes(String componentFamily) {
        Map family = this.rendererFamilies.get(componentFamily);
        if (family != null) {
            return family.keySet().iterator();
        }
        Set empty = Collections.emptySet();
        return empty.iterator();
    }

    public void addClientBehaviorRenderer(String type, ClientBehaviorRenderer renderer) {
        this.getDefaultRenderKit().addClientBehaviorRenderer(type, renderer);
    }

    public ClientBehaviorRenderer getClientBehaviorRenderer(String type) {
        return this.getDefaultRenderKit().getClientBehaviorRenderer(type);
    }

    public Iterator<String> getClientBehaviorRendererTypes() {
        return this.getDefaultRenderKit().getClientBehaviorRendererTypes();
    }

    public Iterator<String> getComponentFamilies() {
        return this.rendererFamilies.keySet().iterator();
    }

    public ResponseStateManager getResponseStateManager() {
        return this.getDefaultRenderKit().getResponseStateManager();
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String encoding) {
        return this.getDefaultRenderKit().createResponseWriter(writer, contentTypeList, encoding);
    }

    public ResponseStream createResponseStream(OutputStream out) {
        return this.getDefaultRenderKit().createResponseStream(out);
    }

    private RenderKit getDefaultRenderKit() {
        if (this.defaultRenderKit == null) {
            RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.defaultRenderKit = renderKitFactory.getRenderKit(facesContext, "HTML_BASIC");
        }
        return this.defaultRenderKit;
    }
}

