/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.line;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.line.LineChart;
import org.primefaces.model.chart.CartesianChartModel;
import org.primefaces.model.chart.ChartSeries;
import org.primefaces.model.chart.LineChartSeries;

public class LineChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        LineChart chart = (LineChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        LineChart chart = (LineChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('LineChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeData(context, chart);
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeData(FacesContext context, LineChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        CartesianChartModel model = (CartesianChartModel)chart.getValue();
        List<String> categories = chart.getCategories();
        boolean hasCategories = !categories.isEmpty();
        writer.write(",data:[");
        Iterator<Object> it = model.getSeries().iterator();
        while (it.hasNext()) {
            ChartSeries series = it.next();
            writer.write("[");
            Iterator<Object> x = series.getData().keySet().iterator();
            while (x.hasNext()) {
                String yValueAsString;
                Object xValue = x.next();
                Number yValue = series.getData().get(xValue);
                String string = yValueAsString = yValue != null ? yValue.toString() : "null";
                if (hasCategories) {
                    writer.write(yValueAsString);
                } else {
                    writer.write("[");
                    writer.write(xValue + "," + yValueAsString);
                    writer.write("]");
                }
                if (!x.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        if (hasCategories) {
            writer.write(",categories:[");
            it = categories.iterator();
            while (it.hasNext()) {
                writer.write("'" + (String)it.next() + "'");
                if (!it.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
    }

    protected void encodeOptions(FacesContext context, LineChart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        CartesianChartModel model = (CartesianChartModel)chart.getValue();
        writer.write(",axes:{");
        this.encodeAxis(context, "xaxis", chart.getXaxisLabel(), chart.getXaxisAngle(), chart.getMinX(), chart.getMaxX());
        this.encodeAxis(context, ",yaxis", chart.getYaxisLabel(), chart.getYaxisAngle(), chart.getMinY(), chart.getMaxY());
        writer.write("}");
        writer.write(",series:[");
        Iterator<ChartSeries> it = model.getSeries().iterator();
        while (it.hasNext()) {
            ChartSeries series = it.next();
            String seriesRenderer = series.getRenderer();
            boolean fill = series.isFill();
            writer.write("{");
            writer.write("label:'" + series.getLabel() + "'");
            if (series instanceof LineChartSeries) {
                LineChartSeries lineChartSeries = (LineChartSeries)series;
                writer.write(",showLine:" + lineChartSeries.isShowLine());
                writer.write(",markerOptions:{show:" + chart.isShowMarkers() + ", style:'" + lineChartSeries.getMarkerStyle() + "'}");
            }
            if (seriesRenderer != null) {
                writer.write(",renderer: $.jqplot." + seriesRenderer);
            }
            if (fill) {
                writer.write(",fill:true");
            }
            writer.write("}");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        if (chart.isFill()) {
            writer.write(",fill:true");
        }
        if (chart.isStacked()) {
            writer.write(",stackSeries:true");
        }
        if (chart.isBreakOnNull()) {
            writer.write(",breakOnNull:true");
        }
        if (chart.isZoom()) {
            writer.write(",zoom:true");
        }
        if (chart.isAnimate()) {
            writer.write(",animate:true");
        }
        if (chart.isShowDatatip()) {
            writer.write(",datatip:true");
            if (chart.getDatatipFormat() != null) {
                writer.write(",datatipFormat:'" + chart.getDatatipFormat() + "'");
            }
        }
    }
}

