/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.platform;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.modules.java.j2seembedded.platform.ConnectionMethod;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatformProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class RemotePlatform
extends JavaPlatform {
    public static final String SPEC_NAME = "j2se-remote";
    public static final String PROP_PROPERTIES = "properties";
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    private static final String PLAT_PROP_INSTALL_FOLDER = "platform.install.folder";
    private static final String PLAT_PROP_WORK_FOLDER = "platform.work.folder";
    private static final String PROP_VM_PROFILE = "platform.java.profile";
    private static final String PROP_VM_EXTENSIONS = "platform.java.extensions";
    private static final String PROP_VM_TYPE = "platform.jvm.type";
    private static final String PROP_VM_TARGET = "platform.jvm.target";
    private static final String PROP_VM_DEBUG = "platform.jvm.debug";
    private static final String PROP_EXEC_DECORATOR = "platform.exec.decorator";
    private static final Logger LOG = Logger.getLogger(RemotePlatform.class.getName());
    private final String displayName;
    private final Map<String, String> props;
    private final Specification spec;
    private volatile ConnectionMethod connectionMethod;

    private RemotePlatform(@NonNull String displayName, @NonNull Map<String, String> properties, @NonNull Map<String, String> sysProperties) {
        Parameters.notNull((CharSequence)"displayName", (Object)displayName);
        Parameters.notNull((CharSequence)PROP_PROPERTIES, properties);
        Parameters.notNull((CharSequence)"sysProperties", sysProperties);
        this.displayName = displayName;
        this.props = new HashMap<String, String>(properties);
        this.spec = new Specification(SPEC_NAME, RemotePlatform.createSpecificationVersion(sysProperties.get("java.specification.version")), NbBundle.getMessage(RemotePlatform.class, (String)"TXT_RemotePlatform"), null);
        this.setSystemProperties(sysProperties);
    }

    @NonNull
    public static RemotePlatform create(@NonNull RemotePlatform prototype) {
        Parameters.notNull((CharSequence)"prototype", (Object)((Object)prototype));
        return new RemotePlatform(prototype.getDisplayName(), prototype.getProperties(), prototype.getSystemProperties());
    }

    @NonNull
    public static RemotePlatform prototype(@NonNull String displayName, @NonNull Map<String, String> additionalProperties, @NonNull Map<String, String> sysProps) {
        String antName;
        Parameters.notNull((CharSequence)"displayName", (Object)displayName);
        Parameters.notNull((CharSequence)"additionalProperties", additionalProperties);
        Parameters.notNull((CharSequence)"sysProps", sysProps);
        String currentDisplayName = displayName;
        int i = 0;
        while (!RemotePlatformProvider.isValidPlatformAntName(antName = PropertyUtils.getUsablePropertyName((String)currentDisplayName))) {
            currentDisplayName = String.format("%s %d", displayName, i);
            ++i;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(additionalProperties);
        props.put(PLAT_PROP_ANT_NAME, antName);
        return RemotePlatform.create(displayName, props, sysProps);
    }

    @NonNull
    static RemotePlatform create(@NonNull String name, @NonNull Map<String, String> properties, @NonNull Map<String, String> sysProperties) {
        return new RemotePlatform(name, properties, sysProperties);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public ClassPath getBootstrapLibraries() {
        return ClassPath.EMPTY;
    }

    public ClassPath getStandardLibraries() {
        return ClassPath.EMPTY;
    }

    public String getVendor() {
        return (String)this.getSystemProperties().get("java.vm.vendor");
    }

    public Specification getSpecification() {
        return this.spec;
    }

    public Collection<FileObject> getInstallFolders() {
        return Collections.emptySet();
    }

    public FileObject findTool(String toolName) {
        return null;
    }

    public ClassPath getSourceFolders() {
        return ClassPath.EMPTY;
    }

    public List<URL> getJavadocFolders() {
        return Collections.emptyList();
    }

    @NonNull
    public URI getInstallFolder() {
        String path = this.props.get(PLAT_PROP_INSTALL_FOLDER);
        if (path == null) {
            throw new IllegalStateException("No install folder.");
        }
        try {
            return new URI(path);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setInstallFolder(@NonNull URI installFolder) {
        Parameters.notNull((CharSequence)"installFolder", (Object)installFolder);
        this.props.put(PLAT_PROP_INSTALL_FOLDER, installFolder.toString());
        this.firePropertyChange(PROP_PROPERTIES, null, null);
    }

    @NonNull
    public URI getWorkFolder() {
        String path = this.props.get(PLAT_PROP_WORK_FOLDER);
        if (path == null) {
            throw new IllegalStateException("No work folder.");
        }
        try {
            return new URI(path);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setWorkFolder(@NonNull URI workDir) {
        Parameters.notNull((CharSequence)"workDir", (Object)workDir);
        this.props.put(PLAT_PROP_WORK_FOLDER, workDir.toString());
        this.firePropertyChange(PROP_PROPERTIES, null, null);
    }

    @NonNull
    public ConnectionMethod getConnectionMethod() {
        ConnectionMethod cm = this.connectionMethod;
        if (cm == null) {
            this.connectionMethod = cm = ConnectionMethod.load(this.props);
        }
        return cm;
    }

    @NonNull
    public SourceLevelQuery.Profile getProfile() {
        SourceLevelQuery.Profile profile = SourceLevelQuery.Profile.forName((String)this.getProperties().get(PROP_VM_PROFILE));
        if (profile == null) {
            profile = SourceLevelQuery.Profile.DEFAULT;
        }
        return profile;
    }

    public void setConnectionMethod(@NonNull ConnectionMethod cm) {
        Parameters.notNull((CharSequence)"cm", (Object)cm);
        this.connectionMethod = cm;
        cm.store(this.props);
        this.firePropertyChange(PROP_PROPERTIES, null, null);
    }

    @NonNull
    Collection<String> getGlobalPropertyNames() {
        HashSet<String> result = new HashSet<String>();
        result.add(PLAT_PROP_INSTALL_FOLDER);
        result.add(PLAT_PROP_WORK_FOLDER);
        result.add(PROP_VM_DEBUG);
        result.add(PROP_EXEC_DECORATOR);
        result.addAll(this.getConnectionMethod().getGlobalPropertyNames());
        return Collections.unmodifiableSet(result);
    }

    @CheckForNull
    String getVMType() {
        return this.getProperties().get(PROP_VM_TYPE);
    }

    @CheckForNull
    String getVMTarget() {
        return this.getProperties().get(PROP_VM_TARGET);
    }

    @CheckForNull
    String getExtensions() {
        return this.getProperties().get(PROP_VM_EXTENSIONS);
    }

    boolean canDebug() {
        String prop = this.getProperties().get(PROP_VM_DEBUG);
        return prop == null ? true : Boolean.parseBoolean(prop);
    }

    @CheckForNull
    String getExecDecorator() {
        return this.props.get(PROP_EXEC_DECORATOR);
    }

    void setExecDecorator(@NullAllowed String command) {
        if (command == null) {
            this.props.remove(PROP_EXEC_DECORATOR);
        } else {
            this.props.put(PROP_EXEC_DECORATOR, command);
        }
        this.firePropertyChange(PROP_PROPERTIES, null, null);
    }

    @NonNull
    private static SpecificationVersion createSpecificationVersion(@NullAllowed String version) {
        if (version != null) {
            try {
                return new SpecificationVersion(version);
            }
            catch (NumberFormatException nfe) {
                LOG.log(Level.WARNING, "Invalid specification version: {0}", version);
                while (true) {
                    version = version.substring(0, version.length() - 1);
                    try {
                        return new SpecificationVersion(version);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (version.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("1.1");
    }
}

