/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.vault;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public class SecretItem
extends OCIItem
implements URLProvider {
    private String lifecycleState;
    private Date deletionTime;
    private String vaultId;

    public SecretItem(OCID id, String compartmentId, String name, String lifecycleState, Date deletionTime, String vaultId, String tenancyId, String regionCode) {
        super(id, compartmentId, name, tenancyId, regionCode);
        this.lifecycleState = lifecycleState;
        this.deletionTime = deletionTime;
        this.vaultId = vaultId;
    }

    public SecretItem() {
        this.lifecycleState = null;
        this.deletionTime = null;
    }

    @Override
    public int maxInProject() {
        return Integer.MAX_VALUE;
    }

    public Date getDeletionTime() {
        return this.deletionTime;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    void setDeletionTime(Date deletionTime) {
        this.deletionTime = deletionTime;
    }

    public String getLifecycleState() {
        return this.lifecycleState;
    }

    void setLifecycleState(String lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Override
    public URL getURL() {
        if (this.getKey().getValue() != null && this.getRegion() != null) {
            try {
                URI uri = new URI(String.format("https://cloud.oracle.com/security/kms/vaults/%s/secrets/%s?region=%s", this.getVaultId(), this.getKey().getValue(), this.getRegion()));
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

