/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cpplite.debugger.CPPFrame;
import org.netbeans.modules.nativeimage.api.debug.NIFrame;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;

public final class CPPVariable
implements NIVariable {
    private final CPPFrame frame;
    private final CPPVariable parentVariable;
    private final String uniqueName;
    private final String name;
    private final String type;
    private final String value;
    private final int numChildren;
    private volatile Map<String, NIVariable> children;

    CPPVariable(CPPFrame frame, CPPVariable parentVariable, String uniqueName, String name, String type, MIValue value, int numChildren) {
        this.frame = frame;
        this.parentVariable = parentVariable;
        this.uniqueName = uniqueName;
        this.name = name;
        this.type = type;
        this.value = value instanceof MIConst ? ((MIConst)value).value() : Objects.toString(value);
        this.numChildren = numChildren;
    }

    public NIFrame getFrame() {
        return this.frame.getFrame();
    }

    public CPPVariable getParent() {
        return this.parentVariable;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int getNumChildren() {
        return this.numChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NIVariable> getChildrenByNames() {
        Map<String, NIVariable> vars = this.children;
        if (vars == null) {
            CPPVariable cPPVariable = this;
            synchronized (cPPVariable) {
                vars = this.children;
                if (vars == null) {
                    this.children = vars = CPPFrame.retrieveVariables(this.frame, this);
                }
            }
        }
        return vars;
    }

    public NIVariable[] getChildren(int from, int to) {
        Map<String, NIVariable> childrenVariables = this.getChildrenByNames();
        NIVariable[] array = childrenVariables.values().toArray(new NIVariable[0]);
        if (array.length == 1 && array[0] == null) {
            return new NIVariable[0];
        }
        if (from >= 0) {
            array = from < (to = Math.min(to, array.length)) ? Arrays.copyOfRange(array, from, to) : new NIVariable[]{};
        }
        return array;
    }

    public String getExpressionPath() {
        MIRecord pathRecord;
        try {
            pathRecord = this.frame.getThread().getDebugger().sendAndGet("-var-info-path-expression \"" + this.uniqueName + "\"");
        }
        catch (InterruptedException ex) {
            return null;
        }
        String pathExpression = pathRecord.results().getConstValue("path_expr");
        return pathExpression;
    }
}

