/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support.java;

import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class JavaIdentifiers {
    private JavaIdentifiers() {
    }

    public static boolean isValidPackageName(String packageName) {
        Parameters.notNull((CharSequence)"packageName", (Object)packageName);
        if ("".equals(packageName)) {
            return true;
        }
        if (packageName.startsWith(".") || packageName.endsWith(".")) {
            return false;
        }
        if (packageName.equals("java") || packageName.startsWith("java.")) {
            return false;
        }
        String[] tokens = packageName.split("\\.");
        if (tokens.length == 0) {
            return Utilities.isJavaIdentifier((String)packageName);
        }
        for (String token : tokens) {
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static String getQualifiedName(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            return classPath.getResourceName(fileObject, '.', false);
        }
        return null;
    }

    public static String unqualify(String fqn) {
        JavaIdentifiers.checkFQN(fqn);
        int lastDot = fqn.lastIndexOf(".");
        if (lastDot < 0) {
            return fqn;
        }
        return fqn.substring(lastDot + 1);
    }

    public static String getPackageName(String fqn) {
        JavaIdentifiers.checkFQN(fqn);
        int lastDot = fqn.lastIndexOf(".");
        if (lastDot < 0) {
            return "";
        }
        return fqn.substring(0, lastDot);
    }

    private static void checkFQN(String fqn) {
        Parameters.notEmpty((CharSequence)"fqn", (CharSequence)fqn);
        if (!JavaIdentifiers.isValidPackageName(fqn)) {
            throw new IllegalArgumentException("The given fqn [" + fqn + "] does not represent a fully qualified class name");
        }
    }
}

