/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.htmlxml;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spellchecker.bindings.htmlxml.HtmlTokenList;
import org.netbeans.modules.spellchecker.bindings.htmlxml.XmlTokenList;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.netbeans.modules.spellchecker.spi.language.TokenListProvider;

public class HtmlXmlTokenListProvider
implements TokenListProvider {
    private static final Map<String, String> MIME_TO_SETTING_NAME = new HashMap<String, String>();

    public TokenList findTokenList(Document doc) {
        if (!(doc instanceof BaseDocument)) {
            Logger.getLogger(HtmlXmlTokenListProvider.class.getName()).log(Level.INFO, null, new IllegalStateException("The given document is not an instance of the BaseDocument, is just " + doc.getClass().getName()));
            return null;
        }
        final BaseDocument bdoc = (BaseDocument)doc;
        final String docMimetype = NbEditorUtilities.getMimeType((Document)doc);
        final AtomicReference ret = new AtomicReference();
        doc.render(new Runnable(){
            final /* synthetic */ HtmlXmlTokenListProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                TokenHierarchy th = TokenHierarchy.get((Document)bdoc);
                Set paths = th.languagePaths();
                for (LanguagePath path : paths) {
                    if (path.innerLanguage() != HTMLTokenId.language()) continue;
                    String settingName = (String)MIME_TO_SETTING_NAME.get(docMimetype);
                    ret.set(new HtmlTokenList(bdoc, settingName));
                    break;
                }
            }
        });
        if (ret.get() != null) {
            return (TokenList)ret.get();
        }
        if (docMimetype != null && docMimetype.contains("xml")) {
            return new XmlTokenList(bdoc);
        }
        return null;
    }

    static {
        MIME_TO_SETTING_NAME.put("text/html", "HTML");
        MIME_TO_SETTING_NAME.put("text/xhtml", "XHTML");
        MIME_TO_SETTING_NAME.put("text/x-jsp", "JSP");
        MIME_TO_SETTING_NAME.put("text/x-tag", "JSP");
        MIME_TO_SETTING_NAME.put("text/x-gsp", "GSP");
        MIME_TO_SETTING_NAME.put("text/x-php5", "PHP");
    }
}

