/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DetachBootVolumeRequest
extends BmcRequest<Void> {
    private String bootVolumeAttachmentId;
    private String ifMatch;

    public String getBootVolumeAttachmentId() {
        return this.bootVolumeAttachmentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().bootVolumeAttachmentId(this.bootVolumeAttachmentId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bootVolumeAttachmentId=").append(String.valueOf(this.bootVolumeAttachmentId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetachBootVolumeRequest)) {
            return false;
        }
        DetachBootVolumeRequest other = (DetachBootVolumeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bootVolumeAttachmentId, other.bootVolumeAttachmentId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bootVolumeAttachmentId == null ? 43 : this.bootVolumeAttachmentId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DetachBootVolumeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bootVolumeAttachmentId = null;
        private String ifMatch = null;

        public Builder bootVolumeAttachmentId(String bootVolumeAttachmentId) {
            this.bootVolumeAttachmentId = bootVolumeAttachmentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachBootVolumeRequest o) {
            this.bootVolumeAttachmentId(o.getBootVolumeAttachmentId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachBootVolumeRequest build() {
            DetachBootVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DetachBootVolumeRequest buildWithoutInvocationCallback() {
            DetachBootVolumeRequest request = new DetachBootVolumeRequest();
            request.bootVolumeAttachmentId = this.bootVolumeAttachmentId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

