/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view;

import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.design.view.widget.AbstractTitledWidget;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.CheckBoxWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.netbeans.modules.websvc.jaxws.api.JAXWSView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

@SuppressWarnings(value={"SE_BAD_FIELD"})
public class WsitWidget
extends AbstractTitledWidget {
    private transient FileObject implementationClass;
    private transient Widget buttons;
    private transient Widget configButtons;
    private transient ButtonWidget advancedButton;
    private transient ImageLabelWidget headerLabelWidget;
    private Service service;
    private PropertyChangeListener configListener;
    private Object key = new Object();
    private Collection<WSConfiguration> configurations;

    public WsitWidget(ObjectScene scene, Service service, FileObject implementationClass, Collection<WSConfiguration> wsConfigurations) {
        super(scene, 12, BORDER_COLOR);
        this.implementationClass = implementationClass;
        this.service = service;
        this.configurations = wsConfigurations;
        this.setOpaque(true);
        this.setBackground(TITLE_COLOR_PARAMETER);
        this.configListener = new WSConfigurationListener(this);
        this.createContent();
    }

    private void createContent() {
        this.headerLabelWidget = new ImageLabelWidget(this.getScene(), null, NbBundle.getMessage(WsitWidget.class, (String)"LBL_Wsit"));
        this.headerLabelWidget.setLabelFont(this.getScene().getFont().deriveFont(1));
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)8));
        this.buttons.addChild((Widget)this.getExpanderWidget());
        this.getHeaderWidget().addChild(this.buttons);
        this.getContentWidget().setBorder(BorderFactory.createEmptyBorder((int)12));
        this.configButtons = new Widget(this.getScene());
        this.configButtons.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)12));
        this.getContentWidget().addChild(this.configButtons);
        this.populateConfigWidget();
        Widget advancedButtonContainer = new Widget(this.getScene());
        advancedButtonContainer.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.RIGHT_BOTTOM, (int)12));
        this.advancedButton = new ButtonWidget(this.getScene(), new AdvancedAction(this.service, this.implementationClass));
        this.advancedButton.setOpaque(true);
        this.advancedButton.setRoundedBorder(3, 4, 0, null);
        advancedButtonContainer.addChild((Widget)this.advancedButton);
        this.getContentWidget().addChild(advancedButtonContainer);
    }

    private void populateConfigWidget() {
        for (final WSConfiguration config : this.getWSConfigurations()) {
            if (config == null) continue;
            CheckBoxWidget button = new CheckBoxWidget(this, this.getScene(), config.getDisplayName()){
                final /* synthetic */ WsitWidget this$0;
                {
                    this.this$0 = this$0;
                    super(scene, text);
                }

                @Override
                protected Object hashKey() {
                    return config;
                }

                @Override
                protected void notifyAdded() {
                    super.notifyAdded();
                    config.registerListener(this.this$0.configListener);
                    this.setVisible(config.isEnabled());
                    this.this$0.determineVisibility();
                }

                @Override
                protected void notifyRemoved() {
                    super.notifyRemoved();
                    config.unregisterListener(this.this$0.configListener);
                }
            };
            button.setSelected(config.isSet());
            button.setAction(new ConfigWidgetAction(config));
            button.setToolTipText(config.getDescription());
            button.setLabelFont(this.getScene().getFont().deriveFont(1));
            this.configButtons.addChild((Widget)button);
        }
    }

    private Collection<WSConfiguration> getWSConfigurations() {
        return this.configurations;
    }

    private void determineVisibility() {
        for (Widget button : this.configButtons.getChildren()) {
            if (!button.isVisible()) continue;
            this.setVisible(true);
            return;
        }
        this.setVisible(false);
    }

    protected Paint getBodyPaint(Rectangle bounds) {
        return TITLE_COLOR_PARAMETER;
    }

    @Override
    public Object hashKey() {
        return this.key;
    }

    static final class WSConfigurationListener
    implements PropertyChangeListener {
        private WsitWidget widget;

        private WSConfigurationListener(WsitWidget widget) {
            this.widget = widget;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            ObjectScene scene = (ObjectScene)this.widget.getScene();
            String property = evt.getPropertyName();
            Object newValue = evt.getNewValue();
            if (source instanceof WSConfiguration) {
                Widget configWidget = scene.findWidget(source);
                if ("value".equals(property)) {
                    if (configWidget instanceof CheckBoxWidget) {
                        ((CheckBoxWidget)configWidget).setSelected((Boolean)newValue);
                        scene.validate();
                        this.widget.revalidate(true);
                    }
                } else if ("enabled".equals(property) && configWidget instanceof CheckBoxWidget) {
                    ((CheckBoxWidget)configWidget).setVisible((Boolean)newValue);
                    this.widget.determineVisibility();
                    this.widget.revalidate();
                }
            }
        }
    }

    class AdvancedAction
    extends AbstractAction {
        private transient FileObject implementationClass;
        private Service service;
        private EditWSAttributesCookie cookie;

        public AdvancedAction(Service service, FileObject implementationClass) {
            super(NbBundle.getMessage(WsitWidget.class, (String)"LBL_Wsit_Advanced"));
            this.putValue("ShortDescription", NbBundle.getMessage(AdvancedAction.class, (String)"Hint_Wsit_Advanced"));
            this.putValue("MnemonicKey", Integer.valueOf(NbBundle.getMessage(AdvancedAction.class, (String)"LBL_Wsit_Advanced_mnem_pos")));
            this.implementationClass = implementationClass;
            this.service = service;
            this.setEnabled(false);
            this.initializeCookie();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.cookie == null) {
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    AdvancedAction.this.cookie.openWSAttributesEditor();
                }
            }, 10);
        }

        private void initializeCookie() {
            Project project = FileOwnerQuery.getOwner((FileObject)this.implementationClass);
            if (project == null) {
                return;
            }
            JAXWSView view = JAXWSView.getJAXWSView();
            if (view == null) {
                return;
            }
            final Node node = view.createJAXWSView(project);
            if (node == null) {
                return;
            }
            final FileObject currentImplBean = this.implementationClass;
            final Service currentService = this.service;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ AdvancedAction this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    for (Node n : node.getChildren().getNodes()) {
                        Service sv = (Service)n.getLookup().lookup(Service.class);
                        if (sv == null || n.getLookup().lookup(FileObject.class) != currentImplBean || !sv.getName().equals(currentService.getName())) continue;
                        this.this$1.cookie = (EditWSAttributesCookie)n.getLookup().lookup(EditWSAttributesCookie.class);
                        this.this$1.setEnabled(this.this$1.cookie != null);
                        return;
                    }
                }
            });
        }
    }

    static class ConfigWidgetAction
    extends AbstractAction {
        WSConfiguration config;

        public ConfigWidgetAction(WSConfiguration config) {
            this.config = config;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("toggle-button-selected")) {
                this.config.set();
            } else {
                this.config.unset();
            }
        }
    }
}

