/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.access;

import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.InvalidObjectException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.truffle.PersistentValues;
import org.netbeans.modules.debugger.jpda.truffle.TruffleDebugManager;
import org.netbeans.modules.debugger.jpda.truffle.access.Bundle;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.openide.util.Exceptions;

public class TruffleEval {
    private static final String METHOD_EVALUATE = "evaluate";
    private static final String METHOD_EVALUATE_ON_FRAME_SIG = "(Lcom/oracle/truffle/api/debug/DebugStackFrame;Ljava/lang/String;)Ljava/lang/Object;";

    private TruffleEval() {
    }

    public static Variable evaluate(JPDADebugger debugger, String expression) throws InvalidExpressionException {
        JPDAThread currentThread = debugger.getCurrentThread();
        CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(currentThread);
        if (currentPCInfo == null) {
            throw new InvalidExpressionException(Bundle.MSG_NoSuspend());
        }
        return TruffleEval.evaluate(debugger, currentPCInfo, expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Variable evaluate(JPDADebugger debugger, CurrentPCInfo currentPCInfo, String expression) throws InvalidExpressionException {
        TruffleStackFrame selectedStackFrame = currentPCInfo.getSelectedStackFrame();
        if (selectedStackFrame == null) {
            throw new InvalidExpressionException(Bundle.MSG_NoSuspend());
        }
        ObjectVariable stackFrameInstance = selectedStackFrame.getStackFrameInstance();
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(debugger);
        PersistentValues values = new PersistentValues(((JPDADebuggerImpl)debugger).getVirtualMachine());
        try {
            Variable valueVar;
            StringReference expressionReference = values.mirrorOf(expression);
            Variable mirrorExpression = ((JPDADebuggerImpl)debugger).getVariable((Value)expressionReference);
            Variable variable = valueVar = debugAccessor.invokeMethod(METHOD_EVALUATE, METHOD_EVALUATE_ON_FRAME_SIG, new Variable[]{stackFrameInstance, mirrorExpression});
            return variable;
        }
        catch (InvalidExpressionException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof InvocationExceptionTranslated) {
                ((InvocationExceptionTranslated)targetException).resetInvocationMessage();
            }
            throw ex;
        }
        catch (NoSuchMethodException | InternalExceptionWrapper | UnsupportedOperationExceptionWrapper ex) {
            try {
                Variable targetException = debugger.createMirrorVar((Object)ex.getLocalizedMessage());
                return targetException;
            }
            catch (InvalidObjectException iex) {
                Exceptions.printStackTrace((Throwable)iex);
                Variable variable = null;
                return variable;
            }
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            Variable variable = null;
            return variable;
        }
        finally {
            values.collect();
        }
    }
}

