/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common.annotation;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRefHandler;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRefHandlerChains;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.PortComponentRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ResourceImpl;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

public class ServiceRefImpl
implements ServiceRef {
    private final TypeElement typeElement;
    private final TypeElement parentElement;
    private final Element element;
    private final AnnotationModelHelper helper;
    private String serviceRefName;
    private String wsdlFile;
    private String value;
    private String type;
    private PortComponentRef[] portComponentRefs;

    public ServiceRefImpl(Element element, TypeElement typeElement, TypeElement parentElement, AnnotationModelHelper helper) {
        this.typeElement = typeElement;
        this.helper = helper;
        this.element = element;
        this.parentElement = parentElement;
        Map annByType = helper.getAnnotationsByType(element.getAnnotationMirrors());
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
        parser.expectString("name", null);
        parser.expectString("wsdlLocation", null);
        parser.expectClass("value", null);
        parser.expectClass("type", null);
        AnnotationMirror annotationMirror = (AnnotationMirror)annByType.get("jakarta.xml.ws.WebServiceRef");
        if (annotationMirror == null) {
            annotationMirror = (AnnotationMirror)annByType.get("javax.xml.ws.WebServiceRef");
        }
        ParseResult parseResult = parser.parse(annotationMirror);
        this.serviceRefName = (String)parseResult.get("name", String.class);
        this.wsdlFile = (String)parseResult.get("wsdlLocation", String.class);
        this.value = (String)parseResult.get("value", String.class);
        this.type = (String)parseResult.get("type", String.class);
    }

    public ServiceRefImpl(ResourceImpl resource) {
        this.serviceRefName = resource.getName();
        this.value = resource.getType();
        this.typeElement = null;
        this.element = null;
        this.helper = null;
        this.parentElement = null;
    }

    @Override
    public URI getWsdlFile() {
        URI wsdlURI = null;
        if (this.wsdlFile != null) {
            try {
                wsdlURI = new URI(this.wsdlFile);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return wsdlURI;
    }

    @Override
    public String getServiceRefName() {
        if (this.serviceRefName != null) {
            return this.serviceRefName;
        }
        if (this.parentElement != null && this.element != null) {
            return this.parentElement.getQualifiedName().toString() + "/" + this.element.getSimpleName().toString();
        }
        if (this.value != null) {
            return "service/" + this.getClassNameFromClass(this.value);
        }
        if (this.type != null) {
            return "service/" + this.getClassNameFromClass(this.type);
        }
        return "service/" + this.typeElement.getSimpleName().toString();
    }

    @Override
    public String getServiceInterface() {
        if (this.value != null) {
            return this.value;
        }
        if (this.type != null) {
            return this.type;
        }
        return this.typeElement.getQualifiedName().toString();
    }

    @Override
    public PortComponentRef[] getPortComponentRef() {
        this.initPortComponentRefs();
        return this.portComponentRefs;
    }

    @Override
    public int sizePortComponentRef() {
        this.initPortComponentRefs();
        return this.portComponentRefs.length;
    }

    @Override
    public PortComponentRef getPortComponentRef(int index) {
        this.initPortComponentRefs();
        return this.portComponentRefs[index];
    }

    private void initPortComponentRefs() {
        if (this.portComponentRefs == null) {
            ArrayList<PortComponentRefImpl> portComponents = new ArrayList<PortComponentRefImpl>();
            String sei = null;
            if (this.value != null) {
                sei = this.type != null ? this.type : this.typeElement.getQualifiedName().toString();
            }
            if (sei != null) {
                portComponents.add(new PortComponentRefImpl(sei));
            }
            this.portComponentRefs = portComponents.toArray(new PortComponentRef[0]);
        }
    }

    @Override
    public String getJaxrpcMappingFile() {
        return null;
    }

    @Override
    public int addPortComponentRef(PortComponentRef portComponentRef) {
        if (!(portComponentRef instanceof PortComponentRefImpl)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.portComponentRefs != null) {
            PortComponentRef[] newRefs = new PortComponentRef[this.portComponentRefs.length + 1];
            for (int i = 0; i < this.portComponentRefs.length; ++i) {
                newRefs[i] = this.portComponentRefs[i];
            }
            newRefs[this.portComponentRefs.length] = portComponentRef;
            this.portComponentRefs = newRefs;
        } else {
            this.portComponentRefs = new PortComponentRef[]{portComponentRef};
        }
        return this.portComponentRefs.length - 1;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setServiceRefName(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setServiceInterface(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setWsdlFile(URI value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setJaxrpcMappingFile(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setServiceQname(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getServiceQname() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPortComponentRef(int index, PortComponentRef valueInterface) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPortComponentRef(PortComponentRef[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePortComponentRef(PortComponentRef valueInterface) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHandler(int index, ServiceRefHandler valueInterface) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandler getHandler(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHandler(ServiceRefHandler[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandler[] getHandler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeHandler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addHandler(ServiceRefHandler valueInterface) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeHandler(ServiceRefHandler valueInterface) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMappedName(String value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMappedName() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHandlerChains(ServiceRefHandlerChains valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandlerChains getHandlerChains() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PortComponentRef newPortComponentRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandler newServiceRefHandler() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandlerChains newServiceRefHandlerChains() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getValue(String propertyName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void write(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescription(String locale, String description) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescription(String description) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAllDescriptions(Map descriptions) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDescription(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDefaultDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map getAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDescriptionForLocale(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayName(String locale, String displayName) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayName(String displayName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAllDisplayNames(Map displayNames) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDisplayName(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDefaultDisplayName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map getAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDisplayNameForLocale(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDisplayName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean createBean(String beanName) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean addBean(String beanName, String[] propertyNames, Object[] propertyValues, String keyProperty) throws ClassNotFoundException, NameAlreadyUsedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean addBean(String beanName) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean findBeanByName(String beanName, String propertyName, String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSmallIcon(String locale, String icon) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSmallIcon(String icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLargeIcon(String locale, String icon) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLargeIcon(String icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAllIcons(String[] locales, String[] smallIcons, String[] largeIcons) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIcon(Icon icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSmallIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getLargeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Icon getDefaultIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map getAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeSmallIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeLargeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String getClassNameFromClass(String className) {
        int indexDot = className.lastIndexOf(46);
        return className.substring(indexDot + 1);
    }
}

