/*
 * Decompiled with CFR 0.152.
 */
package net.vieiro.toml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.vieiro.toml.TOML;
import net.vieiro.toml.TOMLVisitor;
import net.vieiro.toml.antlr4.TOMLAntlrLexer;
import net.vieiro.toml.antlr4.TOMLAntlrParser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointBuffer;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public final class TOMLParser {
    private static final Logger LOG = Logger.getLogger(TOMLParser.class.getName());
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    private TOMLParser() {
    }

    public static TOML parseFromString(String content) throws IOException {
        return TOMLParser.parse((CharStream)CharStreams.fromString((String)content));
    }

    public static TOML parseFromReader(Reader reader) throws IOException {
        return TOMLParser.parseFromReader(reader, "Unknown source");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TOML parseFromReader(Reader reader, String filename) throws IOException {
        try {
            CodePointBuffer.Builder codePointBufferBuilder = CodePointBuffer.builder((int)16384);
            CharBuffer charBuffer = CharBuffer.allocate(16384);
            while (reader.read(charBuffer) != -1) {
                charBuffer.flip();
                codePointBufferBuilder.append(charBuffer);
                charBuffer.compact();
            }
            CodePointCharStream stream = CodePointCharStream.fromBuffer((CodePointBuffer)codePointBufferBuilder.build(), (String)filename);
            TOML tOML = TOMLParser.parse((CharStream)stream);
            return tOML;
        }
        catch (MalformedInputException mie) {
            String error = String.format("Malformed UTF-8 detected on input %s", mie.getMessage());
            TOML tOML = new TOML(Collections.emptyMap(), Arrays.asList(error));
            return tOML;
        }
        finally {
            reader.close();
        }
    }

    public static TOML parseFromFilename(String filename) throws IOException {
        return TOMLParser.parse(CharStreams.fromFileName((String)filename, (Charset)StandardCharsets.UTF_8));
    }

    public static TOML parseFromInputStream(InputStream input) throws IOException {
        TOML tOML;
        block8: {
            ReadableByteChannel channel = Channels.newChannel(input);
            try {
                CodePointCharStream stream = CharStreams.fromChannel((ReadableByteChannel)channel, (Charset)StandardCharsets.UTF_8, (int)16384, (CodingErrorAction)CodingErrorAction.REPORT, (String)"<unknown>", (long)-1L);
                tOML = TOMLParser.parse((CharStream)stream);
                if (channel == null) break block8;
            }
            catch (Throwable stream) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            stream.addSuppressed(throwable);
                        }
                    }
                    throw stream;
                }
                catch (MalformedInputException mie) {
                    String error = String.format("Malformed UTF-8 detected on input %s", mie.getMessage());
                    return new TOML(Collections.emptyMap(), Arrays.asList(error));
                }
            }
            channel.close();
        }
        return tOML;
    }

    private static TOML parse(CharStream input) {
        TOMLVisitor visitor = new TOMLVisitor();
        TOMLAntlrLexer lexer = new TOMLAntlrLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(visitor);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        TOMLAntlrParser parser = new TOMLAntlrParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(visitor);
        try {
            parser.document().accept(visitor);
        }
        catch (NoViableAltException nvae) {
            visitor.getErrors().add("toml-java cannot parse this TOML documen. If you're sure this is a valid TOML document please file an issue in toml-java");
            TOML toml = new TOML(Collections.emptyMap(), visitor.getErrors());
            return toml;
        }
        catch (ParseCancellationException pce) {
            visitor.getErrors().add(pce.getMessage());
            TOML toml = new TOML(Collections.emptyMap(), visitor.getErrors());
            return toml;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage() + "/" + e.getClass().getName(), e);
            visitor.getErrors().add(String.format("Parsing stopped: %s", e.getMessage()));
            TOML toml = new TOML(Collections.emptyMap(), visitor.getErrors());
            return toml;
        }
        return new TOML(visitor.getRoot(), visitor.getErrors());
    }
}

