/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.settings.DashboardSettings;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.actions.Actions;
import org.netbeans.modules.bugtracking.tasks.dashboard.Bundle;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskContainerNode;
import org.netbeans.modules.team.commons.ColorManager;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.netbeans.modules.team.commons.treelist.TreeLabel;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.openide.util.ImageUtilities;

public class QueryNode
extends TaskContainerNode
implements Comparable<QueryNode> {
    private final QueryImpl query;
    private JPanel panel;
    private TreeLabel lblName;
    private LinkButton btnChanged;
    private LinkButton btnTotal;
    private TreeLabel lblStalled;
    private final QueryListener queryListener;
    private final Object LOCK = new Object();
    private TreeLabel lblSeparator;
    private static final ImageIcon QUERY_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/query.png", (boolean)true);

    public QueryNode(QueryImpl query, TreeListNode parent) {
        super(!query.wasRefreshed() && DashboardUtils.isQueryAutoRefresh(query), true, parent, query.getDisplayName(), QUERY_ICON);
        this.query = query;
        this.queryListener = new QueryListener();
    }

    @Override
    void refreshTaskContainer() {
        this.query.refresh();
    }

    @Override
    protected void attach() {
        super.attach();
        this.query.addPropertyChangeListener(this.queryListener);
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.query.removePropertyChangeListener(this.queryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateCounts() {
        if (this.panel != null) {
            String changedString;
            String totalString;
            int count;
            Object object = this.LOCK;
            synchronized (object) {
                count = this.getChangedTaskCount();
                totalString = this.getTotalString();
                changedString = this.getChangedString(count);
            }
            UIUtils.runInAWT((Runnable)new Runnable(){
                final /* synthetic */ QueryNode this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.btnTotal.setText(totalString);
                    this.this$0.btnChanged.setText(changedString);
                    boolean showChanged = count > 0;
                    this.this$0.lblSeparator.setVisible(showChanged);
                    this.this$0.btnChanged.setVisible(showChanged);
                }
            });
        }
    }

    @Override
    public List<IssueImpl> getTasks(boolean includingNodeItself) {
        List<IssueImpl> tasks = Collections.emptyList();
        try {
            tasks = new ArrayList<IssueImpl>(this.query.getIssues());
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configure(JComponent component, Color foreground, Color background, boolean isSelected, boolean hasFocus, int rowWidth) {
        super.configure(component, foreground, background, isSelected, hasFocus, rowWidth);
        if (this.panel != null) {
            boolean containsActiveTask;
            Object object = this.LOCK;
            synchronized (object) {
                containsActiveTask = DashboardViewer.getInstance().containsActiveTask((TreeListNode)this);
            }
            UIUtils.runInAWT((Runnable)new Runnable(){
                final /* synthetic */ QueryNode this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (containsActiveTask) {
                        this.this$0.lblName.setFont(this.this$0.lblName.getFont().deriveFont(1));
                    } else {
                        this.this$0.lblName.setFont(this.this$0.lblName.getFont().deriveFont(0));
                    }
                    this.this$0.lblStalled.setForeground(ColorManager.getTheInstance().getDisabledColor());
                }
            });
        }
    }

    protected JComponent createComponent(List<IssueImpl> data) {
        if (this.isError()) {
            this.setError(false);
            return null;
        }
        this.updateNodes(data);
        this.createComponent();
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createComponent() {
        Object object = this.LOCK;
        synchronized (object) {
            this.panel = new JPanel(new GridBagLayout());
            this.panel.setOpaque(false);
            this.labels.clear();
            this.buttons.clear();
            JLabel lblIcon = new JLabel(this.getIcon());
            this.panel.add((Component)lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.lblName = new TreeLabel(this.query.getDisplayName());
            this.panel.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.labels.add(this.lblName);
            TreeLabel lbl = new TreeLabel("(");
            this.labels.add(lbl);
            this.panel.add((Component)lbl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            ExpandAction expandAction = new ExpandAction();
            this.btnTotal = new LinkButton(this.getTotalString(), false, (Action)expandAction);
            this.panel.add((Component)this.btnTotal, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.buttons.add(this.btnTotal);
            int count = this.getChangedTaskCount();
            boolean showChanged = count > 0;
            this.lblSeparator = new TreeLabel("|");
            this.lblSeparator.setVisible(showChanged);
            this.panel.add((Component)this.lblSeparator, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
            this.labels.add(this.lblSeparator);
            this.btnChanged = new LinkButton(this.getChangedString(count), false, (Action)expandAction);
            this.btnChanged.setVisible(showChanged);
            this.panel.add((Component)this.btnChanged, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.buttons.add(this.btnChanged);
            boolean isStalled = !DashboardUtils.isQueryAutoRefresh(this.query);
            this.lblStalled = new TreeLabel(Bundle.CTL_AutoRefreshOff());
            this.lblStalled.setForeground(ColorManager.getTheInstance().getDisabledColor());
            this.lblStalled.setVisible(isStalled);
            this.panel.add((Component)this.lblStalled, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
            this.labels.add(this.lblStalled);
            lbl = new TreeLabel(")");
            this.labels.add(lbl);
            this.panel.add((Component)lbl, new GridBagConstraints(8, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(9, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStalled(boolean isStalled) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.lblStalled != null) {
                this.lblStalled.setVisible(isStalled);
            }
        }
    }

    @Override
    Icon getIcon() {
        return QUERY_ICON;
    }

    protected Action getDefaultAction() {
        return this.query.providesMode(QueryController.QueryMode.VIEW) ? new Actions.OpenQueryAction(this) : null;
    }

    public Action[] getPopupActions() {
        List<TreeListNode> selectedNodes = DashboardViewer.getInstance().getSelectedNodes();
        QueryNode[] queryNodes = new QueryNode[selectedNodes.size()];
        boolean justQueries = true;
        for (int i = 0; i < selectedNodes.size(); ++i) {
            TreeListNode treeListNode = selectedNodes.get(i);
            if (!(treeListNode instanceof QueryNode)) {
                justQueries = false;
                break;
            }
            queryNodes[i] = (QueryNode)treeListNode;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        if (justQueries) {
            actions.addAll(Actions.getQueryPopupActions(queryNodes));
        }
        actions.add(null);
        actions.addAll(Actions.getDefaultActions(selectedNodes.toArray(new TreeListNode[0])));
        return actions.toArray(new Action[0]);
    }

    public QueryImpl getQuery() {
        return this.query;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryNode other = (QueryNode)obj;
        if (!this.query.getRepositoryImpl().getId().equals(other.query.getRepositoryImpl().getId())) {
            return false;
        }
        return this.query.getDisplayName().equalsIgnoreCase(other.query.getDisplayName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.query != null ? this.query.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(QueryNode toCompare) {
        return this.query.getDisplayName().compareToIgnoreCase(toCompare.query.getDisplayName());
    }

    public String toString() {
        return this.query.getDisplayName();
    }

    @Override
    boolean isTaskLimited() {
        return DashboardSettings.getInstance().isTasksLimitQuery();
    }

    private class QueryListener
    implements PropertyChangeListener {
        private boolean loadingStarted = false;

        private QueryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("bugtracking.query.refresh.started") || evt.getPropertyName().equals("bugtracking.query.restore.started")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        QueryNode.this.setLoadingVisible(true);
                        QueryListener.this.loadingStarted = true;
                    }
                });
            } else if (evt.getPropertyName().equals("bugtracking.query.refresh.finished") || evt.getPropertyName().equals("bugtracking.query.restore.finished")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (QueryListener.this.loadingStarted) {
                            QueryNode.this.setLoadingVisible(false);
                            QueryListener.this.loadingStarted = false;
                        }
                        QueryNode.this.updateContent();
                    }
                });
            }
        }
    }

    private class ExpandAction
    extends AbstractAction {
        private ExpandAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryNode.this.setExpanded(!QueryNode.this.isExpanded());
        }
    }
}

