/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.project.runner;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.spi.java.project.runner.JavaRunnerImplementation;
import org.openide.execution.ExecutorTask;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class JavaRunner {
    public static final String QUICK_RUN = "run";
    public static final String QUICK_DEBUG = "debug";
    public static final String QUICK_PROFILE = "profile";
    public static final String QUICK_TEST = "junit";
    public static final String QUICK_TEST_DEBUG = "junit-debug";
    public static final String QUICK_TEST_PROFILE = "junit-profile";
    public static final String QUICK_RUN_APPLET = "run-applet";
    public static final String QUICK_DEBUG_APPLET = "debug-applet";
    public static final String QUICK_PROFILE_APPLET = "profile-applet";
    public static final String QUICK_CLEAN = "clean";
    public static final String PROP_EXECUTE_FILE = "execute.file";
    public static final String PROP_WORK_DIR = "work.dir";
    public static final String PROP_RUN_JVMARGS = "run.jvmargs";
    public static final String PROP_CLASSNAME = "classname";
    public static final String PROP_EXECUTE_CLASSPATH = "execute.classpath";
    public static final String PROP_EXECUTE_MODULEPATH = "execute.modulepath";
    public static final String PROP_PLATFORM_JAVA = "platform.java";
    public static final String PROP_PLATFORM = "platform";
    public static final String PROP_PROJECT_NAME = "project.name";
    public static final String PROP_APPLICATION_ARGS = "application.args";
    public static final String PROP_RUNTIME_ENCODING = "runtime.encoding";
    private static final Logger LOG = Logger.getLogger(JavaRunner.class.getName());

    public static boolean isSupported(String command, Map<String, ?> properties) {
        Parameters.notNull((CharSequence)"command", (Object)command);
        Parameters.notNull((CharSequence)"properties", properties);
        for (JavaRunnerImplementation i : Lookup.getDefault().lookupAll(JavaRunnerImplementation.class)) {
            if (!i.isSupported(command, properties)) continue;
            return true;
        }
        return false;
    }

    public static ExecutorTask execute(String command, Map<String, ?> properties) throws IOException, UnsupportedOperationException {
        Parameters.notNull((CharSequence)"command", (Object)command);
        Parameters.notNull((CharSequence)"properties", properties);
        Collection runners = Lookup.getDefault().lookupAll(JavaRunnerImplementation.class);
        for (JavaRunnerImplementation i : runners) {
            if (!i.isSupported(command, properties)) continue;
            return i.execute(command, properties);
        }
        throw new UnsupportedOperationException(MessageFormat.format("command: {0}, JavaRunner impls: {1}", command, runners));
    }
}

