/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;

public class InstanceRefFinder
extends ErrorAwareTreePathScanner {
    private TreePath initPath;
    private final CompilationInfo ci;
    private Set<TypeElement> instancesRequired = Collections.emptySet();
    private Element enclosingElement;
    private TreePath enclosingElementPath;
    private TypeElement enclosingType;
    private Set<TypeElement> superReferences = Collections.emptySet();
    private Set<Element> usedMembers = new HashSet<Element>();
    private Set<TypeElement> localReferences = Collections.emptySet();

    public InstanceRefFinder(CompilationInfo ci, TreePath path) {
        this.ci = ci;
        this.initPath = path;
    }

    public Set<TypeElement> getRequiredInstances() {
        return this.instancesRequired;
    }

    public boolean containsLocalReferences() {
        return !this.localReferences.isEmpty();
    }

    public boolean containsInstanceReferences() {
        return !this.instancesRequired.isEmpty();
    }

    public boolean containsReferencesToSuper() {
        return !this.superReferences.isEmpty();
    }

    public Set<TypeElement> getSuperReferences() {
        return this.superReferences;
    }

    private void findEnclosingElement() {
        TreePath path = this.initPath;
        do {
            Tree t = path.getLeaf();
            switch (t.getKind()) {
                case METHOD: 
                case VARIABLE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case RECORD: 
                case NEW_CLASS: {
                    this.enclosingElementPath = path;
                    this.enclosingElement = this.ci.getTrees().getElement(this.enclosingElementPath);
                    if (this.enclosingElement == null) {
                        return;
                    }
                    this.enclosingType = this.enclosingElement instanceof TypeElement ? (TypeElement)this.enclosingElement : this.ci.getElementUtilities().enclosingTypeElement(this.enclosingElement);
                    return;
                }
            }
        } while ((path = path.getParentPath()) != null);
    }

    private void addLocalReference(TypeElement el) {
        if (this.enclosingElement != el.getEnclosingElement()) {
            return;
        }
        if (this.localReferences.isEmpty()) {
            this.localReferences = new HashSet<TypeElement>();
        }
        this.localReferences.add(el);
    }

    private void addInstanceForMemberOf(Element el) {
        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        TypeElement owner = this.findOwnerType(el);
        this.addRequiredInstance(owner);
        this.addUsedMember(el, owner);
    }

    protected TypeElement findOwnerType(Element el) {
        TypeElement t;
        if (el instanceof TypeElement) {
            t = (TypeElement)el;
        } else {
            t = this.ci.getElementUtilities().enclosingTypeElement(el);
            if (t == null) {
                return null;
            }
        }
        ElementKind k = t.getKind();
        TypeMirror declType = this.ci.getTypes().erasure(t.asType());
        TypeElement enclType = this.enclosingType;
        while (enclType != null) {
            if (this.ci.getTypes().isSubtype(this.ci.getTypes().erasure(enclType.asType()), declType)) {
                if (k.isClass()) {
                    return enclType;
                }
                if (k != ElementKind.INTERFACE || !t.getModifiers().contains((Object)Modifier.DEFAULT)) break;
                return enclType;
            }
            enclType = this.ci.getElementUtilities().enclosingTypeElement((Element)enclType);
        }
        return null;
    }

    private TypeElement findEnclosingType(Element el) {
        return this.ci.getElementUtilities().enclosingTypeElement(el);
    }

    private void addInstanceForConstructor(Element el) {
        TypeElement pt = this.findEnclosingType(el);
        if (pt == null) {
            return;
        }
        switch (pt.getNestingKind()) {
            case ANONYMOUS: {
                break;
            }
            case LOCAL: {
                this.addLocalReference(pt);
                break;
            }
            case MEMBER: {
                if (pt.getModifiers().contains((Object)Modifier.STATIC)) break;
                this.addRequiredInstance((TypeElement)pt.getEnclosingElement());
            }
        }
    }

    public void process() {
        this.process(this.initPath);
    }

    public void process(TreePath path) {
        this.initPath = path;
        this.findEnclosingElement();
        if (this.enclosingElement == null || this.enclosingType == null) {
            return;
        }
        this.scan(this.initPath, null);
    }

    protected boolean isEnclosingType(TypeElement el) {
        Element e;
        if (el == null) {
            return false;
        }
        for (e = this.enclosingElement; e != null && e != el; e = e.getEnclosingElement()) {
        }
        return e != null;
    }

    private void addSuperInstance(TypeElement el) {
        if (this.isEnclosingType(el)) {
            if (this.superReferences.isEmpty()) {
                this.superReferences = new HashSet<TypeElement>();
            }
            this.superReferences.add(el);
        }
        this.addRequiredInstance(el);
    }

    private void addRequiredInstance(TypeElement el) {
        if (this.isEnclosingType(el)) {
            if (this.instancesRequired.isEmpty()) {
                this.instancesRequired = new HashSet<TypeElement>();
            }
            this.instancesRequired.add(el);
            return;
        }
    }

    private void addLocalClassVariable(Element el) {
        TypeMirror tm = el.asType();
        if (tm.getKind() != TypeKind.DECLARED) {
            return;
        }
        Element e = ((DeclaredType)tm).asElement();
        if (!(e instanceof TypeElement)) {
            return;
        }
        TypeElement t = (TypeElement)e;
        if (t.getNestingKind() == NestingKind.LOCAL) {
            this.addLocalReference(t);
        }
    }

    private void addInstanceForType(TypeElement t) {
        this.addRequiredInstance(t);
    }

    private void addInstanceOfTypeParameter(Element el) {
        Element parent = el.getEnclosingElement();
        if (parent.getKind().isClass() || parent.getKind().isInterface()) {
            this.addRequiredInstance((TypeElement)parent);
        }
    }

    protected void addUsedMember(Element el, TypeElement owner) {
        if (!this.isEnclosingType(owner)) {
            return;
        }
        this.usedMembers.add(el);
    }

    public Set<Element> getUsedMembers() {
        return this.usedMembers;
    }

    private void addInstanceOfParameterOwner(Element el) {
        while (el != null && el.getKind() != ElementKind.CONSTRUCTOR && el.getKind() != ElementKind.METHOD && !el.getKind().isClass() && !el.getKind().isInterface()) {
            el = el.getEnclosingElement();
        }
        if (el == null || el instanceof TypeElement || el == this.enclosingElement) {
            return;
        }
        this.addInstanceForMemberOf(el);
    }

    public Object visitIdentifier(IdentifierTree node, Object p) {
        Element el = this.ci.getTrees().getElement(this.getCurrentPath());
        if (el == null || el.asType() == null || el.asType().getKind() == TypeKind.ERROR) {
            return null;
        }
        switch (el.getKind()) {
            case LOCAL_VARIABLE: {
                this.addLocalClassVariable(el);
                this.addUsedMember(el, this.enclosingType);
                break;
            }
            case TYPE_PARAMETER: {
                this.addInstanceOfTypeParameter(el);
                break;
            }
            case FIELD: 
            case METHOD: {
                this.addInstanceForMemberOf(el);
                break;
            }
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case RECORD: {
                if (!node.getName().contentEquals("this") && !node.getName().contentEquals("super")) break;
                this.addInstanceForType(this.enclosingType);
                break;
            }
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: {
                this.addLocalClassVariable(el);
            }
            case PARAMETER: {
                this.addInstanceOfParameterOwner(el);
                break;
            }
            case PACKAGE: {
                break;
            }
            default: {
                this.addUsedMember(el, this.enclosingType);
            }
        }
        return super.visitIdentifier(node, p);
    }

    public Object visitMemberReference(MemberReferenceTree node, Object p) {
        return super.visitMemberReference(node, p);
    }

    private TypeElement findType(Tree selector) {
        TypeMirror tm = this.ci.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), selector));
        if (tm != null && tm.getKind() == TypeKind.DECLARED) {
            TypeElement t = (TypeElement)this.ci.getTypes().asElement(tm);
            ElementKind ek = t.getKind();
            if (!ek.isClass() && !ek.isInterface()) {
                return null;
            }
            return t;
        }
        return null;
    }

    public Object visitMemberSelect(MemberSelectTree node, Object p) {
        String exp = node.getExpression().toString();
        if (exp.equals("this") || exp.endsWith(".this")) {
            this.addInstanceForType(this.findType(node.getExpression()));
        } else if (exp.equals("super")) {
            this.addSuperInstance(this.enclosingType);
        } else if (exp.endsWith(".super")) {
            if (node.getExpression().getKind() == Tree.Kind.MEMBER_SELECT) {
                ExpressionTree t = ((MemberSelectTree)node.getExpression()).getExpression();
                this.addSuperInstance(this.findType(t));
            }
        } else if (node.getIdentifier().contentEquals("this")) {
            this.addInstanceForType(this.findType(node.getExpression()));
        } else {
            return super.visitMemberSelect(node, p);
        }
        return null;
    }

    public Object visitClass(ClassTree node, Object p) {
        TypeElement saveType = this.enclosingType;
        this.enclosingType = (TypeElement)this.ci.getTrees().getElement(this.getCurrentPath());
        Object o = super.visitClass(node, p);
        this.enclosingType = saveType;
        return o;
    }

    public Object visitNewClass(NewClassTree node, Object p) {
        Element e = this.ci.getTrees().getElement(this.getCurrentPath());
        if (e != null && e.getKind() == ElementKind.CONSTRUCTOR) {
            this.addInstanceForConstructor(e);
        }
        Object r = this.scan(node.getEnclosingExpression(), p);
        r = this.scanAndReduce(node.getIdentifier(), p, r);
        r = this.scanAndReduce(node.getTypeArguments(), p, r);
        r = this.scanAndReduce(node.getArguments(), p, r);
        if (e != null) {
            TypeElement saveType = this.enclosingType;
            this.enclosingType = this.ci.getElementUtilities().enclosingTypeElement(e);
            r = this.scanAndReduce(node.getClassBody(), p, r);
            this.enclosingType = saveType;
        }
        return r;
    }

    private Object scanAndReduce(Tree node, Object p, Object r) {
        return this.reduce(this.scan(node, p), r);
    }

    private Object scanAndReduce(Iterable<? extends Tree> nodes, Object p, Object r) {
        return this.reduce(this.scan(nodes, p), r);
    }
}

