/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.indent.api.embedding;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;

public final class JoinedTokenSequence<T1 extends TokenId> {
    List<TokenSequenceWrapper<T1>> tss;
    private int currentTokenSequence = -1;
    private TokenSequenceWrapper<T1> currentTSW;

    private JoinedTokenSequence(List<TokenSequenceWrapper<T1>> tss) {
        this.tss = tss;
    }

    public static <T1 extends TokenId> JoinedTokenSequence<T1> createFromTokenSequenceWrappers(List<TokenSequenceWrapper<T1>> tss) {
        return new JoinedTokenSequence<T1>(tss);
    }

    public static <T1 extends TokenId> JoinedTokenSequence<T1> createFromCodeBlocks(List<CodeBlock<T1>> codeBlocks) {
        ArrayList<TokenSequenceWrapper<T1>> tss = new ArrayList<TokenSequenceWrapper<T1>>();
        for (CodeBlock<T1> block : codeBlocks) {
            tss.addAll(block.tss);
        }
        return new JoinedTokenSequence<T1>(tss);
    }

    private void checkCurrentTokenSequence() {
        if (this.currentTokenSequence == -1) {
            throw new IllegalStateException("token position was no initialized. call moveStart or something");
        }
    }

    public Token<T1> token() {
        this.checkCurrentTokenSequence();
        return this.currentTokenSequence().token();
    }

    public TokenSequence<?> embedded() {
        this.checkCurrentTokenSequence();
        return this.currentTokenSequence().embedded();
    }

    public int[] index() {
        this.checkCurrentTokenSequence();
        return new int[]{this.currentTokenSequence, this.currentTokenSequence().index()};
    }

    private void setCurrentTokenSequenceIndex(int index) {
        this.currentTokenSequence = index;
        this.currentTSW = null;
    }

    public void moveIndex(int[] ind) {
        this.checkCurrentTokenSequence();
        assert (ind != null && ind.length == 2) : "not a valid index: " + ind;
        int tokenSequence = ind[0];
        if (tokenSequence < 0 || tokenSequence >= this.tss.size()) {
            throw new IllegalStateException("token sequence index " + tokenSequence + " is out of boundaries " + this.tss.size());
        }
        this.setCurrentTokenSequenceIndex(tokenSequence);
        this.currentTokenSequence().moveIndex(ind[1]);
    }

    public TokenSequence<T1> currentTokenSequence() {
        this.checkCurrentTokenSequence();
        return this.getTokenSequenceWrapper().getTokenSequence();
    }

    public boolean isCurrentTokenSequenceVirtual() {
        this.checkCurrentTokenSequence();
        return this.getTokenSequenceWrapper().isVirtual();
    }

    private TokenSequenceWrapper<T1> getTokenSequenceWrapper() {
        if (this.currentTSW == null) {
            this.currentTSW = this.tss.get(this.currentTokenSequence);
        }
        return this.currentTSW;
    }

    public List<TokenSequenceWrapper<T1>> getContextDataTokenSequences() {
        return this.tss;
    }

    public void moveStart() {
        this.setCurrentTokenSequenceIndex(0);
        this.currentTokenSequence().moveStart();
    }

    public void moveEnd() {
        this.setCurrentTokenSequenceIndex(this.tss.size() - 1);
        this.currentTokenSequence().moveEnd();
    }

    public boolean moveNext() {
        this.checkCurrentTokenSequence();
        boolean moreTokens = this.currentTokenSequence().moveNext();
        if (!moreTokens) {
            if (this.currentTokenSequence < this.tss.size() - 1) {
                this.setCurrentTokenSequenceIndex(this.currentTokenSequence + 1);
                this.currentTokenSequence().moveStart();
                this.moveNext();
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean movePrevious() {
        this.checkCurrentTokenSequence();
        boolean moreTokens = this.currentTokenSequence().movePrevious();
        if (!moreTokens) {
            if (this.currentTokenSequence > 0) {
                this.setCurrentTokenSequenceIndex(this.currentTokenSequence - 1);
                this.currentTokenSequence().moveEnd();
                this.movePrevious();
            } else {
                return false;
            }
        }
        return true;
    }

    private int findNearbyTokenSequenceIndexForOffset(int offset) {
        int end = this.tss.size() - 1;
        int start = 0;
        while (end - start >= 10) {
            int middle = start + (end - start) / 2;
            TokenSequenceWrapper<T1> middleItem = this.tss.get(middle);
            while (middleItem.isVirtual() && middle > 0) {
                middleItem = this.tss.get(--middle);
            }
            if (middle == 0) {
                return 0;
            }
            if (offset >= middleItem.getStart() && offset <= middleItem.getEnd()) {
                return middle;
            }
            if (offset > middleItem.getEnd()) {
                start = middle;
                continue;
            }
            end = middle;
        }
        return start;
    }

    public int move(int offset) {
        int start;
        for (int i = start = this.findNearbyTokenSequenceIndexForOffset(offset); i < this.tss.size(); ++i) {
            TokenSequenceWrapper<T1> cdts = this.tss.get(i);
            if (cdts.isVirtual() || offset < cdts.getStart() || offset > cdts.getEnd()) continue;
            this.setCurrentTokenSequenceIndex(i);
            return this.currentTokenSequence().move(offset);
        }
        return Integer.MIN_VALUE;
    }

    public boolean move(int offset, boolean forward) {
        int start;
        int previous = -1;
        for (int i = start = this.findNearbyTokenSequenceIndexForOffset(offset); i < this.tss.size(); ++i) {
            TokenSequenceWrapper<T1> cdts = this.tss.get(i);
            if (cdts.isVirtual()) continue;
            if (offset >= cdts.getStart() && offset <= cdts.getEnd()) {
                this.setCurrentTokenSequenceIndex(i);
                this.currentTokenSequence().move(offset);
                return true;
            }
            if (forward && cdts.getStart() > offset) {
                this.setCurrentTokenSequenceIndex(i);
                this.currentTokenSequence().moveStart();
                return true;
            }
            if (!forward) {
                if (cdts.getStart() > offset) {
                    if (previous != -1) {
                        this.setCurrentTokenSequenceIndex(previous);
                        this.currentTokenSequence().moveEnd();
                        return true;
                    }
                    return false;
                }
                if (i == this.tss.size() - 1 && cdts.getEnd() < offset) {
                    this.setCurrentTokenSequenceIndex(i);
                    this.currentTokenSequence().moveEnd();
                    return true;
                }
            }
            previous = i;
        }
        return false;
    }

    public int offset() {
        this.checkCurrentTokenSequence();
        if (this.isCurrentTokenSequenceVirtual()) {
            assert (this.currentTokenSequence > 0);
            TokenSequenceWrapper<T1> cdts = this.tss.get(this.currentTokenSequence - 1);
            return cdts.getEnd();
        }
        return this.currentTokenSequence().offset();
    }

    public Language<T1> language() {
        this.checkCurrentTokenSequence();
        return this.currentTokenSequence().language();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (TokenSequenceWrapper<T1> cdts : this.tss) {
            String s = "";
            if (this.currentTokenSequence != -1 && cdts == this.getTokenSequenceWrapper()) {
                s = "CURRENT,";
            }
            sb.append("ContextDataTokenSequence[" + s + "ts=" + cdts.getTokenSequence().toString() + ",virtual=" + cdts.isVirtual() + "],");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return "JoinedTokenSequence[" + sb.toString() + "]";
    }

    public static final class CodeBlock<T1 extends TokenId> {
        public List<TokenSequenceWrapper<T1>> tss;

        public CodeBlock(List<TokenSequenceWrapper<T1>> tss) {
            this.tss = tss;
        }

        public String toString() {
            return "CodeBlock[tss=" + this.tss + "]";
        }
    }

    public static final class TokenSequenceWrapper<T1 extends TokenId> {
        private TokenSequence<T1> ts;
        private boolean virtual;
        private int start;
        private int end;

        public TokenSequenceWrapper(TokenSequence<T1> ts, boolean virtual) {
            this.ts = ts;
            this.virtual = virtual;
            ts.moveStart();
            ts.moveNext();
            this.start = ts.offset();
            ts.moveEnd();
            ts.movePrevious();
            this.end = ts.offset() + ts.token().length();
        }

        public TokenSequence<T1> getTokenSequence() {
            return this.ts;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }

        public boolean isVirtual() {
            return this.virtual;
        }

        public String toString() {
            return "ContextDataTokenSequence[ts=" + this.ts + ",virtual=" + this.virtual + "]";
        }
    }
}

