/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.List;
import org.apache.lucene.document.ShapeDocValues;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.util.BytesRef;

public final class XYShapeDocValues
extends ShapeDocValues {
    protected XYShapeDocValues(List<ShapeField.DecodedTriangle> tessellation) {
        super(tessellation);
    }

    protected XYShapeDocValues(BytesRef binaryValue) {
        super(binaryValue);
    }

    @Override
    public XYPoint getCentroid() {
        return (XYPoint)this.centroid;
    }

    @Override
    public XYRectangle getBoundingBox() {
        return (XYRectangle)this.boundingBox;
    }

    @Override
    protected XYPoint computeCentroid() {
        ShapeDocValues.Encoder encoder = this.getEncoder();
        return new XYPoint((float)encoder.decodeX(this.getEncodedCentroidX()), (float)encoder.decodeY(this.getEncodedCentroidY()));
    }

    @Override
    protected XYRectangle computeBoundingBox() {
        ShapeDocValues.Encoder encoder = this.getEncoder();
        return new XYRectangle((float)encoder.decodeX(this.getEncodedMinX()), (float)encoder.decodeX(this.getEncodedMaxX()), (float)encoder.decodeY(this.getEncodedMinY()), (float)encoder.decodeY(this.getEncodedMaxY()));
    }

    @Override
    protected ShapeDocValues.Encoder getEncoder() {
        return new ShapeDocValues.Encoder(this){

            @Override
            public int encodeX(double x) {
                return XYEncodingUtils.encode((float)x);
            }

            @Override
            public int encodeY(double y) {
                return XYEncodingUtils.encode((float)y);
            }

            @Override
            public double decodeX(int encoded) {
                return XYEncodingUtils.decode(encoded);
            }

            @Override
            public double decodeY(int encoded) {
                return XYEncodingUtils.decode(encoded);
            }
        };
    }
}

