/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.sender_icon_cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mediathek.gui.messages.SenderIconStyleChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.sender_icon_cache.SenderIconCacheLoader;
import mediathek.tool.timer.TimerPool;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\bH\u0087\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmediathek/tool/sender_icon_cache/MVSenderIconCache;", "", "<init>", "()V", "useLocalIcons", "Ljava/util/concurrent/atomic/AtomicBoolean;", "senderCache", "Lcom/google/common/cache/LoadingCache;", "", "Ljava/util/Optional;", "Ljavax/swing/ImageIcon;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "CONFIG_USE_LOCAL_SENDER_ICONS", "handleSenderIconStyleChangedEvent", "", "e", "Lmediathek/gui/messages/SenderIconStyleChangedEvent;", "setupCleanupScheduler", "get", "sender", "MediathekView"})
public final class MVSenderIconCache {
    @NotNull
    public static final MVSenderIconCache INSTANCE = new MVSenderIconCache();
    @NotNull
    private static final AtomicBoolean useLocalIcons = new AtomicBoolean(false);
    @NotNull
    private static final LoadingCache<String, Optional<ImageIcon>> senderCache;
    private static final Logger logger;
    @NotNull
    public static final String CONFIG_USE_LOCAL_SENDER_ICONS = "application.sender_icons.use_local";

    private MVSenderIconCache() {
    }

    @Handler
    private final void handleSenderIconStyleChangedEvent(SenderIconStyleChangedEvent e) {
        logger.trace("invalidating caches due to sender icon style change");
        useLocalIcons.set(ApplicationConfiguration.getConfiguration().getBoolean(CONFIG_USE_LOCAL_SENDER_ICONS, false));
        senderCache.invalidateAll();
    }

    private final void setupCleanupScheduler() {
        TimerPool.getTimerPool().scheduleAtFixedRate(MVSenderIconCache::setupCleanupScheduler$lambda$0, 5L, 5L, TimeUnit.MINUTES);
    }

    @JvmStatic
    @NotNull
    public static final Optional<ImageIcon> get(@NotNull String sender) {
        Optional<ImageIcon> optional;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        try {
            optional = senderCache.get((Object)sender);
            Intrinsics.checkNotNull((Object)optional);
        }
        catch (CacheLoader.InvalidCacheLoadException invalidCacheLoadException) {
            Optional<ImageIcon> optional2 = Optional.empty();
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        }
        catch (ExecutionException executionException) {
            Optional optional3 = Optional.empty();
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        }
        return optional;
    }

    private static final void setupCleanupScheduler$lambda$0() {
        logger.trace("Cleaning sender icon caches");
        senderCache.cleanUp();
    }

    static {
        logger = LogManager.getLogger();
        logger.trace("Initializing sender icon cache...");
        INSTANCE.setupCleanupScheduler();
        LoadingCache loadingCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new SenderIconCacheLoader(useLocalIcons));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        senderCache = loadingCache;
        MessageBus.getMessageBus().subscribe((Object)INSTANCE);
        useLocalIcons.set(ApplicationConfiguration.getConfiguration().getBoolean(CONFIG_USE_LOCAL_SENDER_ICONS, false));
    }
}

